/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.driver.Action;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.Driver;
import org.clang.driver.JobAction;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.options;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;

public final class MinGWStatics {

    public static class Linker
    extends Tool
    implements Destructors.ClassWithDestructor {
        public Linker(ToolChain TC) {
            super(NativePointer.$((String)"MinGW::Linker"), NativePointer.$((String)"linker"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        @Override
        public boolean isLinkJob() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                ToolChain TC = this.getToolChain();
                Driver D = TC.getDriver();
                ArgStringList CmdArgs = new ArgStringList();
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_g_Group.getValue()));
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_emit_llvm.getValue()));
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_w.getValue()));
                StringRef LinkerName = Args.getLastArgValue(new OptSpecifier(options.ID.OPT_fuse_ld_EQ.getValue()), new StringRef("ld"));
                if (LinkerName.equals_lower("lld")) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-flavor"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"gnu"));
                } else if (!LinkerName.equals_lower("ld")) {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(363))), (StringRef)LinkerName));
                }
                if (!D.SysRoot.empty()) {
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_str$C((String)"--sysroot=", (std.string)D.SysRoot))));
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_s.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-s"));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                if (TC.getArch() == Triple.ArchType.x86) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"i386pe"));
                }
                if (TC.getArch() == Triple.ArchType.x86_64) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"i386pep"));
                }
                if (TC.getArch() == Triple.ArchType.arm) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"thumb2pe"));
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_mwindows.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"--subsystem"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"windows"));
                } else if (Args.hasArg(new OptSpecifier(options.ID.OPT_mconsole.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"--subsystem"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"console"));
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Bstatic"));
                } else {
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_mdll.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--dll"));
                    } else if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--shared"));
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Bdynamic"));
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_mdll.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-e"));
                        if (TC.getArch() == Triple.ArchType.x86) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"_DllMainCRTStartup@12"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"DllMainCRTStartup"));
                        }
                        CmdArgs.push_back((Object)NativePointer.$((String)"--enable-auto-image-base"));
                    }
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_e.getValue()));
                Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_r.getValue()));
                Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_s.getValue()));
                Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_t.getValue()));
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_u_Group.getValue()));
                Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_Z_Flag.getValue()));
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nostartfiles.getValue()))) {
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_mdll.getValue()))) {
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(TC.GetFilePath(NativePointer.$((String)"dllcrt2.o")))));
                    } else if (Args.hasArg(new OptSpecifier(options.ID.OPT_municode.getValue()))) {
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(TC.GetFilePath(NativePointer.$((String)"crt2u.o")))));
                    } else {
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(TC.GetFilePath(NativePointer.$((String)"crt2.o")))));
                    }
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(TC.GetFilePath(NativePointer.$((String)"gcrt2.o")))));
                    }
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(TC.GetFilePath(NativePointer.$((String)"crtbegin.o")))));
                }
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_L.getValue()));
                TC.AddFilePathLibArgs(Args, CmdArgs);
                ToolsStatics.AddLinkerInputs(TC, Inputs, Args, CmdArgs);
                if (D.CCCIsCXX() && !Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nodefaultlibs.getValue()))) {
                    boolean OnlyLibstdcxxStatic;
                    boolean bl = OnlyLibstdcxxStatic = Args.hasArg(new OptSpecifier(options.ID.OPT_static_libstdcxx.getValue())) && !Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()));
                    if (OnlyLibstdcxxStatic) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Bstatic"));
                    }
                    TC.AddCXXStdlibLibArgs(Args, CmdArgs);
                    if (OnlyLibstdcxxStatic) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Bdynamic"));
                    }
                }
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()))) {
                    if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nodefaultlibs.getValue()))) {
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"--start-group"));
                        }
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_fstack_protector.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_fstack_protector_strong.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_fstack_protector_all.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lssp_nonshared"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lssp"));
                        }
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_fopenmp.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lgomp"));
                        }
                        this.AddLibGCC(Args, CmdArgs);
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lgmon"));
                        }
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_pthread.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread"));
                        }
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_mwindows.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lgdi32"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lcomdlg32"));
                        }
                        CmdArgs.push_back((Object)NativePointer.$((String)"-ladvapi32"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lshell32"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-luser32"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lkernel32"));
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"--end-group"));
                        } else if (!LinkerName.equals_lower("lld")) {
                            this.AddLibGCC(Args, CmdArgs);
                        }
                    }
                    if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostartfiles.getValue()))) {
                        TC.AddFastMathRuntimeIfAvailable(Args, CmdArgs);
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(TC.GetFilePath(NativePointer.$((String)"crtend.o")))));
                    }
                }
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(TC.GetProgramPath(LinkerName.data()))));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }

        private void AddLibGCC(ArgList Args, ArgStringList CmdArgs) {
            if (Args.hasArg(new OptSpecifier(options.ID.OPT_mthreads.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lmingwthrd"));
            }
            CmdArgs.push_back((Object)NativePointer.$((String)"-lmingw32"));
            ToolChain.RuntimeLibType RLT = this.getToolChain().GetRuntimeLibType(Args);
            if (RLT == ToolChain.RuntimeLibType.RLT_Libgcc) {
                boolean Static = Args.hasArg(new OptSpecifier(options.ID.OPT_static_libgcc.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()));
                boolean Shared = Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()));
                boolean CXX = this.getToolChain().getDriver().CCCIsCXX();
                if (Static || !CXX && !Shared) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_eh"));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_s"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
                }
            } else {
                ToolsStatics.AddRunTimeLibs(this.getToolChain(), this.getToolChain().getDriver(), CmdArgs, Args);
            }
            CmdArgs.push_back((Object)NativePointer.$((String)"-lmoldname"));
            CmdArgs.push_back((Object)NativePointer.$((String)"-lmingwex"));
            CmdArgs.push_back((Object)NativePointer.$((String)"-lmsvcrt"));
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Assembler
    extends Tool
    implements Destructors.ClassWithDestructor {
        public Assembler(ToolChain TC) {
            super(NativePointer.$((String)"MinGW::Assemble"), NativePointer.$((String)"assembler"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                ToolsStatics.claimNoWarnArgs(Args);
                ArgStringList CmdArgs = new ArgStringList();
                if (this.getToolChain().getArch() == Triple.ArchType.x86) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"--32"));
                } else if (this.getToolChain().getArch() == Triple.ArchType.x86_64) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"--64"));
                }
                Args.AddAllArgValues(CmdArgs, new OptSpecifier(options.ID.OPT_Wa_COMMA.getValue()), new OptSpecifier(options.ID.OPT_Xassembler.getValue()));
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                for (InputInfo II : Inputs) {
                    CmdArgs.push_back((Object)II.getFilename());
                }
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(this.getToolChain().GetProgramPath(NativePointer.$((String)"as")))));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_gsplit_dwarf.getValue()))) {
                    ToolsStatics.SplitDebugInfo(this.getToolChain(), C, this, JA, Args, Output, ToolsStatics.SplitDebugName(Args, (InputInfo)Inputs.$at(0)));
                }
            }
            finally {
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }
}

