/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli;

import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.git.remote.cli.GitClient;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.JGitConfig;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public final class GitRepository {
    private static final Map<VCSFileProxy, GitRepository> repositoryPool = new WeakHashMap<VCSFileProxy, GitRepository>(5);
    private final VCSFileProxy repositoryLocation;
    private JGitRepository gitRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized GitRepository getInstance(VCSFileProxy repositoryLocation) {
        Map<VCSFileProxy, GitRepository> map = repositoryPool;
        synchronized (map) {
            GitRepository repository = repositoryPool.get(repositoryLocation);
            if (repository == null) {
                repository = new GitRepository(repositoryLocation);
                repositoryPool.put(repositoryLocation, repository);
            }
            return repository;
        }
    }

    private GitRepository(VCSFileProxy repositoryLocation) {
        this.repositoryLocation = repositoryLocation;
    }

    public synchronized GitClient createClient() throws GitException {
        this.getRepository();
        return this.createClient(this.gitRepository);
    }

    public FastForwardOption getDefaultFastForwardOption() throws GitException {
        JGitRepository repository = this.getRepository();
        JGitConfig config = repository.getConfig();
        config.load();
        String string = config.getString("merge", null, "ff");
        if ("only".equals(string)) {
            return FastForwardOption.FAST_FORWARD_ONLY;
        }
        if ("false".equals(string)) {
            return FastForwardOption.NO_FAST_FORWARD;
        }
        return FastForwardOption.FAST_FORWARD;
    }

    private synchronized JGitRepository getRepository() {
        if (this.gitRepository == null) {
            this.gitRepository = new JGitRepository(this.repositoryLocation);
        }
        return this.gitRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearRepositoryPool() {
        Map<VCSFileProxy, GitRepository> map = repositoryPool;
        synchronized (map) {
            repositoryPool.clear();
        }
    }

    private GitClient createClient(JGitRepository repository) throws GitException {
        return new GitClient(repository);
    }

    public static enum FastForwardOption {
        FAST_FORWARD{

            public String toString() {
                return "--ff";
            }
        }
        ,
        FAST_FORWARD_ONLY{

            public String toString() {
                return "--ff-only";
            }
        }
        ,
        NO_FAST_FORWARD{

            public String toString() {
                return "--no-ff";
            }
        };

    }
}

