/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitUser;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public final class GitRevisionInfo {
    private static final Logger LOG = Logger.getLogger(GitRevisionInfo.class.getName());
    private JGitRepository repository;
    private final Map<String, GitBranch> branches;
    private GitFileInfo[] modifiedFiles;
    private String shortMessage;
    private String branch;
    private String revisionCode;
    private String message;
    private String autorAndMail;
    private String commiterAndMail;
    private String autorTime;
    private String commiterTime;
    private String[] parents;
    private String treeCode;

    GitRevisionInfo(GitRevCommit status, JGitRepository repository) {
        this(status, Collections.emptyMap(), repository);
    }

    GitRevisionInfo(GitRevCommit status, Map<String, GitBranch> affectedBranches, JGitRepository repository) {
        this.branch = status.branch;
        this.branches = affectedBranches;
        this.revisionCode = status.revisionCode;
        this.treeCode = status.treeCode;
        this.message = status.message;
        this.autorAndMail = status.autorAndMail;
        this.autorTime = status.autorTime;
        this.modifiedFiles = new GitFileInfo[status.commitedFiles.size()];
        int i = 0;
        for (Map.Entry<String, GitFileInfo.Status> entry : status.commitedFiles.entrySet()) {
            VCSFileProxy file = VCSFileProxy.createFileProxy((VCSFileProxy)repository.getLocation(), (String)entry.getKey());
            GitFileInfo info = new GitFileInfo(file, entry.getKey(), entry.getValue(), null, null);
            this.modifiedFiles[i++] = info;
        }
        this.parents = status.parents.toArray(new String[status.parents.size()]);
        this.commiterAndMail = status.commiterAndMail;
        this.commiterTime = status.commiterTime;
        this.repository = repository;
    }

    public String getRevision() {
        return this.revisionCode;
    }

    public String getTree() {
        return this.treeCode;
    }

    public String getShortMessage() {
        if (this.shortMessage == null) {
            String msg = this.message;
            StringBuilder sb = new StringBuilder();
            boolean empty = true;
            for (int pos = 0; pos < msg.length(); ++pos) {
                char c = msg.charAt(pos);
                if (c == '\r' || c == '\n') {
                    if (empty) continue;
                    break;
                }
                sb.append(c);
                empty = false;
            }
            this.shortMessage = sb.toString();
        }
        return this.shortMessage;
    }

    public String getFullMessage() {
        return this.message;
    }

    public long getCommitTime() {
        if (this.commiterTime != null) {
            String[] s = this.commiterTime.split(" ");
            long res = Long.parseLong(s[0]) * 1000L;
            return res;
        }
        return -1L;
    }

    public long getAuthorTime() {
        if (this.autorTime != null) {
            String[] s = this.autorTime.split(" ");
            long res = Long.parseLong(s[0]) * 1000L;
            return res;
        }
        return -1L;
    }

    public GitUser getAuthor() {
        if (this.autorAndMail != null) {
            int i = this.autorAndMail.indexOf(60);
            return new GitUser(this.autorAndMail.substring(0, i).trim(), this.autorAndMail.substring(i + 1, this.autorAndMail.length() - 1));
        }
        return null;
    }

    public GitUser getCommitter() {
        if (this.commiterAndMail != null) {
            int i = this.commiterAndMail.indexOf(60);
            return new GitUser(this.commiterAndMail.substring(0, i).trim(), this.commiterAndMail.substring(i + 1, this.commiterAndMail.length() - 1));
        }
        return null;
    }

    public Map<VCSFileProxy, GitFileInfo> getModifiedFiles() throws GitException {
        HashMap<VCSFileProxy, GitFileInfo> files = new HashMap<VCSFileProxy, GitFileInfo>(this.modifiedFiles.length);
        for (GitFileInfo info : this.modifiedFiles) {
            files.put(info.getFile(), info);
        }
        return files;
    }

    public String[] getParents() {
        return this.parents;
    }

    public Map<String, GitBranch> getBranches() {
        return this.branches;
    }

    public static final class GitRevCommit {
        public String branch;
        public String revisionCode;
        public String treeCode;
        public String message;
        public String autorAndMail;
        public String autorTime;
        public String commiterAndMail;
        public String commiterTime;
        public LinkedHashMap<String, GitFileInfo.Status> commitedFiles = new LinkedHashMap();
        public ArrayList<String> parents = new ArrayList();
    }

    public static final class GitFileInfo {
        private final String relativePath;
        private final String originalPath;
        private final Status status;
        private final VCSFileProxy file;
        private final VCSFileProxy originalFile;

        GitFileInfo(VCSFileProxy file, String relativePath, Status status, VCSFileProxy originalFile, String originalPath) {
            this.relativePath = relativePath;
            this.status = status;
            this.file = file;
            this.originalFile = originalFile;
            this.originalPath = originalPath;
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        public String getOriginalPath() {
            return this.originalPath;
        }

        public Status getStatus() {
            return this.status;
        }

        public VCSFileProxy getFile() {
            return this.file;
        }

        public VCSFileProxy getOriginalFile() {
            return this.originalFile;
        }

        public static enum Status {
            ADDED,
            MODIFIED,
            RENAMED,
            COPIED,
            REMOVED,
            UNKNOWN;

        }
    }
}

