/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.javacard.common.WaitNode;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class GuiUtils {
    public static void prepareContainer(Container c) {
        GuiUtils.prepareContainer(c, new FL());
    }

    private static void prepareContainer(Container c, FocusListener fl) {
        if (c instanceof AbstractButton) {
            AbstractButton ab = (AbstractButton)c;
            if (ab.getText().contains("&")) {
                Mnemonics.setLocalizedText((AbstractButton)ab, (String)ab.getText());
            }
        } else if (c instanceof JLabel) {
            JLabel l = (JLabel)c;
            if (l.getText().contains("&")) {
                Mnemonics.setLocalizedText((JLabel)l, (String)l.getText());
            }
        } else if (c instanceof JTextComponent) {
            JTextComponent jt = (JTextComponent)c;
            jt.addFocusListener(fl);
        } else if (c instanceof JPanel || c instanceof JScrollPane || c instanceof JTabbedPane || c instanceof JSplitPane || c instanceof JViewport || c instanceof JLayeredPane || c instanceof JFrame || c instanceof JDialog || c instanceof JRootPane) {
            for (Component cc : c.getComponents()) {
                if (!(cc instanceof Container)) continue;
                GuiUtils.prepareContainer((Container)cc);
            }
        }
    }

    public static void filterNonHexadecimalKeys(JTextComponent comp) {
        comp.addKeyListener(new HexKeyFilter());
    }

    public static void filterNonNumericKeys(JTextComponent comp) {
        comp.addKeyListener(new NumberKeyFilter());
    }

    public static void stopFilteringNonHexadecimalKeys(JTextComponent comp) {
        for (KeyListener kl : comp.getKeyListeners()) {
            if (!(kl instanceof HexKeyFilter)) continue;
            comp.removeKeyListener(kl);
            break;
        }
    }

    public static JDialog createModalProgressDialog(ProgressHandle handle, boolean includeDetail) {
        assert (EventQueue.isDispatchThread());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)ProgressHandleFactory.createMainLabelComponent((ProgressHandle)handle), "South");
        panel.add((Component)ProgressHandleFactory.createProgressComponent((ProgressHandle)handle), "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        panel.setSize(new Dimension(400, 100));
        panel.setPreferredSize(new Dimension(400, 50));
        JDialog dlg = new JDialog(WindowManager.getDefault().getMainWindow(), true);
        dlg.setSize(400, 100);
        dlg.getContentPane().setLayout(new BorderLayout());
        dlg.getContentPane().add((Component)panel, "Center");
        if (includeDetail) {
            dlg.getContentPane().add(ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)handle));
        }
        dlg.setDefaultCloseOperation(0);
        dlg.setAlwaysOnTop(true);
        dlg.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        return dlg;
    }

    public static void showProgressDialogAndRun(ProgressHandle handle, final Runnable run, boolean includeDetail) {
        final JDialog dlg = GuiUtils.createModalProgressDialog(handle, includeDetail);
        class WR
        extends WindowAdapter
        implements Runnable {
            WR() {
            }

            @Override
            public void run() {
                if (!EventQueue.isDispatchThread()) {
                    try {
                        run.run();
                    }
                    finally {
                        EventQueue.invokeLater(this);
                    }
                } else {
                    dlg.setVisible(false);
                    dlg.dispose();
                }
            }

            @Override
            public void windowOpened(WindowEvent e) {
                RequestProcessor.getDefault().post((Runnable)this);
            }
        }
        WR wr = new WR();
        dlg.addWindowListener(wr);
        dlg.setVisible(true);
    }

    public static Node createWaitNode() {
        return new WaitNode();
    }

    private static class HexKeyFilter
    extends KeyAdapter {
        private HexKeyFilter() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (!this.allowed(e.getKeyChar())) {
                Toolkit.getDefaultToolkit().beep();
                e.consume();
            } else {
                e.setKeyChar(Character.toUpperCase(e.getKeyChar()));
            }
        }

        protected boolean allowed(char c) {
            return c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
        }
    }

    private static final class NumberKeyFilter
    extends HexKeyFilter {
        private NumberKeyFilter() {
        }

        @Override
        protected boolean allowed(char c) {
            return c >= '0' && c <= '9';
        }
    }

    private static final class FL
    extends FocusAdapter {
        private FL() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            JTextComponent jt = (JTextComponent)e.getComponent();
            jt.selectAll();
        }
    }
}

