/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.blame;

import java.util.logging.Level;
import org.netbeans.modules.git.remote.cli.GitLineDetails;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.GitUser;
import org.netbeans.modules.git.remote.ui.blame.AnnotationBar;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.NbBundle;

public class AnnotateLine {
    private final GitUser author;
    private final String authorShort;
    private final GitUser committer;
    private final GitRevisionInfo revision;
    private final VCSFileProxy file;
    private final String content;
    private final int lineNum;
    private final int sourceLine;
    private boolean canBeRolledBack = true;
    private static final String fakeItem = NbBundle.getMessage(AnnotateLine.class, (String)"MSG_AnnotateAction.lineDetail.unknown");

    AnnotateLine(GitLineDetails lineDetails, int lineNumber) {
        if (lineDetails == null) {
            this.revision = null;
            this.author = null;
            this.authorShort = fakeItem;
            this.committer = null;
            this.content = fakeItem;
            this.file = null;
            this.sourceLine = -1;
        } else {
            this.revision = lineDetails.getRevisionInfo();
            this.author = lineDetails.getAuthor() == null ? lineDetails.getCommitter() : lineDetails.getAuthor();
            this.authorShort = this.getAuthorShort(this.author);
            this.committer = lineDetails.getCommitter();
            String cont = lineDetails.getContent().replace("\r", "").replace("\n", "");
            if (cont.length() != lineDetails.getContent().length() && AnnotationBar.LOG.isLoggable(Level.FINE)) {
                AnnotationBar.LOG.log(Level.FINE, "AnnotateLine: line content contains '\\r' or '\\n': {0}:{1}", new Object[]{lineDetails.getSourceFile(), lineNumber});
            }
            this.content = cont;
            this.file = lineDetails.getSourceFile();
            this.sourceLine = lineDetails.getSourceLine();
        }
        this.lineNum = lineNumber;
    }

    public GitUser getAuthor() {
        return this.author;
    }

    public VCSFileProxy getFile() {
        return this.file;
    }

    public GitRevisionInfo getRevisionInfo() {
        return this.revision;
    }

    public String getContent() {
        return this.content;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public int getSourceLineNum() {
        return this.sourceLine;
    }

    public boolean canBeRolledBack() {
        return this.canBeRolledBack;
    }

    public void setCanBeRolledBack(boolean canBeRolledBack) {
        this.canBeRolledBack = canBeRolledBack;
    }

    public String getAuthorShort() {
        return this.authorShort;
    }

    private String getAuthorShort(GitUser author) {
        int pos;
        if (author == null) {
            return fakeItem;
        }
        String shortened = null;
        String email = author.getEmailAddress();
        if (email != null && (pos = email.indexOf(64)) > -1) {
            shortened = email.substring(0, pos);
        }
        if (shortened == null && (shortened = author.toString()).length() > 10 && (pos = shortened.indexOf(32, 7)) > 0 && pos <= 10) {
            shortened = shortened.substring(0, pos);
        }
        if (shortened.length() > 10) {
            shortened = shortened.substring(0, 7) + "...";
        }
        return shortened;
    }
}

