/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.blame;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.netbeans.modules.git.remote.ui.blame.AnnotateLine;

public final class LinesReader
extends Reader {
    private final List lines;
    private int lineIndex;
    private int columnIndex;
    private boolean closed;

    LinesReader(List lines) {
        this.lines = lines;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("Closed");
        }
        this.closed = true;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Closed");
        }
        if (this.lineIndex >= this.lines.size()) {
            return -1;
        }
        AnnotateLine aline = (AnnotateLine)this.lines.get(this.lineIndex);
        String line = aline.getContent() + "\n";
        int lineLen = line.length();
        int unread = lineLen - this.columnIndex;
        int toRead = Math.min(unread, len);
        line.getChars(this.columnIndex, this.columnIndex + toRead, cbuf, off);
        this.columnIndex += toRead;
        if (this.columnIndex >= lineLen) {
            this.columnIndex = 0;
            ++this.lineIndex;
        }
        return toRead;
    }
}

