/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.rebase;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.ui.rebase.BasicPanel;
import org.netbeans.modules.git.remote.ui.rebase.Bundle;
import org.netbeans.modules.git.remote.ui.rebase.SelectDestPanel;
import org.netbeans.modules.git.remote.ui.repository.Revision;
import org.netbeans.modules.git.remote.ui.repository.RevisionPicker;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

abstract class RebaseKind {
    private final String id;
    private final PropertyChangeSupport support;
    private boolean valid;

    public RebaseKind(String id) {
        this.id = id;
        this.support = new PropertyChangeSupport(this);
    }

    public abstract String getDisplayName();

    public abstract String getDescription();

    public abstract JPanel getPanel();

    public abstract String getUpstream();

    public abstract String getSource();

    public abstract String getDest();

    public final String getId() {
        return this.id;
    }

    public final void addPropertyChangeListener(PropertyChangeListener list) {
        this.support.addPropertyChangeListener(list);
    }

    protected final void setValid(boolean valid) {
        boolean oldValid = this.valid;
        this.valid = valid;
        this.support.firePropertyChange("rebase.propValid", oldValid, valid);
    }

    public final boolean isValid() {
        return this.valid;
    }

    protected static void setRevision(JTextField tf, GitBranch branch) {
        tf.setText(branch.getName() + " (" + branch.getId().substring(0, 7) + ")");
    }

    protected static void setRevision(JTextField tf, Revision revision) {
        tf.setText(revision.toString(true));
    }

    public static class SelectDestinationKind
    extends RebaseKind
    implements ActionListener {
        private final SelectDestPanel panel;
        private final GitBranch currentBranch;
        private Revision dest;
        private final VCSFileProxy repository;

        public SelectDestinationKind(VCSFileProxy repository, GitBranch currentBranch) {
            super(SelectDestinationKind.class.getName());
            this.repository = repository;
            this.panel = new SelectDestPanel();
            this.currentBranch = currentBranch;
            this.initialize(currentBranch);
            this.attachListeners();
        }

        @Override
        public String getDisplayName() {
            return Bundle.LBL_RebaseKind_destination_displayName();
        }

        @Override
        public String getDescription() {
            return Bundle.LBL_RebaseKind_destination_description();
        }

        @Override
        public JPanel getPanel() {
            return this.panel;
        }

        @Override
        public String getUpstream() {
            return this.dest.getRevision();
        }

        @Override
        public String getSource() {
            return this.currentBranch.getName();
        }

        @Override
        public String getDest() {
            return this.dest.getRevision();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RevisionPicker picker;
            if (e.getSource() == this.panel.btnBrowse && (picker = new RevisionPicker(this.repository, new VCSFileProxy[0])).open()) {
                this.dest = picker.getRevision();
                this.updateLabels();
            }
        }

        private void initialize(GitBranch currentBranch) {
            SelectDestinationKind.setRevision(this.panel.tfBaseRevision, currentBranch);
            boolean valid = false;
            GitBranch trackedBranch = currentBranch.getTrackedBranch();
            if (trackedBranch == null) {
                this.dest = null;
                this.panel.tfDestinationRevision.setText(Bundle.MSG_RebaseKind_Basic_unknownTrackedBranch());
            } else {
                this.dest = new Revision.BranchReference(trackedBranch);
                SelectDestinationKind.setRevision(this.panel.tfDestinationRevision, currentBranch.getTrackedBranch());
                valid = !currentBranch.getId().equals(currentBranch.getTrackedBranch().getId());
            }
            this.setValid(valid);
        }

        private void updateLabels() {
            SelectDestinationKind.setRevision(this.panel.tfDestinationRevision, this.dest);
            this.setValid(!this.currentBranch.getId().equals(this.dest.getCommitId()));
        }

        private void attachListeners() {
            this.panel.btnBrowse.addActionListener(this);
        }
    }

    public static class BasicKind
    extends RebaseKind {
        private final BasicPanel basicPanel = new BasicPanel();
        private final String currentBranch;
        private String dest;

        public BasicKind(GitBranch currentBranch) {
            super(BasicKind.class.getName());
            this.currentBranch = currentBranch.getName();
            this.initialize(currentBranch);
        }

        @Override
        public String getDisplayName() {
            return Bundle.LBL_RebaseKind_basic_displayName();
        }

        @Override
        public String getDescription() {
            return Bundle.LBL_RebaseKind_basic_description();
        }

        @Override
        public JPanel getPanel() {
            return this.basicPanel;
        }

        @Override
        public String getUpstream() {
            return this.dest;
        }

        @Override
        public String getSource() {
            return this.currentBranch;
        }

        @Override
        public String getDest() {
            return this.dest;
        }

        private void initialize(GitBranch currentBranch) {
            BasicKind.setRevision(this.basicPanel.jTextField1, currentBranch);
            boolean valid = false;
            if (currentBranch.getTrackedBranch() == null) {
                this.dest = null;
                this.basicPanel.jTextField2.setText(Bundle.MSG_RebaseKind_Basic_unknownTrackedBranch());
            } else {
                this.dest = currentBranch.getTrackedBranch().getName();
                BasicKind.setRevision(this.basicPanel.jTextField2, currentBranch.getTrackedBranch());
                valid = !currentBranch.getId().equals(currentBranch.getTrackedBranch().getId());
            }
            this.setValid(valid);
        }
    }
}

