/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.api;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SVNRevision {
    public static final SVNRevision HEAD = new SVNRevision(Kind.head);
    public static final SVNRevision START = new SVNRevision(Kind.head);
    public static final SVNRevision COMMITTED = new SVNRevision(Kind.committed);
    public static final SVNRevision PREVIOUS = new SVNRevision(Kind.previous);
    public static final SVNRevision BASE = new SVNRevision(Kind.base);
    public static final SVNRevision WORKING = new SVNRevision(Kind.working);
    public static final Number INVALID_REVISION = new Number(-1L);
    private final Kind kind;

    private SVNRevision(Kind kind) {
        this.kind = kind;
    }

    public static SVNRevision getRevision(String revision) throws ParseException {
        return SVNRevision.getRevision(revision, DateSpec.dateFormat);
    }

    public static SVNRevision getRevision(String revision, SimpleDateFormat aDateFormat) throws ParseException {
        if (revision == null || revision.equals("")) {
            return null;
        }
        if (revision.compareToIgnoreCase("HEAD") == 0) {
            return HEAD;
        }
        if (revision.compareToIgnoreCase("BASE") == 0) {
            return BASE;
        }
        if (revision.compareToIgnoreCase("COMMITED") == 0) {
            return COMMITTED;
        }
        if (revision.compareToIgnoreCase("PREV") == 0) {
            return PREVIOUS;
        }
        int revisionNumber = Integer.parseInt(revision);
        if (revisionNumber >= 0) {
            return new Number(revisionNumber);
        }
        if (aDateFormat == null) {
            aDateFormat = DateSpec.dateFormat;
        }
        try {
            Date revisionDate = aDateFormat.parse(revision);
            return new DateSpec(revisionDate);
        }
        catch (ParseException e) {
            throw new ParseException("Invalid revision '" + revision + "'", 0);
        }
    }

    public Kind getKind() {
        return this.kind;
    }

    public String toString() {
        switch (this.kind) {
            case base: {
                return "BASE";
            }
            case committed: {
                return "COMMITTED";
            }
            case head: {
                return "HEAD";
            }
            case previous: {
                return "PREV";
            }
            case unspecified: {
                return "START";
            }
            case working: {
                return "WORKING";
            }
        }
        return super.toString();
    }

    public static class DateSpec
    extends SVNRevision {
        private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmssZ", Locale.US);
        protected final Date revDate;

        public DateSpec(Date date) {
            super(Kind.date);
            this.revDate = date;
        }

        public Date getDate() {
            return this.revDate;
        }

        @Override
        public String toString() {
            return "{" + dateFormat.format(this.revDate) + "}";
        }
    }

    public static class Number
    extends SVNRevision
    implements Comparable<Number> {
        private final long number;

        public Number(long number) {
            super(Kind.number);
            this.number = number;
        }

        public long getNumber() {
            return this.number;
        }

        @Override
        public int compareTo(Number o) {
            return (int)(this.number - o.number);
        }

        @Override
        public String toString() {
            return Long.toString(this.number);
        }
    }

    public static enum Kind {
        unspecified,
        number,
        date,
        committed,
        previous,
        base,
        working,
        head;

    }
}

