/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNInfo;
import org.netbeans.modules.subversion.remote.api.ISVNStatus;
import org.netbeans.modules.subversion.remote.api.SVNConflictDescriptor;
import org.netbeans.modules.subversion.remote.api.SVNNodeKind;
import org.netbeans.modules.subversion.remote.api.SVNScheduleKind;
import org.netbeans.modules.subversion.remote.api.SVNStatusKind;
import org.netbeans.modules.subversion.remote.client.parser.EntriesCache;
import org.netbeans.modules.subversion.remote.client.parser.LocalSubversionException;
import org.netbeans.modules.subversion.remote.client.parser.ParserSvnInfo;
import org.netbeans.modules.subversion.remote.client.parser.ParserSvnStatus;
import org.netbeans.modules.subversion.remote.client.parser.WorkingCopyDetails;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.xml.sax.SAXException;

public class SvnWcParser {
    private WorkingCopyDetails getWCDetails(VCSFileProxy file) throws IOException, SAXException {
        Map<String, String> attributes = EntriesCache.getInstance().getFileAttributes(file);
        return WorkingCopyDetails.createWorkingCopy(file, attributes);
    }

    public ISVNStatus[] getStatus(VCSFileProxy path, boolean descend, boolean getAll) throws LocalSubversionException {
        List<ISVNStatus> l = this.getStatus(path, descend);
        return l.toArray(new ISVNStatus[l.size()]);
    }

    private List<ISVNStatus> getStatus(VCSFileProxy path, boolean descend) throws LocalSubversionException {
        ArrayList<ISVNStatus> ret = new ArrayList<ISVNStatus>(20);
        ret.add(this.getSingleStatus(path));
        VCSFileProxy[] children = this.getChildren(path);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (SvnUtils.isPartOfSubversionMetadata(children[i]) || SvnUtils.isAdministrative(path)) continue;
                if (descend && children[i].isDirectory()) {
                    ret.addAll(this.getStatus(children[i], descend));
                    continue;
                }
                ret.add(this.getSingleStatus(children[i]));
            }
        }
        return ret;
    }

    private VCSFileProxy[] getChildren(VCSFileProxy file) throws LocalSubversionException {
        VCSFileProxy[] children = file.listFiles();
        if (children != null) {
            try {
                String[] entries = EntriesCache.getInstance().getChildren(file);
                LinkedHashSet<VCSFileProxy> childSet = new LinkedHashSet<VCSFileProxy>(children.length + entries.length);
                childSet.addAll(Arrays.asList(children));
                for (String name : entries) {
                    childSet.add(VCSFileProxy.createFileProxy((VCSFileProxy)file, (String)name));
                }
                children = childSet.toArray(new VCSFileProxy[childSet.size()]);
            }
            catch (IOException ex) {
                throw new LocalSubversionException(ex);
            }
            catch (SAXException ex) {
                throw new LocalSubversionException(ex);
            }
        }
        return children;
    }

    public ISVNStatus getSingleStatus(VCSFileProxy file) throws LocalSubversionException {
        SVNStatusKind finalTextStatus = SVNStatusKind.NORMAL;
        SVNStatusKind finalPropStatus = SVNStatusKind.NONE;
        try {
            WorkingCopyDetails wcDetails = this.getWCDetails(file);
            if (wcDetails.isHandled()) {
                SVNConflictDescriptor conflictDesc;
                String value;
                if (wcDetails.propertiesExist() || wcDetails.getBasePropertiesFile() != null && wcDetails.getBasePropertiesFile().exists()) {
                    finalPropStatus = SVNStatusKind.NORMAL;
                    if (wcDetails.propertiesModified()) {
                        finalPropStatus = SVNStatusKind.MODIFIED;
                    }
                }
                if (wcDetails.isFile() && wcDetails.textModified()) {
                    finalTextStatus = SVNStatusKind.MODIFIED;
                }
                if ((value = wcDetails.getValue("schedule")) != null) {
                    if (value.equals("add")) {
                        finalTextStatus = SVNStatusKind.ADDED;
                        finalPropStatus = SVNStatusKind.NONE;
                    } else if (value.equals("delete")) {
                        finalTextStatus = SVNStatusKind.DELETED;
                        finalPropStatus = SVNStatusKind.NONE;
                    } else if (value.equals("replace")) {
                        finalTextStatus = SVNStatusKind.REPLACED;
                        finalPropStatus = SVNStatusKind.NONE;
                    }
                }
                assert (finalTextStatus.equals((Object)SVNStatusKind.NORMAL) || finalTextStatus.equals((Object)SVNStatusKind.MODIFIED) || finalTextStatus.equals((Object)SVNStatusKind.ADDED) || finalTextStatus.equals((Object)SVNStatusKind.REPLACED) || finalTextStatus.equals((Object)SVNStatusKind.DELETED));
                if (!(SVNStatusKind.DELETED.equals((Object)finalTextStatus) || file.exists() || this.isUnderParent(file))) {
                    finalTextStatus = SVNStatusKind.MISSING;
                }
                if ((value = wcDetails.getValue("deleted")) != null && value.equals("true")) {
                    finalTextStatus = SVNStatusKind.UNVERSIONED;
                    finalPropStatus = SVNStatusKind.NONE;
                }
                String fileUrl = wcDetails.getValue("url");
                long revision = wcDetails.getLongValue("revision");
                String nodeKind = wcDetails.getValue("kind", "normal");
                String lastCommitAuthor = wcDetails.getValue("last-author");
                long lastChangedRevision = wcDetails.getLongValue("committed-rev");
                Date lastCommittedDate = wcDetails.getDateValue("committed-date");
                boolean isCopied = wcDetails.getBooleanValue("copied");
                String urlCopiedFrom = null;
                if (isCopied) {
                    urlCopiedFrom = wcDetails.getValue("copyfrom-url");
                }
                VCSFileProxy conflictNew = null;
                VCSFileProxy conflictOld = null;
                VCSFileProxy conflictWorking = null;
                value = wcDetails.getValue("conflict-wrk");
                if (value != null && value.length() > 0) {
                    conflictWorking = VCSFileProxy.createFileProxy((VCSFileProxy)file.getParentFile(), (String)value);
                }
                if ((value = wcDetails.getValue("conflict-new")) != null && value.length() > 0) {
                    conflictNew = VCSFileProxy.createFileProxy((VCSFileProxy)file.getParentFile(), (String)value);
                }
                if ((value = wcDetails.getValue("conflict-old")) != null && value.length() > 0) {
                    conflictOld = VCSFileProxy.createFileProxy((VCSFileProxy)file.getParentFile(), (String)value);
                }
                if (conflictNew != null || conflictOld != null) {
                    finalTextStatus = SVNStatusKind.CONFLICTED;
                }
                Date lockCreationDate = wcDetails.getDateValue("lock-creation-date");
                String lockComment = null;
                String lockOwner = null;
                if (lockCreationDate != null) {
                    lockComment = wcDetails.getValue("lock-comment");
                    lockOwner = wcDetails.getValue("lock-owner");
                }
                return new ParserSvnStatus(file, fileUrl, revision, nodeKind, finalTextStatus, finalPropStatus, lastCommitAuthor, lastChangedRevision, lastCommittedDate, isCopied, urlCopiedFrom, conflictNew, conflictOld, conflictWorking, lockCreationDate, lockComment, lockOwner, (conflictDesc = wcDetails.getConflictDescriptor()) != null, conflictDesc);
            }
            return new ParserSvnStatus(file, wcDetails.getValue("url"), 0L, "unknown", SVNStatusKind.UNVERSIONED, SVNStatusKind.UNVERSIONED, null, 0L, null, false, null, null, null, null, null, null, null, false, null);
        }
        catch (IOException ex) {
            throw new LocalSubversionException(ex);
        }
        catch (SAXException ex) {
            throw new LocalSubversionException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new LocalSubversionException(ex);
        }
    }

    private boolean isUnderParent(VCSFileProxy file) {
        VCSFileProxy[] children;
        VCSFileProxy parentFile;
        if (Subversion.LOG.isLoggable(Level.FINE)) {
            Subversion.LOG.fine("SvnWcParser:isUnderParent: 168248 hook");
        }
        if ((parentFile = file.getParentFile()) != null && (children = parentFile.listFiles()) != null) {
            for (VCSFileProxy child : children) {
                if (!file.equals((Object)child)) continue;
                if (Subversion.LOG.isLoggable(Level.FINE)) {
                    Subversion.LOG.fine("SvnWcParser:isUnderParent: file " + file.getPath() + " seems to be a broken link");
                }
                return true;
            }
        }
        return false;
    }

    public ISVNInfo getInfoFromWorkingCopy(VCSFileProxy file) throws LocalSubversionException {
        ParserSvnInfo returnValue = null;
        try {
            WorkingCopyDetails wcDetails = this.getWCDetails(file);
            if (wcDetails.isHandled()) {
                String fileUrl = wcDetails.getValue("url");
                String reposUrl = wcDetails.getValue("repos");
                String reposUuid = wcDetails.getValue("uuid");
                String schedule = wcDetails.getValue("schedule");
                if (schedule == null) {
                    schedule = SVNScheduleKind.NORMAL.toString();
                }
                long revision = wcDetails.getLongValue("revision");
                boolean isCopied = wcDetails.getBooleanValue("copied");
                String urlCopiedFrom = null;
                long revisionCopiedFrom = 0L;
                if (isCopied) {
                    urlCopiedFrom = wcDetails.getValue("copyfrom-url");
                    revisionCopiedFrom = wcDetails.getLongValue("copyfrom-rev");
                }
                Date lastCommittedDate = wcDetails.getDateValue("committed-date");
                long lastChangedRevision = wcDetails.getLongValue("committed-rev");
                String lastCommitAuthor = wcDetails.getValue("last-author");
                Date lastDatePropsUpdate = wcDetails.getDateValue("prop-time");
                Date lastDateTextUpdate = wcDetails.getDateValue("text-time");
                Date lockCreationDate = wcDetails.getDateValue("lock-creation-date");
                String lockComment = null;
                String lockOwner = null;
                if (lockCreationDate != null) {
                    lockComment = wcDetails.getValue("lock-comment");
                    lockOwner = wcDetails.getValue("lock-owner");
                }
                String nodeKind = wcDetails.getValue("kind", "normal");
                returnValue = new ParserSvnInfo(file, fileUrl, reposUrl, reposUuid, SVNScheduleKind.fromString(schedule), revision, isCopied, urlCopiedFrom, revisionCopiedFrom, lastCommittedDate, lastChangedRevision, lastCommitAuthor, lastDatePropsUpdate, lastDateTextUpdate, lockCreationDate, lockOwner, lockComment, SVNNodeKind.fromString(nodeKind), wcDetails.getPropertiesFile(), wcDetails.getBasePropertiesFile());
            } else {
                String fileUrl = wcDetails.getValue("url");
                String reposUrl = wcDetails.getValue("repos");
                String reposUuid = wcDetails.getValue("uuid");
                returnValue = new ParserSvnInfo(file, fileUrl, reposUrl, reposUuid, SVNScheduleKind.NORMAL, 0L, false, null, 0L, null, 0L, null, null, null, null, null, null, SVNNodeKind.UNKNOWN, null, null);
            }
        }
        catch (IOException ex) {
            throw new LocalSubversionException(ex);
        }
        catch (SAXException ex) {
            throw new LocalSubversionException(ex);
        }
        return returnValue;
    }

    public ISVNInfo getUnknownInfo(VCSFileProxy file) {
        return new ParserSvnInfo(file, null, null, null, SVNScheduleKind.NORMAL, 0L, false, null, 0L, null, 0L, null, null, null, null, null, null, SVNNodeKind.UNKNOWN, null, null);
    }
}

