/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.history;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.VersionsCache;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class DiffStreamSource
extends StreamSource
implements Cancellable {
    private final VCSFileProxy baseFile;
    private final String revision;
    private final String pegRevision;
    private final String title;
    private String mimeType;
    private final SVNUrl url;
    private final SVNUrl repoUrl;
    private SvnClient client;
    private final FileSystem fileSystem;
    private VCSFileProxy remoteFile;
    private boolean isDirectory;
    private final String baseFileName;

    public DiffStreamSource(FileSystem fs, VCSFileProxy baseFile, SVNUrl repoUrl, SVNUrl fileUrl, String revision, String title) {
        this.fileSystem = fs;
        this.baseFile = baseFile;
        this.baseFileName = baseFile.getName();
        this.revision = this.pegRevision = revision;
        this.title = title;
        this.url = fileUrl;
        this.repoUrl = repoUrl;
    }

    public DiffStreamSource(FileSystem fs, VCSFileProxy baseFile, String baseFileName, SVNUrl repoUrl, SVNUrl fileUrl, String revision, String pegRevision, String title) {
        this.fileSystem = fs;
        this.baseFile = baseFile;
        this.baseFileName = baseFileName;
        this.revision = revision;
        this.pegRevision = pegRevision;
        this.title = title;
        this.url = fileUrl;
        this.repoUrl = repoUrl;
    }

    public String getName() {
        return this.baseFileName;
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized String getMIMEType() {
        try {
            this.init();
        }
        catch (IOException e) {
            Subversion.LOG.log(Level.INFO, "DiffStreamSource.getMIMEType() returns null", e);
            return null;
        }
        return this.mimeType;
    }

    public synchronized Reader createReader() throws IOException {
        this.init();
        if (this.revision == null || this.remoteFile == null) {
            return null;
        }
        if (!this.mimeType.startsWith("text/")) {
            return null;
        }
        return Utils.createReader((FileObject)this.remoteFile.toFileObject());
    }

    public Writer createWriter(Difference[] conflicts) throws IOException {
        throw new IOException("Operation not supported");
    }

    public final boolean isEditable() {
        return false;
    }

    private boolean isPrimary() {
        FileObject fo;
        FileObject fileObject = fo = this.baseFile == null ? null : this.baseFile.toFileObject();
        if (fo != null) {
            try {
                DataObject dao = DataObject.find((FileObject)fo);
                return fo.equals(dao.getPrimaryFile());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized Lookup getLookup() {
        try {
            this.init();
        }
        catch (IOException e) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        if (this.remoteFile == null || !this.isPrimary()) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        FileObject remoteFo = this.remoteFile.toFileObject();
        if (remoteFo == null) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        return Lookups.fixed((Object[])new Object[]{remoteFo});
    }

    public synchronized void init() throws IOException {
        if (this.remoteFile != null || this.revision == null) {
            return;
        }
        if (this.isDirectory || this.baseFile != null && this.baseFile.isDirectory()) {
            this.mimeType = "content/unknown";
            return;
        }
        this.mimeType = this.baseFile == null ? "content/unknown" : SvnUtils.getMimeType(this.baseFile);
        try {
            File rf = VersionsCache.getInstance(this.fileSystem).getFileRevision(this.repoUrl, this.url, this.revision, this.pegRevision, this.baseFileName);
            this.remoteFile = VCSFileProxy.createFileProxy((File)rf);
            if (this.baseFile != null) {
                VCSFileProxySupport.associateEncoding((VCSFileProxy)this.baseFile, (VCSFileProxy)this.remoteFile);
            }
        }
        catch (IOException e) {
            if (e.getCause() != null && SvnClientExceptionHandler.isTargetDirectory(e.getCause().getMessage()) || SvnClientExceptionHandler.isTargetDirectory(e.getMessage())) {
                if (Subversion.LOG.isLoggable(Level.FINE)) {
                    Subversion.LOG.log(Level.FINE, "", e);
                }
                this.mimeType = "content/unknown";
                this.isDirectory = true;
                return;
            }
            throw e;
        }
        if ((this.baseFile == null || !this.baseFile.exists()) && this.remoteFile != null && this.remoteFile.exists()) {
            this.mimeType = SvnUtils.getMimeType(this.remoteFile);
        }
    }

    public boolean cancel() {
        if (this.client != null) {
            this.client.cancel();
        }
        return true;
    }
}

