/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.j2me.project.api.J2MEProjectBuilder;
import org.netbeans.modules.j2me.project.wizard.PanelConfigureProject;
import org.netbeans.modules.j2me.project.wizard.WizardSettings;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class J2MEProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    static final String PROP_NAME_INDEX = "nameIndex";
    private static final String MANIFEST_FILE = "manifest.mf";
    static final String MIDLET_CLASS = "mainClass";
    static final String SHARED_LIBRARIES = "sharedLibraries";
    static final String JDK_PLATFORM = "jdk";
    static final String PLATFORM = "platform";
    public static final String DEVICE = "device";
    static final String CONFIGURATION = "config";
    static final String PROFILE = "profile";
    static final String OPTIONAL_API = "optionalApi";
    static final String PLATFORM_BOOTCLASSPATH = "bootclasspath";
    private static final long serialVersionUID = 1L;
    private final WizardType type;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;

    private J2MEProjectWizardIterator(WizardType type) {
        this.type = type;
    }

    public static J2MEProjectWizardIterator application() {
        return new J2MEProjectWizardIterator(WizardType.APPLICATION);
    }

    public Set<?> instantiate() throws IOException {
        assert (false) : "Cannot call this method if implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public Set<FileObject> instantiate(ProgressHandle handle) throws IOException {
        FileObject midletFo;
        FileObject sourcesRoot;
        handle.start(4);
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        File dirF = (File)this.wiz.getProperty("projdir");
        if (dirF == null) {
            throw new NullPointerException("projdir == null, props:" + this.wiz.getProperties());
        }
        dirF = FileUtil.normalizeFile((File)dirF);
        String name = (String)this.wiz.getProperty("name");
        String midletClass = (String)this.wiz.getProperty(MIDLET_CLASS);
        String librariesDefinition = (String)this.wiz.getProperty(SHARED_LIBRARIES);
        JavaPlatform platform = (JavaPlatform)this.wiz.getProperty(PLATFORM);
        String configuration = (String)this.wiz.getProperty(CONFIGURATION);
        String profile = (String)this.wiz.getProperty(PROFILE);
        String device = (String)this.wiz.getProperty(DEVICE);
        JavaPlatform jdk = (JavaPlatform)this.wiz.getProperty(JDK_PLATFORM);
        String optionalApi = (String)this.wiz.getProperty(OPTIONAL_API);
        String bootclasspath = (String)this.wiz.getProperty(PLATFORM_BOOTCLASSPATH);
        if (librariesDefinition != null) {
            if (!librariesDefinition.endsWith(File.separator)) {
                librariesDefinition = librariesDefinition + File.separatorChar;
            }
            librariesDefinition = librariesDefinition + "nblibraries.properties";
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("run.method", "STANDARD");
        props.put("debugger.timeout", "30000");
        props.put("platform.configuration", configuration);
        props.put("platform.profile", profile);
        props.put("platform.type", ((J2MEPlatform)platform).getType());
        props.put("platform.device", device);
        props.put("platform.apis", optionalApi);
        props.put("platform.bootcp", bootclasspath);
        props.put("manifest.others", "MIDlet-Vendor: " + System.getProperty("user.name") + "\nMIDlet-Name: " + name + "\nMIDlet-Version: 1.0\n");
        if (midletClass != null && !midletClass.isEmpty()) {
            props.put("manifest.midlets", "MIDlet-1: " + name + ",," + midletClass + "\n");
        }
        handle.progress(NbBundle.getMessage(J2MEProjectWizardIterator.class, (String)"LBL_NewJ2MEProjectWizardIterator_WizardProgress_CreatingProject"), 1);
        switch (this.type) {
            default: 
        }
        String midletTemplate = "Templates/j2me/MEEPlet.java";
        AntProjectHelper h = J2MEProjectBuilder.forDirectory(dirF, name, platform).addDefaultSourceRoots().setMainMIDLetName(midletClass).setMainMIDLetTemplate(midletTemplate).setLibrariesDefinitionFile(librariesDefinition).setSDKPlatform(jdk).addCustomProjectProperties(props).build();
        handle.progress(2);
        if (midletClass != null && !midletClass.isEmpty() && (sourcesRoot = h.getProjectDirectory().getFileObject("src")) != null && (midletFo = this.getClassFO(sourcesRoot, midletClass)) != null) {
            resultSet.add(midletFo);
        }
        FileObject dir = FileUtil.toFileObject((File)dirF);
        switch (this.type) {
            case APPLICATION: {
                J2MEProjectWizardIterator.createManifest(dir, false);
            }
        }
        handle.progress(3);
        Integer ind = (Integer)this.wiz.getProperty(PROP_NAME_INDEX);
        if (ind != null) {
            switch (this.type) {
                case APPLICATION: {
                    WizardSettings.setNewApplicationCount(ind);
                }
            }
        }
        resultSet.add(dir);
        handle.progress(NbBundle.getMessage(J2MEProjectWizardIterator.class, (String)"LBL_NewJ2MEProjectWizardIterator_WizardProgress_PreparingToOpen"), 4);
        File file = dirF = dirF != null ? dirF.getParentFile() : null;
        if (dirF != null && dirF.exists()) {
            ProjectChooser.setProjectsFolder((File)dirF);
        }
        SharableLibrariesUtils.setLastProjectSharable((librariesDefinition != null ? 1 : 0) != 0);
        return resultSet;
    }

    public void initialize(WizardDescriptor wizard) {
        this.wiz = wizard;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        this.wiz.putProperty("sourceRoot", (Object)new File[0]);
        this.wiz.putProperty("testRoot", (Object)new File[0]);
    }

    public void uninitialize(WizardDescriptor wizard) {
        if (this.wiz != null) {
            this.wiz.putProperty("projdir", null);
            this.wiz.putProperty("name", null);
            this.wiz.putProperty(MIDLET_CLASS, null);
            this.wiz.putProperty(SHARED_LIBRARIES, null);
            this.wiz.putProperty(JDK_PLATFORM, null);
            this.wiz.putProperty(PLATFORM, null);
            this.wiz.putProperty(DEVICE, null);
            this.wiz.putProperty(CONFIGURATION, null);
            this.wiz.putProperty(PROFILE, null);
            this.wiz.putProperty(OPTIONAL_API, null);
            this.wiz.putProperty(PLATFORM_BOOTCLASSPATH, null);
            switch (this.type) {
                case EXISTING: {
                    this.wiz.putProperty("sourceRoot", null);
                    this.wiz.putProperty("testRoot", null);
                }
            }
            this.wiz = null;
            this.panels = null;
        }
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(J2MEProjectWizardIterator.class, (String)"LAB_IteratorName", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private WizardDescriptor.Panel[] createPanels() {
        switch (this.type) {
            default: 
        }
        return new WizardDescriptor.Panel[]{new PanelConfigureProject(this.type)};
    }

    private String[] createSteps() {
        switch (this.type) {
            default: 
        }
        return new String[]{NbBundle.getMessage(J2MEProjectWizardIterator.class, (String)"LAB_ConfigureProject")};
    }

    private FileObject getClassFO(FileObject sourcesRoot, String className) {
        className = className.replace('.', '/');
        return sourcesRoot.getFileObject(className + ".java");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createManifest(FileObject dir, boolean skipIfExists) throws IOException {
        if (skipIfExists && dir.getFileObject(MANIFEST_FILE) != null) {
            return;
        }
        FileObject manifest = dir.createData(MANIFEST_FILE);
        FileLock lock = manifest.lock();
        try (OutputStream os = manifest.getOutputStream(lock);){
            PrintWriter pw = new PrintWriter(os);
            pw.println("Manifest-Version: 1.0");
            pw.println();
            pw.flush();
        }
        finally {
            lock.releaseLock();
        }
    }

    public static enum WizardType {
        APPLICATION,
        EXISTING,
        SAMPLE;

    }
}

