/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.netbeans.modules.dlight.libs.common.DLightLibsCommonLogger;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.api.ui.FileObjectBasedFile;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemTransport;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.modules.remote.spi.FileSystemProviderImplementation;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

public class RemoteFileSystemProvider
implements FileSystemProviderImplementation {
    public FileSystem getFileSystem(ExecutionEnvironment env, String root) {
        return RemoteFileSystemManager.getInstance().getFileSystem(env);
    }

    public String normalizeAbsolutePath(String absPath, ExecutionEnvironment env) {
        return RemoteFileSystemManager.getInstance().getFileSystem(env).normalizeAbsolutePath(absPath);
    }

    public String normalizeAbsolutePath(String absPath, FileSystem fileSystem) {
        RemoteLogger.assertTrue(fileSystem instanceof RemoteFileSystem);
        if (fileSystem instanceof RemoteFileSystem) {
            return ((RemoteFileSystem)fileSystem).normalizeAbsolutePath(absPath);
        }
        return PathUtilities.normalizeUnixPath((String)absPath);
    }

    public boolean isAbsolute(String path) {
        return path.isEmpty() || path.startsWith("/");
    }

    public FileObject getFileObject(FileObject baseFileObject, String relativeOrAbsolutePath) {
        if (baseFileObject instanceof RemoteFileObject) {
            ExecutionEnvironment execEnv = ((RemoteFileObject)baseFileObject).getExecutionEnvironment();
            if (this.isAbsolute(relativeOrAbsolutePath)) {
                relativeOrAbsolutePath = RemoteFileSystemManager.getInstance().getFileSystem(execEnv).normalizeAbsolutePath(relativeOrAbsolutePath);
                try {
                    return baseFileObject.getFileSystem().findResource(relativeOrAbsolutePath);
                }
                catch (FileStateInvalidException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                return baseFileObject.getFileObject(relativeOrAbsolutePath);
            }
        }
        return null;
    }

    public boolean isMine(ExecutionEnvironment env) {
        return env.isRemote();
    }

    public boolean isMine(FileObject fileObject) {
        return fileObject instanceof RemoteFileObject;
    }

    public boolean isMine(FileSystem fileSystem) {
        return fileSystem instanceof RemoteFileSystem;
    }

    public boolean isMine(URI uri) {
        return uri.getScheme().equals("rfs");
    }

    public FileObject getCanonicalFileObject(FileObject fileObject) throws IOException {
        return RemoteFileSystemUtils.getCanonicalFileObject(fileObject);
    }

    public String getCanonicalPath(FileObject fileObject) throws IOException {
        return RemoteFileSystemUtils.getCanonicalFileObject(fileObject).getPath();
    }

    public String getCanonicalPath(FileSystem fs, String absPath) throws IOException {
        FileObject fo = fs.findResource(absPath);
        if (fo != null) {
            try {
                return this.getCanonicalFileObject(fo).getPath();
            }
            catch (FileNotFoundException e) {
                RemoteLogger.finest(e);
            }
        }
        return PathUtilities.normalizeUnixPath((String)absPath);
    }

    public String getCanonicalPath(ExecutionEnvironment env, String absPath) throws IOException {
        RemoteLogger.assertTrueInConsole(env.isRemote(), this.getClass().getSimpleName() + ".getCanonicalPath is called for LOCAL env: " + env, new Object[0]);
        RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(env);
        return this.getCanonicalPath(fs, absPath);
    }

    public ExecutionEnvironment getExecutionEnvironment(FileSystem fileSystem) {
        if (fileSystem instanceof RemoteFileSystem) {
            return ((RemoteFileSystem)fileSystem).getExecutionEnvironment();
        }
        return ExecutionEnvironmentFactory.getLocal();
    }

    public boolean isMine(String absoluteURL) {
        return absoluteURL.startsWith("rfs:");
    }

    public boolean waitWrites(ExecutionEnvironment env, Collection<String> failedFiles) throws InterruptedException {
        return true;
    }

    public boolean waitWrites(ExecutionEnvironment env, Collection<FileObject> filesToWait, Collection<String> failedFiles) throws InterruptedException {
        return true;
    }

    public FileSystem getFileSystem(URI uri) {
        assert (this.isMine(uri));
        return this.getFileSystem(this.getEnv(uri), "");
    }

    private ExecutionEnvironment getEnv(URI uri) {
        String host = uri.getHost();
        int port = uri.getPort();
        String user = uri.getUserInfo();
        return ExecutionEnvironmentFactory.createNew((String)user, (String)host, (int)port);
    }

    public FileObject urlToFileObject(String path) {
        String pathPart;
        String envPart;
        int idx;
        DLightLibsCommonLogger.assertNonUiThreadOnce((Level)Level.INFO);
        if (!path.startsWith("rfs:")) {
            return null;
        }
        String url = path.substring("rfs:".length());
        if (url.startsWith("//")) {
            url = url.substring(2);
        }
        if ((idx = url.indexOf(":/")) < 0) {
            idx = url.indexOf("/");
        }
        if (idx < 0) {
            envPart = url;
            pathPart = "/";
        } else {
            envPart = url.substring(0, idx);
            pathPart = url.substring(url.charAt(idx) == ':' ? idx + 1 : idx);
        }
        ExecutionEnvironment env = null;
        if (envPart.indexOf(64) < 0) {
            RemoteLogger.assertTrueInConsole(false, "Trying to access remote file system without user name", new Object[0]);
            idx = envPart.lastIndexOf(58);
            String host = idx < 0 ? envPart : envPart.substring(0, idx);
            env = RemoteFileSystemUtils.getExecutionEnvironment(host, 0);
        }
        if (env == null) {
            env = ExecutionEnvironmentFactory.fromUniqueID((String)envPart);
        }
        if (env == null) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(env);
        return fs.findResource(pathPart);
    }

    public FileSystem urlToFileSystem(String path) {
        int idx;
        DLightLibsCommonLogger.assertNonUiThreadOnce((Level)Level.INFO);
        if (!path.startsWith("rfs:")) {
            return null;
        }
        String url = path.substring("rfs:".length());
        if (url.startsWith("//")) {
            url = url.substring(2);
        }
        if ((idx = url.indexOf(":/")) < 0) {
            idx = url.indexOf(47);
        }
        String envPart = idx < 0 ? url : url.substring(0, idx);
        ExecutionEnvironment env = null;
        if (envPart.indexOf(64) < 0) {
            RemoteLogger.assertTrueInConsole(false, "Trying to access remote file system without user name", new Object[0]);
            idx = envPart.lastIndexOf(58);
            String host = idx < 0 ? envPart : envPart.substring(0, idx);
            env = RemoteFileSystemUtils.getExecutionEnvironment(host, 0);
        }
        if (env == null) {
            env = ExecutionEnvironmentFactory.fromUniqueID((String)envPart);
        }
        if (env == null) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(env);
        return fs;
    }

    public String toURL(FileObject fileObject) {
        if (!(fileObject instanceof RemoteFileObject)) {
            return null;
        }
        ExecutionEnvironment env = ((RemoteFileObject)fileObject).getExecutionEnvironment();
        String path = fileObject.getPath();
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        return "rfs:" + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env) + path;
    }

    public String toURL(FileSystem fileSystem, String absPath) {
        RemoteLogger.assertTrue(this.isAbsolute(absPath), "Path must be absolute: " + absPath, new Object[0]);
        if (!(fileSystem instanceof RemoteFileSystem)) {
            throw new IllegalArgumentException("File system should be an istance of " + RemoteFileSystem.class.getName());
        }
        ExecutionEnvironment env = ((RemoteFileSystem)fileSystem).getExecutionEnvironment();
        return "rfs:" + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env) + absPath;
    }

    public FileObject fileToFileObject(File file) {
        if (!(file instanceof FileObjectBasedFile)) {
            return null;
        }
        return ((FileObjectBasedFile)file).getFileObject();
    }

    public boolean isMine(File file) {
        return file instanceof FileObjectBasedFile;
    }

    public void refresh(FileObject fileObject, boolean recursive) {
        if (recursive) {
            fileObject.refresh();
        } else {
            ((RemoteFileObject)fileObject).nonRecursiveRefresh();
        }
    }

    public void scheduleRefresh(FileObject fileObject) {
        if (fileObject instanceof RemoteFileObject) {
            RemoteFileObject fo = (RemoteFileObject)fileObject;
            RemoteFileSystemTransport.scheduleRefresh(fo.getExecutionEnvironment(), Arrays.asList(fo.getPath()));
        } else {
            RemoteLogger.getInstance().log(Level.WARNING, "Unexpected fileObject class: {0}", fileObject.getClass());
        }
    }

    public void scheduleRefresh(ExecutionEnvironment env, Collection<String> paths) {
        RemoteFileSystemTransport.scheduleRefresh(env, paths);
    }

    public void addRecursiveListener(FileChangeListener listener, FileSystem fileSystem, String absPath) {
        this.addRecursiveListener(listener, fileSystem, absPath, null, null);
    }

    public void addRecursiveListener(FileChangeListener listener, FileSystem fileSystem, String absPath, FileFilter recurseInto, Callable<Boolean> interrupter) {
        RemoteLogger.assertTrue(fileSystem instanceof RemoteFileSystem, "Unexpected file system class: " + fileSystem, new Object[0]);
        FileObject fileObject = fileSystem.findResource(absPath);
        if (fileObject != null) {
            fileObject.addRecursiveListener(listener);
        }
    }

    public void removeRecursiveListener(FileChangeListener listener, FileSystem fileSystem, String absPath) {
        RemoteLogger.assertTrue(fileSystem instanceof RemoteFileSystem, "Unexpected file system class: " + fileSystem, new Object[0]);
        FileObject fileObject = fileSystem.findResource(absPath);
        if (fileObject != null) {
            fileObject.removeRecursiveListener(listener);
        }
    }

    public void addFileChangeListener(FileChangeListener listener, FileSystem fileSystem, String path) {
        RemoteLogger.assertTrue(fileSystem instanceof RemoteFileSystem, "Unexpected file system class: " + fileSystem, new Object[0]);
        ((RemoteFileSystem)fileSystem).getFactory().addFileChangeListener(path, listener);
    }

    public void addFileChangeListener(FileChangeListener listener, ExecutionEnvironment env, String path) {
        RemoteLogger.assertTrue(env.isRemote(), "Unexpected ExecutionEnvironment: should be remote", new Object[0]);
        RemoteFileSystemManager.getInstance().getFileSystem(env).getFactory().addFileChangeListener(path, listener);
    }

    public void addFileChangeListener(FileChangeListener listener) {
        RemoteFileSystemManager.getInstance().addFileChangeListener(listener);
    }

    public void removeFileChangeListener(FileChangeListener listener) {
        RemoteFileSystemManager.getInstance().removeFileChangeListener(listener);
    }

    public boolean canExecute(FileObject fileObject) {
        RemoteLogger.assertTrue(fileObject instanceof RemoteFileObject, "Unexpected file object class: " + fileObject, new Object[0]);
        if (fileObject instanceof RemoteFileObject) {
            return ((RemoteFileObject)fileObject).getImplementor().canExecute();
        }
        return false;
    }

    public char getFileSeparatorChar() {
        return '/';
    }

    public void addFileSystemProblemListener(FileSystemProvider.FileSystemProblemListener listener, FileSystem fileSystem) {
        ((RemoteFileSystem)fileSystem).addFileSystemProblemListener(listener);
    }

    public void addFileSystemProblemListener(FileSystemProvider.FileSystemProblemListener listener) {
        RemoteFileSystem.addGlobalFileSystemProblemListener(listener);
    }

    public void removeFileSystemProblemListener(FileSystemProvider.FileSystemProblemListener listener, FileSystem fileSystem) {
        ((RemoteFileSystem)fileSystem).removeFileSystemProblemListener(listener);
    }

    public void warmup(FileSystemProvider.WarmupMode mode, ExecutionEnvironment env, Collection<String> paths, Collection<String> extensions) {
        switch (mode) {
            case RECURSIVE_LS: {
                if (RemoteFileSystemUtils.getBoolean("remote.warmup.recursive.ls", true)) break;
                return;
            }
            case FILES_CONTENT: {
                if (RemoteFileSystemUtils.getBoolean("remote.warmup.files.content", true)) break;
                return;
            }
        }
        RemoteFileSystemManager.getInstance().getFileSystem(env).warmup(paths, mode, extensions);
    }

    public boolean isLink(FileSystem fileSystem, String path) {
        return this.isLink(fileSystem.findResource(path));
    }

    public boolean isLink(ExecutionEnvironment env, String path) {
        return this.isLink(this.getFileSystem(env, "/").findResource(path));
    }

    public boolean isLink(FileObject fo) {
        try {
            return fo.isSymbolicLink();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    public String resolveLink(FileObject fo) throws IOException {
        return fo.readSymbolicLinkPath();
    }

    public InputStream getInputStream(FileObject fo, int maxSize) throws IOException {
        return ((RemoteFileObject)fo).getInputStream(maxSize);
    }

    public boolean canSetAccessCheckType(ExecutionEnvironment execEnv) {
        return RemoteFileSystemTransport.canSetAccessCheckType(execEnv);
    }

    public void setAccessCheckType(ExecutionEnvironment execEnv, FileSystemProvider.AccessCheckType accessCheckType) {
        RemoteFileSystemTransport.setAccessCheckType(execEnv, accessCheckType);
    }

    public FileSystemProvider.AccessCheckType getAccessCheckType(ExecutionEnvironment execEnv) {
        return RemoteFileSystemTransport.getAccessCheckType(execEnv);
    }

    public FileSystemProvider.Stat getStat(FileObject fo) {
        if (fo instanceof RemoteFileObject) {
            RemoteFileObjectBase rfo = ((RemoteFileObject)fo).getImplementor();
            return rfo.getStat();
        }
        return FileSystemProvider.Stat.createInvalid();
    }
}

