/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.SourcesVisibilityQuery;
import org.netbeans.modules.cnd.dwarfdump.source.Artifacts;
import org.netbeans.modules.cnd.dwarfdump.source.CompileLineOrigin;
import org.netbeans.modules.cnd.dwarfdump.source.Driver;

public final class DriverFactory {
    public static Driver getDriver(CompilerSet set) {
        return new DriverImpl(set);
    }

    public static ItemProperties.LanguageStandard getLanguageStandard(ItemProperties.LanguageStandard standard, Artifacts artifacts) {
        ItemProperties.LanguageStandard res = standard;
        for (String lang : artifacts.getLanguageArtifacts()) {
            if (null == lang) continue;
            switch (lang) {
                case "c89": {
                    res = ItemProperties.LanguageStandard.C89;
                    break;
                }
                case "c99": {
                    res = ItemProperties.LanguageStandard.C99;
                    break;
                }
                case "c11": {
                    res = ItemProperties.LanguageStandard.C11;
                    break;
                }
                case "c++98": {
                    res = ItemProperties.LanguageStandard.CPP;
                    break;
                }
                case "c++11": {
                    res = ItemProperties.LanguageStandard.CPP11;
                    break;
                }
                case "c++14": {
                    res = ItemProperties.LanguageStandard.CPP14;
                    break;
                }
            }
        }
        return res;
    }

    public static String importantFlagsToString(Artifacts artifacts) {
        StringBuilder buf = new StringBuilder();
        for (String flag : artifacts.getImportantFlags()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            if (flag.indexOf(32) > 0) {
                buf.append('\'').append(flag).append('\'');
                continue;
            }
            buf.append(flag);
        }
        return buf.toString();
    }

    public static String removeQuotes(String path) {
        if (path.length() >= 2 && (path.charAt(0) == '\'' && path.charAt(path.length() - 1) == '\'' || path.charAt(0) == '\"' && path.charAt(path.length() - 1) == '\"')) {
            path = path.substring(1, path.length() - 1);
        }
        return path;
    }

    public static String normalizeDefineOption(String value, CompileLineOrigin isScriptOutput, boolean isQuote) {
        switch (isScriptOutput) {
            case BuildLog: {
                if (value.length() >= 2 && value.charAt(0) == '`' && value.charAt(value.length() - 1) == '`') {
                    value = value.substring(1, value.length() - 1);
                }
                if (value.length() >= 6 && value.charAt(0) == '\"' && value.charAt(1) == '\\' && value.charAt(2) == '\"' && value.charAt(value.length() - 3) == '\\' && value.charAt(value.length() - 2) == '\"' && value.charAt(value.length() - 1) == '\"') {
                    value = value.substring(2, value.length() - 3) + "\"";
                    break;
                }
                if (value.length() >= 4 && value.charAt(0) == '\\' && value.charAt(1) == '\"' && value.charAt(value.length() - 2) == '\\' && value.charAt(value.length() - 1) == '\"') {
                    value = value.substring(1, value.length() - 2) + "\"";
                    break;
                }
                if (value.length() >= 4 && value.charAt(0) == '\\' && value.charAt(1) == '\'' && value.charAt(value.length() - 2) == '\\' && value.charAt(value.length() - 1) == '\'') {
                    value = value.substring(1, value.length() - 2) + "'";
                    break;
                }
                if (isQuote || value.length() < 2 || (value.charAt(0) != '\'' || value.charAt(value.length() - 1) != '\'') && (value.charAt(0) != '\"' || value.charAt(value.length() - 1) != '\"')) break;
                value = value.substring(1, value.length() - 1);
                break;
            }
            case DwarfCompileLine: {
                if (value.length() < 2 || (value.charAt(0) != '\'' || value.charAt(value.length() - 1) != '\'') && (value.charAt(0) != '\"' || value.charAt(value.length() - 1) != '\"')) break;
                value = DriverFactory.removeEscape(value.substring(1, value.length() - 1));
                break;
            }
        }
        return value;
    }

    public static String removeEscape(String s) {
        int n = s.length();
        StringBuilder ret = new StringBuilder(n);
        int prev = 0;
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if ((c == ' ' || c == '\t' || c == ':' || c == '\'' || c == '*' || c == '\"' || c == '[' || c == ']' || c == '(' || c == ')' || c == ';') && prev == 92) {
                ret.setLength(ret.length() - 1);
            }
            ret.append(c);
            prev = c;
        }
        return ret.toString();
    }

    private static final class ArtifactsImpl
    implements Artifacts {
        public final List<String> input = new ArrayList<String>();
        public final List<String> userIncludes = new ArrayList<String>();
        public final List<String> userFiles = new ArrayList<String>();
        public final Map<String, String> userMacros = new HashMap<String, String>();
        public final List<String> undefinedMacros = new ArrayList<String>();
        public final Set<String> libraries = new HashSet<String>();
        public final List<String> languageArtifacts = new ArrayList<String>();
        public final List<String> importantFlags = new ArrayList<String>();
        public String output;

        private ArtifactsImpl() {
        }

        public List<String> getInput() {
            return this.input;
        }

        public List<String> getUserIncludes() {
            return this.userIncludes;
        }

        public List<String> getUserFiles() {
            return this.userFiles;
        }

        public Map<String, String> getUserMacros() {
            return this.userMacros;
        }

        public List<String> getUserUndefinedMacros() {
            return this.undefinedMacros;
        }

        public Set<String> getLibraries() {
            return this.libraries;
        }

        public List<String> getLanguageArtifacts() {
            return this.languageArtifacts;
        }

        public List<String> getImportantFlags() {
            return this.importantFlags;
        }

        public String getOutput() {
            return this.output;
        }
    }

    private static final class DriverImpl
    implements Driver {
        private static final List<String> C89 = Collections.unmodifiableList(Arrays.asList("-std=c89", "-std=iso9899:1990", "-std=iso9899:1990", "-std=c90"));
        private static final List<String> C99 = Collections.unmodifiableList(Arrays.asList("-xc99", "-std=c9x", "-std=iso9899:199409", "-std=iso9899:199x", "-std=iso9899:1999", "-std=gnu99", "-std=gnu9x", "-std=c99"));
        private static final List<String> C11 = Collections.unmodifiableList(Arrays.asList("-std=c11", "-std=gnu1x", "-std=gnu11", "-std=iso9899:2011", "-std=c1x", "-std=c11"));
        private static final List<String> CPP98 = Collections.unmodifiableList(Arrays.asList("-std=c++98", "-std=c++03", "-std=sun03"));
        private static final List<String> CPP11 = Collections.unmodifiableList(Arrays.asList("-std=c++0x", "-std=c++11", "-std=gnu++0x", "-std=gnu++11"));
        private static final List<String> CPP14 = Collections.unmodifiableList(Arrays.asList("-std=c++14", "-std=gnu++14", "-std=gnu++1y", "-std=c++1y", "-std=gnu++1z", "-std=c++1z", "-std=c++17", "-std=gnu++17"));
        private Pattern cPattern;
        private boolean cPatternInited;
        private Pattern cppPattern;
        private boolean cppPatternInited;
        final CompilerSet compilerSet;

        private DriverImpl(CompilerSet compilerSet) {
            this.compilerSet = compilerSet;
        }

        public List<String> splitCommandLine(String line, CompileLineOrigin isScriptOutput) {
            ArrayList<String> res = new ArrayList<String>();
            int i = 0;
            StringBuilder current = new StringBuilder();
            boolean isSingleQuoteMode = false;
            boolean isDoubleQuoteMode = false;
            boolean isParen = false;
            block7: while (i < line.length()) {
                char c = line.charAt(i);
                ++i;
                switch (c) {
                    case '\'': {
                        if (isSingleQuoteMode) {
                            isSingleQuoteMode = false;
                        } else if (!isDoubleQuoteMode) {
                            isSingleQuoteMode = true;
                        }
                        isParen = false;
                        current.append(c);
                        continue block7;
                    }
                    case '\"': {
                        if (isDoubleQuoteMode) {
                            isDoubleQuoteMode = false;
                        } else if (!isSingleQuoteMode) {
                            isDoubleQuoteMode = true;
                        }
                        isParen = false;
                        current.append(c);
                        continue block7;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (isSingleQuoteMode || isDoubleQuoteMode) {
                            current.append(c);
                            continue block7;
                        }
                        if (isParen && isScriptOutput == CompileLineOrigin.DwarfCompileLine) {
                            current.append(c);
                            continue block7;
                        }
                        if (current.length() <= 0) continue block7;
                        res.add(current.toString());
                        current.setLength(0);
                        continue block7;
                    }
                    case '(': {
                        if (!isSingleQuoteMode && !isDoubleQuoteMode) {
                            isParen = true;
                        }
                        current.append(c);
                        continue block7;
                    }
                    case ')': {
                        if (!isSingleQuoteMode && !isDoubleQuoteMode) {
                            isParen = false;
                        }
                        current.append(c);
                        continue block7;
                    }
                }
                current.append(c);
            }
            if (current.length() > 0) {
                res.add(current.toString());
            }
            return res;
        }

        public Artifacts gatherCompilerLine(String line, CompileLineOrigin isScriptOutput, boolean isCpp) {
            String option;
            ListIterator<String> st;
            List<String> list = this.splitCommandLine(line, isScriptOutput);
            boolean hasQuotes = false;
            for (String s : list) {
                if (!s.startsWith("\"")) continue;
                hasQuotes = true;
                break;
            }
            if (hasQuotes) {
                ArrayList<String> newList = new ArrayList<String>();
                for (int i = 0; i < list.size(); ++i) {
                    String s = list.get(i);
                    if (s.startsWith("-D") && s.endsWith("=") && i + 1 < list.size() && list.get(i + 1).startsWith("\"")) {
                        String longString = null;
                        int j = i + 1;
                        while (j < list.size() && list.get(j).startsWith("\"")) {
                            longString = longString != null ? longString + " " + list.get(j) : list.get(j);
                            i = j++;
                        }
                        newList.add(s + "`" + longString + "`");
                        continue;
                    }
                    newList.add(s);
                }
                list = newList;
            }
            if ((st = list.listIterator()).hasNext() && (option = st.next()).equals("+") && st.hasNext()) {
                st.next();
            }
            return this.gatherCompilerLine(st, isScriptOutput, isCpp);
        }

        public Artifacts gatherCompilerLine(ListIterator<String> st, CompileLineOrigin isScriptOutput, boolean isCpp) {
            ArtifactsImpl artifacts = new ArtifactsImpl();
            List<String> what = artifacts.input;
            ArrayList<String> importantCandidates = new ArrayList<String>();
            while (st.hasNext()) {
                String path;
                String macro;
                String option = st.next();
                boolean isQuote = false;
                if (isScriptOutput == CompileLineOrigin.BuildLog && (option.startsWith("'") && option.endsWith("'") || option.startsWith("\"") && option.endsWith("\"")) && option.length() >= 2) {
                    option = option.substring(1, option.length() - 1);
                    isQuote = true;
                }
                if (option.startsWith("--")) {
                    option = option.substring(1);
                }
                if (option.startsWith("-D")) {
                    macro = option.equals("-D") && st.hasNext() ? st.next() : option.substring(2);
                    int i = (macro = DriverFactory.removeQuotes(macro)).indexOf(61);
                    if (i > 0) {
                        String value = macro.substring(i + 1).trim();
                        value = DriverFactory.normalizeDefineOption(value, isScriptOutput, isQuote);
                        String key = DriverFactory.removeEscape(macro.substring(0, i));
                        this.addDef(key, value, artifacts.userMacros, artifacts.undefinedMacros);
                        continue;
                    }
                    String key = DriverFactory.removeEscape(macro);
                    this.addDef(key, null, artifacts.userMacros, artifacts.undefinedMacros);
                    continue;
                }
                if (option.startsWith("-U")) {
                    macro = option.substring(2);
                    if (macro.length() == 0 && st.hasNext()) {
                        macro = st.next();
                    }
                    macro = DriverFactory.removeQuotes(macro);
                    this.addUndef(macro, artifacts.userMacros, artifacts.undefinedMacros);
                    continue;
                }
                if (option.startsWith("-I")) {
                    path = option.substring(2);
                    if (path.length() == 0 && st.hasNext()) {
                        path = st.next();
                    }
                    path = DriverFactory.removeQuotes(path);
                    artifacts.userIncludes.add(path);
                    continue;
                }
                if (option.startsWith("-F")) {
                    if (!option.equals("-F") || !st.hasNext()) continue;
                    path = st.next();
                    path = DriverFactory.removeQuotes(path) + "/{framework}";
                    artifacts.userIncludes.add(path);
                    continue;
                }
                if (option.startsWith("-isystem")) {
                    path = option.substring(8);
                    if (path.length() == 0 && st.hasNext()) {
                        path = st.next();
                    }
                    path = DriverFactory.removeQuotes(path);
                    artifacts.userIncludes.add(path);
                    continue;
                }
                if (option.startsWith("-include")) {
                    path = option.substring(8);
                    if (path.length() == 0 && st.hasNext()) {
                        path = st.next();
                    }
                    path = DriverFactory.removeQuotes(path);
                    artifacts.userFiles.add(path);
                    continue;
                }
                if (option.startsWith("-imacros")) {
                    path = option.substring(8);
                    if (path.length() == 0 && st.hasNext()) {
                        path = st.next();
                    }
                    path = DriverFactory.removeQuotes(path);
                    artifacts.userFiles.add(path);
                    continue;
                }
                if (option.startsWith("-Y")) {
                    String defaultSearchPath = option.substring(2);
                    if (defaultSearchPath.length() == 0 && st.hasNext()) {
                        defaultSearchPath = st.next();
                    }
                    if (!defaultSearchPath.startsWith("I,")) continue;
                    defaultSearchPath = defaultSearchPath.substring(2);
                    defaultSearchPath = DriverFactory.removeQuotes(defaultSearchPath);
                    artifacts.userIncludes.add(defaultSearchPath);
                    continue;
                }
                if (option.startsWith("-idirafter")) {
                    if (!option.equals("-idirafter") || !st.hasNext()) continue;
                    st.next();
                    continue;
                }
                if (option.startsWith("-iprefix")) {
                    if (!option.equals("-iprefix") || !st.hasNext()) continue;
                    st.next();
                    continue;
                }
                if (option.startsWith("-iwithprefix")) {
                    if (!option.equals("-iwithprefix") || !st.hasNext()) continue;
                    st.next();
                    continue;
                }
                if (option.startsWith("-iwithprefixbefore")) {
                    if (!option.equals("-iwithprefixbefore") || !st.hasNext()) continue;
                    st.next();
                    continue;
                }
                if (option.startsWith("-isysroot")) {
                    path = option.substring(9);
                    if (path.length() == 0 && st.hasNext()) {
                        path = st.next();
                    }
                    artifacts.importantFlags.add(option);
                    path = DriverFactory.removeQuotes(path);
                    artifacts.importantFlags.add(path);
                    continue;
                }
                if (option.startsWith("-iquote")) {
                    if (!option.equals("-iquote") || !st.hasNext()) continue;
                    st.next();
                    continue;
                }
                if (option.equals("-K")) {
                    if (!st.hasNext()) continue;
                    String next = st.next();
                    if (next.equals("PIC") || next.equals("pic")) {
                        importantCandidates.add(option + next);
                        continue;
                    }
                    st.previous();
                    continue;
                }
                if (option.equals("-R")) {
                    if (!st.hasNext()) continue;
                    st.next();
                    continue;
                }
                if (option.startsWith("-l")) {
                    String lib = option.substring(2);
                    if (lib.length() == 0 && st.hasNext()) {
                        lib = st.next();
                    }
                    if (lib.length() <= 0) continue;
                    artifacts.libraries.add(lib);
                    continue;
                }
                if (option.equals("-L")) {
                    if (!st.hasNext()) continue;
                    st.next();
                    continue;
                }
                if (option.equals("-M")) {
                    if (!st.hasNext()) continue;
                    st.next();
                    continue;
                }
                if (option.equals("-h")) {
                    if (!st.hasNext()) continue;
                    st.next();
                    continue;
                }
                if (option.equals("-o")) {
                    if (!st.hasNext()) continue;
                    artifacts.output = st.next();
                    continue;
                }
                if (option.equals("-z")) {
                    if (!st.hasNext()) continue;
                    st.next();
                    continue;
                }
                if (option.equals("-x")) {
                    if (!st.hasNext()) continue;
                    String lang = st.next();
                    artifacts.languageArtifacts.add(lang);
                    if (lang.equals("c")) {
                        isCpp = false;
                    } else if (lang.equals("c++")) {
                        isCpp = true;
                    }
                    importantCandidates.add(option + lang);
                    continue;
                }
                if (option.equals("-xc")) {
                    artifacts.languageArtifacts.add("c");
                    isCpp = false;
                    importantCandidates.add(option);
                    continue;
                }
                if (option.equals("-xc++")) {
                    artifacts.languageArtifacts.add("c++");
                    isCpp = true;
                    importantCandidates.add(option);
                    continue;
                }
                if (C89.contains(option)) {
                    artifacts.languageArtifacts.add("c89");
                    isCpp = false;
                    importantCandidates.add(option);
                    continue;
                }
                if (C99.contains(option)) {
                    artifacts.languageArtifacts.add("c99");
                    isCpp = false;
                    importantCandidates.add(option);
                    continue;
                }
                if (C11.contains(option)) {
                    artifacts.languageArtifacts.add("c11");
                    isCpp = false;
                    importantCandidates.add(option);
                    continue;
                }
                if (CPP11.contains(option)) {
                    artifacts.languageArtifacts.add("c++11");
                    isCpp = true;
                    importantCandidates.add(option);
                    continue;
                }
                if (CPP14.contains(option)) {
                    artifacts.languageArtifacts.add("c++14");
                    isCpp = true;
                    importantCandidates.add(option);
                    continue;
                }
                if (CPP98.contains(option)) {
                    artifacts.languageArtifacts.add("c++98");
                    isCpp = true;
                    importantCandidates.add(option);
                    continue;
                }
                if (option.equals("-xMF")) {
                    if (!st.hasNext()) continue;
                    st.next();
                    continue;
                }
                if (option.equals("-MF")) {
                    if (!st.hasNext()) continue;
                    st.next();
                    continue;
                }
                if (option.equals("-MT")) {
                    if (!st.hasNext()) continue;
                    st.next();
                    continue;
                }
                if (option.equals("-MQ")) {
                    if (!st.hasNext()) continue;
                    st.next();
                    continue;
                }
                if (option.equals("-aux-info")) {
                    if (!st.hasNext()) continue;
                    st.next();
                    continue;
                }
                if (option.startsWith("-")) {
                    importantCandidates.add(option);
                    continue;
                }
                if (option.startsWith("ccfe")) continue;
                if (option.startsWith(">")) break;
                if (!SourcesVisibilityQuery.getDefault().isVisible(option)) continue;
                what.add(option);
            }
            for (String candidate : importantCandidates) {
                if (!this.isImportantFlag(candidate, isCpp)) continue;
                artifacts.importantFlags.add(candidate);
            }
            return artifacts;
        }

        private void addDef(String macro, String value, Map<String, String> userMacros, List<String> undefinedMacros) {
            undefinedMacros.remove(macro);
            userMacros.put(macro, value);
        }

        private void addUndef(String macro, Map<String, String> userMacros, List<String> undefinedMacros) {
            if (userMacros.containsKey(macro)) {
                userMacros.remove(macro);
            } else if (!undefinedMacros.contains(macro)) {
                undefinedMacros.add(macro);
            }
        }

        private boolean isImportantFlag(String flag, boolean isCPP) {
            if (isCPP) {
                if (!this.cppPatternInited) {
                    String importantFlags;
                    AbstractCompiler compiler;
                    if (this.compilerSet != null && (compiler = (AbstractCompiler)this.compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler)) != null && compiler.getDescriptor() != null && (importantFlags = compiler.getDescriptor().getImportantFlags()) != null && importantFlags.length() > 0) {
                        this.cppPattern = Pattern.compile(importantFlags);
                    }
                    this.cppPatternInited = true;
                }
                if (this.cppPattern != null) {
                    return this.cppPattern.matcher(flag).find();
                }
            } else {
                if (!this.cPatternInited) {
                    String importantFlags;
                    AbstractCompiler compiler;
                    if (this.compilerSet != null && (compiler = (AbstractCompiler)this.compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler)) != null && compiler.getDescriptor() != null && (importantFlags = compiler.getDescriptor().getImportantFlags()) != null && importantFlags.length() > 0) {
                        this.cPattern = Pattern.compile(importantFlags);
                    }
                    this.cPatternInited = true;
                }
                if (this.cPattern != null) {
                    return this.cPattern.matcher(flag).find();
                }
            }
            return false;
        }
    }
}

