/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.api.project.IncludePath;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileSearch;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.discovery.api.DriverFactory;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.QtInfoProvider;
import org.netbeans.modules.cnd.dwarfdump.source.Artifacts;
import org.netbeans.modules.cnd.dwarfdump.source.CompileLineOrigin;
import org.netbeans.modules.cnd.dwarfdump.source.Driver;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.spi.configurations.PkgConfigManager;
import org.netbeans.modules.cnd.makeproject.spi.configurations.UserOptionsProvider;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileSystem;

public class UserOptionsProviderImpl
implements UserOptionsProvider {
    private final Map<String, PkgConfigManager.PkgConfig> pkgConfigs = new HashMap<String, PkgConfigManager.PkgConfig>();
    private final Map<ExecutionEnvironment, Map<String, PkgConfigManager.PackageConfiguration>> commandCache = new WeakHashMap<ExecutionEnvironment, Map<String, PkgConfigManager.PackageConfiguration>>();

    public List<IncludePath> getItemUserIncludePaths(List<IncludePath> includes, AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
        ArrayList<IncludePath> res = new ArrayList<IncludePath>();
        if (makeConfiguration.getConfigurationType().getValue() != 0) {
            ExecutionEnvironment env = this.getExecutionEnvironment(makeConfiguration);
            FileSystem fs = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
            for (PkgConfigManager.PackageConfiguration pc : this.getPackages(compilerOptions.getAllOptions((Tool)compiler), makeConfiguration)) {
                for (String path : pc.getIncludePaths()) {
                    res.add(new IncludePath(fs, path));
                }
            }
        }
        if (makeConfiguration.isQmakeConfiguration()) {
            res.addAll(QtInfoProvider.getDefault().getQtIncludeDirectories(makeConfiguration));
        }
        return res;
    }

    private ExecutionEnvironment getExecutionEnvironment(MakeConfiguration makeConfiguration) {
        return makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
    }

    public List<String> getItemUserMacros(List<String> macros, AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
        ArrayList<String> res = new ArrayList<String>();
        if (makeConfiguration.getConfigurationType().getValue() != 0) {
            String options = compilerOptions.getAllOptions((Tool)compiler);
            for (PkgConfigManager.PackageConfiguration pc : this.getPackages(options, makeConfiguration)) {
                res.addAll(pc.getMacros());
            }
        }
        if (makeConfiguration.isQmakeConfiguration()) {
            res.addAll(QtInfoProvider.getDefault().getQtAdditionalMacros(makeConfiguration));
        }
        return res;
    }

    public String getItemImportantFlags(AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
        String importantFlags;
        if (makeConfiguration.getConfigurationType().getValue() != 0 && compiler != null && compiler.getDescriptor() != null && (importantFlags = compiler.getDescriptor().getImportantFlags()) != null && importantFlags.length() > 0) {
            StringBuilder buf = new StringBuilder();
            Pattern pattern = Pattern.compile(importantFlags);
            String options = compilerOptions.getAllOptions((Tool)compiler);
            String[] split = options.split(" ");
            for (int i = 0; i < split.length; ++i) {
                String s = split[i];
                if (!s.startsWith("-")) continue;
                if (s.equals("-x") && i + 1 < split.length) {
                    s = s + split[++i];
                }
                if (!pattern.matcher(s).find()) continue;
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(s);
                if (!"-isysroot".equals(s) || i + 1 >= split.length) continue;
                buf.append(' ');
                buf.append(split[i + 1]);
            }
            return buf.toString();
        }
        return null;
    }

    public NativeFileItem.LanguageFlavor getLanguageFlavor(AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
        if (makeConfiguration.getConfigurationType().getValue() != 0) {
            String options = compilerOptions.getAllOptions((Tool)compiler);
            if (compiler.getKind() == PredefinedToolKind.CCompiler) {
                Driver driver = DriverFactory.getDriver(null);
                Artifacts artifacts = driver.gatherCompilerLine("gcc " + options, CompileLineOrigin.BuildLog, false);
                ItemProperties.LanguageStandard languageStandard = DriverFactory.getLanguageStandard(ItemProperties.LanguageStandard.Unknown, artifacts);
                switch (languageStandard) {
                    case C89: {
                        return NativeFileItem.LanguageFlavor.C89;
                    }
                    case C99: {
                        return NativeFileItem.LanguageFlavor.C99;
                    }
                    case C11: {
                        return NativeFileItem.LanguageFlavor.C11;
                    }
                }
            } else if (compiler.getKind() == PredefinedToolKind.CCCompiler) {
                Driver driver = DriverFactory.getDriver(null);
                Artifacts artifacts = driver.gatherCompilerLine("g++ " + options, CompileLineOrigin.BuildLog, true);
                ItemProperties.LanguageStandard languageStandard = DriverFactory.getLanguageStandard(ItemProperties.LanguageStandard.Unknown, artifacts);
                switch (languageStandard) {
                    case CPP11: {
                        return NativeFileItem.LanguageFlavor.CPP11;
                    }
                    case CPP14: {
                        return NativeFileItem.LanguageFlavor.CPP14;
                    }
                }
            } else if (compiler.getKind() == PredefinedToolKind.FortranCompiler) {
                // empty if block
            }
        }
        return NativeFileItem.LanguageFlavor.UNKNOWN;
    }

    private List<PkgConfigManager.PackageConfiguration> getPackages(String s, MakeConfiguration conf) {
        String pkg;
        int j;
        int i;
        ArrayList<PkgConfigManager.PackageConfiguration> res = new ArrayList<PkgConfigManager.PackageConfiguration>();
        while ((i = s.indexOf(96)) >= 0 && (j = (pkg = s.substring(i + 1)).indexOf(96)) > 0) {
            PkgConfigManager.PackageConfiguration config;
            String executable = pkg.substring(0, j);
            s = s.substring(i + executable.length() + 2);
            if (executable.startsWith("pkg-config ")) {
                config = this.getPkgConfigOutput(conf, executable);
                if (config == null) continue;
                res.add(config);
                continue;
            }
            config = this.getCommandOutput(conf, executable);
            if (config == null) continue;
            res.add(config);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PkgConfigManager.PkgConfig getPkgConfig(ExecutionEnvironment env) {
        PkgConfigManager.PkgConfig pkg;
        String hostKey = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
        Map<String, PkgConfigManager.PkgConfig> map = this.pkgConfigs;
        synchronized (map) {
            pkg = this.pkgConfigs.get(hostKey);
            if (pkg == null && ConnectionManager.getInstance().isConnectedTo(env)) {
                pkg = PkgConfigManager.getDefault().getPkgConfig(env);
                this.pkgConfigs.put(hostKey, pkg);
            }
        }
        return pkg;
    }

    public NativeFileSearch getPackageFileSearch(final ExecutionEnvironment env) {
        final PkgConfigManager.PkgConfig pkg = this.getPkgConfig(env);
        if (pkg != null) {
            return new NativeFileSearch(){

                public Collection<FSPath> searchFile(NativeProject project, String fileName) {
                    Collection resolvedPath = pkg.getResolvedPath(fileName);
                    ArrayList<FSPath> res = new ArrayList<FSPath>(1);
                    if (resolvedPath != null) {
                        FileSystem fileSystem = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
                        char fileSeparatorChar = FileSystemProvider.getFileSeparatorChar((FileSystem)fileSystem);
                        for (PkgConfigManager.ResolvedPath path : resolvedPath) {
                            String absPath = path.getIncludePath() + fileSeparatorChar + fileName;
                            res.add(new FSPath(fileSystem, absPath));
                        }
                    }
                    return res;
                }
            };
        }
        return null;
    }

    private PkgConfigManager.PackageConfiguration getPkgConfigOutput(MakeConfiguration conf, String executable) {
        PkgConfigManager.PackageConfiguration config;
        PkgConfigManager.PkgConfig configs;
        String pkg = executable.substring(11).trim();
        StringTokenizer st = new StringTokenizer(pkg);
        boolean readFlags = false;
        String findPkg = null;
        while (st.hasMoreTokens()) {
            String aPkg = st.nextToken();
            if (aPkg.equals("--cflags")) {
                readFlags = true;
                continue;
            }
            if (aPkg.startsWith("-")) {
                readFlags = false;
                continue;
            }
            findPkg = aPkg;
        }
        if (readFlags && findPkg != null && (configs = this.getPkgConfig(this.getExecutionEnvironment(conf))) != null && (config = configs.getPkgConfig(findPkg)) != null) {
            return config;
        }
        return null;
    }

    private synchronized PkgConfigManager.PackageConfiguration getCommandOutput(MakeConfiguration conf, String command) {
        ExecutionEnvironment env = this.getExecutionEnvironment(conf);
        Map<String, PkgConfigManager.PackageConfiguration> map = this.commandCache.get(env);
        if (map == null) {
            map = new HashMap<String, PkgConfigManager.PackageConfiguration>();
            this.commandCache.put(env, map);
        }
        if (map.containsKey(command)) {
            return map.get(command);
        }
        ArrayList<String> args = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(command, " ");
        String executable = null;
        while (st.hasMoreTokens()) {
            if (executable == null) {
                executable = st.nextToken();
                continue;
            }
            args.add(st.nextToken());
        }
        ProcessUtils.ExitStatus status = ProcessUtils.executeInDir((String)conf.getMakefileConfiguration().getAbsBuildCommandWorkingDir(), (ExecutionEnvironment)env, (String)executable, (String[])args.toArray(new String[args.size()]));
        String flags = status.getOutputString();
        MyPackageConfiguration config = null;
        if (flags != null) {
            config = new MyPackageConfiguration(executable, flags);
        }
        map.put(command, config);
        return config;
    }

    private static final class MyPackageConfiguration
    implements PkgConfigManager.PackageConfiguration {
        private final String executable;
        private final List<String> macros = new ArrayList<String>();
        private final List<String> paths = new ArrayList<String>();

        private MyPackageConfiguration(String executable, String flags) {
            this.executable = executable;
            StringTokenizer st = new StringTokenizer(flags, " ");
            while (st.hasMoreElements()) {
                String t = st.nextToken();
                if (t.startsWith("-I")) {
                    this.paths.add(t.substring(2));
                    continue;
                }
                if (!t.startsWith("-D")) continue;
                this.macros.add(t.substring(2));
            }
        }

        public String getName() {
            return this.executable;
        }

        public Collection<String> getIncludePaths() {
            return this.paths;
        }

        public Collection<String> getMacros() {
            return this.macros;
        }

        public String getDisplayName() {
            return this.executable;
        }

        public String getLibs() {
            return "";
        }

        public String getVersion() {
            return "";
        }
    }
}

