/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.ProviderPropertyType;
import org.netbeans.modules.cnd.discovery.wizard.ProviderControl;
import org.netbeans.modules.cnd.discovery.wizard.SelectObjectFilesWizard;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;

public final class SelectObjectFilesPanel
extends JPanel {
    private final SelectObjectFilesWizard wizard;
    private final List<ProviderControl> controls = new ArrayList<ProviderControl>();
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JPanel providerPanel;

    public SelectObjectFilesPanel(SelectObjectFilesWizard wizard) {
        this.wizard = wizard;
        this.initComponents();
    }

    void read(DiscoveryDescriptor wizardDescriptor) {
        DiscoveryProvider provider = wizardDescriptor.getProvider();
        if (provider != null) {
            this.providerPanel.removeAll();
            this.controls.clear();
            boolean first = true;
            block6: for (String key : provider.getPropertyKeys()) {
                ProviderProperty property = provider.getProperty(key);
                switch (property.getPropertyType().kind()) {
                    case MakeLogFile: 
                    case BinaryFile: 
                    case Folder: 
                    case BinaryFiles: {
                        ProviderControl pc = new ProviderControl(key, property, wizardDescriptor, this.providerPanel, this.wizard);
                        this.controls.add(pc);
                        if (!first) break;
                        this.instructionsTextArea.setText(property.getDescription());
                        first = false;
                        break;
                    }
                    case ArtifactFileSystem: {
                        try {
                            FileSystem fileSystem = wizardDescriptor.getProject().getProjectDirectory().getFileSystem();
                            if (ProviderPropertyType.LogFileSystemPropertyType == property.getPropertyType()) {
                                ProviderPropertyType.LogFileSystemPropertyType.setProperty(provider, fileSystem);
                                break;
                            }
                            if (ProviderPropertyType.BinaryFileSystemPropertyType != property.getPropertyType()) continue block6;
                            ProviderPropertyType.BinaryFileSystemPropertyType.setProperty(provider, fileSystem);
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {}
                        break;
                    }
                }
            }
        }
    }

    void store(DiscoveryDescriptor wizardDescriptor) {
        for (ProviderControl pc : this.controls) {
            pc.store();
        }
        wizardDescriptor.setInvokeProvider(true);
    }

    boolean valid() {
        if (this.controls.size() == 0) {
            return false;
        }
        for (ProviderControl pc : this.controls) {
            if (pc.valid()) continue;
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.providerPanel = new JPanel();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new GridBagLayout());
        this.providerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.providerPanel, gridBagConstraints);
        this.instructionPanel.setLayout(new BorderLayout());
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle");
        this.instructionsTextArea.setText(bundle.getString("BuildActionsInstructions"));
        this.instructionsTextArea.setWrapStyleWord(true);
        this.instructionsTextArea.setOpaque(false);
        this.instructionPanel.add((Component)this.instructionsTextArea, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
    }
}

