/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm;

import com.sun.xml.ws.api.FeatureConstructor;
import com.sun.xml.ws.rx.rm.RmVersion;
import javax.xml.ws.WebServiceFeature;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;

@ManagedData
public class ReliableMessagingFeature
extends WebServiceFeature {
    public static final String ID = "com.sun.xml.ws.rm.ReliableMessagingFeature";
    public static final long DEFAULT_SEQUENCE_INACTIVITY_TIMEOUT = 600000L;
    public static final long DEFAULT_DESTINATION_BUFFER_QUOTA = 32L;
    public static final long DEFAULT_MESSAGE_RETRANSMISSION_INTERVAL = 2000L;
    public static final long DEFAULT_MAX_MESSAGE_RETRANSMISSION_COUNT = -1L;
    public static final long DEFAULT_ACKNOWLEDGEMENT_TRANSMISSION_INTERVAL = -1L;
    public static final long DEFAULT_ACK_REQUEST_TRANSMISSION_INTERVAL = 2000L;
    public static final long DEFAULT_CLOSE_SEQUENCE_OPERATION_TIMEOUT = 3000L;
    public static final long DEFAULT_SEQUENCE_MANAGER_MAINTENANCE_PERIOD = 60000L;
    public static final long DEFAULT_MAX_CONCURRENT_SESSIONS = -1L;
    private final RmVersion version;
    private final long sequenceInactivityTimeout;
    private final long destinationBufferQuota;
    private final boolean orderedDelivery;
    private final DeliveryAssurance deliveryAssurance;
    private final SecurityBinding securityBinding;
    private final long messageRetransmissionInterval;
    private final BackoffAlgorithm retransmissionBackoffAlgorithm;
    private final long maxMessageRetransmissionCount;
    private final long acknowledgementTransmissionInterval;
    private final long ackRequestTransmissionInterval;
    private final long closeSequenceOperationTimeout;
    private final boolean persistenceEnabled;
    private final long sequenceManagerMaintenancePeriod;
    private final long maxConcurrentSessions;

    public ReliableMessagingFeature() {
        this(true);
    }

    public ReliableMessagingFeature(boolean enabled) {
        this(enabled, RmVersion.getDefault(), 600000L, 32L, false, DeliveryAssurance.getDefault(), SecurityBinding.getDefault(), 2000L, BackoffAlgorithm.getDefault(), -1L, -1L, 2000L, 3000L, false, 60000L, -1L);
    }

    @FeatureConstructor(value={"enabled", "version", "sequenceInactivityTimeout", "destinationBufferQuota", "orderedDeliveryEnabled", "deliveryAssurance", "securityBinding", "persistenceEnabled", "sequenceManagerMaintenancePeriod", "maxConcurrentSessions"})
    public ReliableMessagingFeature(boolean enabled, RmVersion version, long inactivityTimeout, long bufferQuota, boolean orderedDelivery, DeliveryAssurance deliveryAssurance, SecurityBinding securityBinding, boolean persistenceEnabled, long sequenceManagerMaintenancePeriod, long maxConcurrentSessions) {
        this(enabled, version, inactivityTimeout, bufferQuota, orderedDelivery, deliveryAssurance, securityBinding, 2000L, BackoffAlgorithm.getDefault(), -1L, -1L, 2000L, 3000L, persistenceEnabled, sequenceManagerMaintenancePeriod, maxConcurrentSessions);
    }

    public ReliableMessagingFeature(boolean enabled, RmVersion version, long inactivityTimeout, long bufferQuota, boolean orderedDelivery, DeliveryAssurance deliveryAssurance, SecurityBinding securityBinding, long messageRetransmissionInterval, BackoffAlgorithm retransmissionBackoffAlgorithm, long maxMessageRetransmissionCount, long acknowledgementTransmissionInterval, long ackRequestTransmissionInterval, long closeSequenceOperationTimeout, boolean persistenceEnabled, long sequenceManagerMaintenancePeriod, long maxConcurrentRmSessions) {
        this.enabled = enabled;
        this.version = version;
        this.sequenceInactivityTimeout = inactivityTimeout;
        this.destinationBufferQuota = bufferQuota;
        this.orderedDelivery = orderedDelivery;
        this.deliveryAssurance = deliveryAssurance;
        this.securityBinding = securityBinding;
        this.messageRetransmissionInterval = messageRetransmissionInterval;
        this.retransmissionBackoffAlgorithm = retransmissionBackoffAlgorithm;
        this.maxMessageRetransmissionCount = maxMessageRetransmissionCount;
        this.acknowledgementTransmissionInterval = acknowledgementTransmissionInterval;
        this.ackRequestTransmissionInterval = ackRequestTransmissionInterval;
        this.closeSequenceOperationTimeout = closeSequenceOperationTimeout;
        this.persistenceEnabled = persistenceEnabled;
        this.sequenceManagerMaintenancePeriod = sequenceManagerMaintenancePeriod;
        this.maxConcurrentSessions = maxConcurrentRmSessions;
    }

    @ManagedAttribute
    public String getID() {
        return ID;
    }

    @ManagedAttribute
    public RmVersion getVersion() {
        return this.version;
    }

    @ManagedAttribute
    public long getSequenceInactivityTimeout() {
        return this.sequenceInactivityTimeout;
    }

    @ManagedAttribute
    public SecurityBinding getSecurityBinding() {
        return this.securityBinding;
    }

    @ManagedAttribute
    public DeliveryAssurance getDeliveryAssurance() {
        return this.deliveryAssurance;
    }

    @ManagedAttribute
    public boolean isOrderedDeliveryEnabled() {
        return this.orderedDelivery;
    }

    @ManagedAttribute
    public long getDestinationBufferQuota() {
        return this.destinationBufferQuota;
    }

    @ManagedAttribute
    public long getMessageRetransmissionInterval() {
        return this.messageRetransmissionInterval;
    }

    @ManagedAttribute
    public BackoffAlgorithm getRetransmissionBackoffAlgorithm() {
        return this.retransmissionBackoffAlgorithm;
    }

    @ManagedAttribute
    public long getMaxMessageRetransmissionCount() {
        return this.maxMessageRetransmissionCount;
    }

    @ManagedAttribute
    public long getAcknowledgementTransmissionInterval() {
        return this.acknowledgementTransmissionInterval;
    }

    @ManagedAttribute
    public long getAckRequestTransmissionInterval() {
        return this.ackRequestTransmissionInterval;
    }

    @ManagedAttribute
    public long getCloseSequenceOperationTimeout() {
        return this.closeSequenceOperationTimeout;
    }

    @ManagedAttribute
    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    @ManagedAttribute
    public long getSequenceManagerMaintenancePeriod() {
        return this.sequenceManagerMaintenancePeriod;
    }

    @ManagedAttribute
    public long getMaxConcurrentSessions() {
        return this.maxConcurrentSessions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BackoffAlgorithm {
        LINEAR("Linear"){

            public long getDelayInMillis(int resendAttemptNumber, long baseRate) {
                return baseRate;
            }
        }
        ,
        EXPONENTIAL("Exponential"){

            public long getDelayInMillis(int resendAttemptNumber, long baseRate) {
                return (long)resendAttemptNumber * baseRate;
            }
        };

        private final String name;

        private BackoffAlgorithm(String name) {
            this.name = name;
        }

        public static BackoffAlgorithm parse(String name) {
            for (BackoffAlgorithm value : BackoffAlgorithm.values()) {
                if (!value.name.equals(name)) continue;
                return value;
            }
            return null;
        }

        public static BackoffAlgorithm getDefault() {
            return LINEAR;
        }

        public abstract long getDelayInMillis(int var1, long var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeliveryAssurance {
        EXACTLY_ONCE,
        AT_LEAST_ONCE,
        AT_MOST_ONCE;


        public static DeliveryAssurance getDefault() {
            return EXACTLY_ONCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SecurityBinding {
        STR,
        TRANSPORT,
        NONE;


        public static SecurityBinding getDefault() {
            return NONE;
        }
    }
}

