/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorConfiguration
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.ValidatorConfiguration,
SecurityAssertionValidator {
    private boolean populated = false;
    private Iterator<PolicyAssertion> ast = null;
    private static QName cmaxClockSkew = new QName("http://schemas.sun.com/2006/03/wss/client", "maxClockSkew");
    private static QName smaxClockSkew = new QName("http://schemas.sun.com/2006/03/wss/server", "maxClockSkew");
    private static QName ctimestampFreshnessLimit = new QName("http://schemas.sun.com/2006/03/wss/client", "timestampFreshnessLimit");
    private static QName stimestampFreshnessLimit = new QName("http://schemas.sun.com/2006/03/wss/server", "timestampFreshnessLimit");
    private static QName smaxNonceAge = new QName("http://schemas.sun.com/2006/03/wss/server", "maxNonceAge");
    private static QName crevocationEnabled = new QName("http://schemas.sun.com/2006/03/wss/client", "revocationEnabled");
    private static QName srevocationEnabled = new QName("http://schemas.sun.com/2006/03/wss/server", "revocationEnabled");
    private static QName cenforceKeyUsage = new QName("http://schemas.sun.com/2006/03/wss/client", "enforceKeyUsage");
    private static QName senforceKeyUsage = new QName("http://schemas.sun.com/2006/03/wss/server", "enforceKeyUsage");
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;

    public ValidatorConfiguration() {
    }

    public ValidatorConfiguration(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
    }

    @Override
    public Iterator<? extends PolicyAssertion> getValidators() {
        this.populate();
        return this.ast;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            this.ast = this.getNestedAssertionsIterator();
            this.populated = true;
        }
        return this.fitness;
    }

    @Override
    public String getMaxClockSkew() {
        if (this.getAttributes().containsKey(cmaxClockSkew)) {
            return this.getAttributeValue(cmaxClockSkew);
        }
        if (this.getAttributes().containsKey(smaxClockSkew)) {
            return this.getAttributeValue(smaxClockSkew);
        }
        return null;
    }

    @Override
    public String getTimestampFreshnessLimit() {
        if (this.getAttributes().containsKey(ctimestampFreshnessLimit)) {
            return this.getAttributeValue(ctimestampFreshnessLimit);
        }
        if (this.getAttributes().containsKey(stimestampFreshnessLimit)) {
            return this.getAttributeValue(stimestampFreshnessLimit);
        }
        return null;
    }

    @Override
    public String getMaxNonceAge() {
        if (this.getAttributes().containsKey(smaxNonceAge)) {
            return this.getAttributeValue(smaxNonceAge);
        }
        return null;
    }

    @Override
    public String getRevocationEnabled() {
        if (this.getAttributes().containsKey(crevocationEnabled)) {
            return this.getAttributeValue(crevocationEnabled);
        }
        if (this.getAttributes().containsKey(srevocationEnabled)) {
            return this.getAttributeValue(srevocationEnabled);
        }
        return null;
    }

    @Override
    public String getEnforceKeyUsage() {
        if (this.getAttributes().containsKey(cenforceKeyUsage)) {
            return this.getAttributeValue(cenforceKeyUsage);
        }
        if (this.getAttributes().containsKey(senforceKeyUsage)) {
            return this.getAttributeValue(senforceKeyUsage);
        }
        return null;
    }
}

