/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.xml.wss.NonceManager;
import java.util.Hashtable;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;

@ManagedData
public class NonceCache
extends TimerTask {
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private Hashtable nonceCache = new Hashtable();
    private Hashtable oldNonceCache = new Hashtable();
    private long MAX_NONCE_AGE = 900000L;
    private boolean scheduledFlag = false;
    private boolean canceledFlag = false;

    @ManagedAttribute
    private Hashtable getNonceCache() {
        return this.nonceCache;
    }

    @ManagedAttribute
    private Hashtable getOldNonceCache() {
        return this.oldNonceCache;
    }

    public NonceCache() {
    }

    public NonceCache(long maxNonceAge) {
        this.MAX_NONCE_AGE = maxNonceAge;
    }

    public boolean validateAndCacheNonce(String nonce, String created) throws NonceManager.NonceException {
        if (this.nonceCache.containsKey(nonce) || this.oldNonceCache.containsKey(nonce)) {
            log.log(Level.WARNING, "Nonce Repeated : Nonce Cache already contains the nonce value :" + nonce);
            throw new NonceManager.NonceException("Nonce Repeated : Nonce Cache already contains the nonce value :" + nonce);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Storing Nonce Value " + nonce + " into " + this);
        }
        this.nonceCache.put(nonce, created);
        return true;
    }

    @ManagedAttribute
    public boolean isScheduled() {
        return this.scheduledFlag;
    }

    public void scheduled(boolean flag) {
        this.scheduledFlag = flag;
    }

    @ManagedAttribute
    public boolean wasCanceled() {
        return this.canceledFlag;
    }

    public void run() {
        if (this.nonceCache.size() == 0) {
            this.cancel();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Canceled Timer Task due to inactivity ...for " + this);
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Clearing old Nonce values...for " + this);
        }
        this.oldNonceCache.clear();
        Hashtable temp = this.nonceCache;
        this.nonceCache = this.oldNonceCache;
        this.oldNonceCache = temp;
    }

    public boolean cancel() {
        boolean ret = super.cancel();
        this.canceledFlag = true;
        this.oldNonceCache.clear();
        this.nonceCache.clear();
        return ret;
    }

    @ManagedAttribute
    public long getMaxNonceAge() {
        return this.MAX_NONCE_AGE;
    }
}

