/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.util.FileUtils;
import com.sun.javacard.util.ZipUtils;
import com.sun.javacard.validator.AppletXML;
import com.sun.javacard.validator.Classes;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.Module;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Vector;

public class ClassicModule
extends Module {
    private Vector<File> exportFiles;
    private AppletXML appletXML = null;
    private static Vector<String> mandatoryCAPComponentsForModule = new Vector<String>(){
        {
            this.addElement("applet.cap");
            this.addElement("header.cap");
            this.addElement("directory.cap");
            this.addElement("import.cap");
            this.addElement("constantpool.cap");
            this.addElement("class.cap");
            this.addElement("method.cap");
            this.addElement("staticfield.cap");
            this.addElement("reflocation.cap");
            this.addElement("descriptor.cap");
        }
    };

    public ClassicModule(String string) {
        super(string);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.isOk()) {
            return;
        }
        String string = "APPLET-INF";
        File file = new File(this.folder, "APPLET-INF/applet.xml");
        if (file.exists()) {
            this.appletXML = new AppletXML(file);
            this.addItem(this.appletXML);
            this.appletXML.initialize();
        } else {
            this.addError(ErrorKey.AppletXmlFileDoesNotExists, file.getName());
        }
        File file2 = new File(this.folder, string + "/classes");
        if (!file2.exists()) {
            file2 = null;
        }
        this.classes = new Classes(file2);
        this.addItem(this.classes);
        this.classes.initialize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processInternal() {
        super.processInternal();
        if (!this.isOk()) {
            return;
        }
        Vector<File> vector = FileUtils.listAllFilesInFolder(this.folder, ".class");
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < vector.size(); ++i) {
            void object2;
            File file = vector.elementAt(i).getParentFile();
            if (file.getName().equals("proxy")) {
                File file2 = file.getParentFile();
            }
            hashSet.add(object2.getAbsolutePath());
        }
        if (hashSet.size() > 1) {
            this.addError(ErrorKey.OnlyOnePackageInClassicAppOrLib, new Object[0]);
            return;
        }
        vector = FileUtils.listAllFilesInFolder(this.folder, ".cap");
        for (File file : vector) {
            mandatoryCAPComponentsForModule.removeElement(file.getName().toLowerCase());
        }
        if (mandatoryCAPComponentsForModule.size() != 0) {
            this.addError(ErrorKey.missingCAPComponent, new Object[0]);
        }
        try {
            File file = File.createTempFile("abc", null);
            ZipUtils.zip(this.folder, file, false);
            FileInputStream fileInputStream = new FileInputStream(file);
            Verifier.verifyCap(fileInputStream, null, this.exportFiles);
        }
        catch (Exception exception) {
            this.addError(ErrorKey.VerifierError, exception.getMessage());
        }
        this.appletXML.process();
    }

    public AppletXML getAppletXML() {
        return this.appletXML;
    }

    public void setExportFiles(Vector<File> vector) {
        this.exportFiles = vector;
    }
}

