/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.util.Diagnostics;
import com.sun.javacard.util.FileUtils;
import com.sun.javacard.validator.Bundle;
import com.sun.javacard.validator.ClassicLibrary;
import com.sun.javacard.validator.ClassicModule;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.ExtendedModule;
import com.sun.javacard.validator.ExtensionLibrary;
import com.sun.javacard.validator.PackageItem;
import com.sun.javacard.validator.WebModule;
import java.io.File;
import java.util.Vector;

public class Validator {
    private static File workDir = null;
    public static final int TYPE_WEB_APP = 10;
    public static final int TYPE_EXTENDED_APPLET_APP = 11;
    public static final int TYPE_CLASSIC_APPLET_APP = 12;
    public static final int TYPE_EXTENSION_LIBRARY = 1;
    public static final int TYPE_CLASSIC_LIBRARY = 0;
    private int moduleType;
    private Bundle bundle;
    private static Vector<File> exportFiles;

    public Diagnostics validate(String string, int n, File file) {
        Object object;
        if (!new File(string).isDirectory() && file == null) {
            this.createWorkDir();
        } else {
            workDir = file;
        }
        this.moduleType = n;
        this.bundle = new Bundle();
        switch (n) {
            case 10: {
                this.bundle.addItem(new WebModule(string));
                break;
            }
            case 11: {
                this.bundle.addItem(new ExtendedModule(string));
                break;
            }
            case 12: {
                object = new ClassicModule(string);
                ((ClassicModule)object).setExportFiles(exportFiles);
                this.bundle.addItem((PackageItem)object);
                break;
            }
            case 1: {
                this.bundle.addItem(new ExtensionLibrary(string));
                break;
            }
            case 0: {
                ClassicLibrary classicLibrary = new ClassicLibrary(string);
                classicLibrary.setExportFiles(exportFiles);
                this.bundle.addItem(classicLibrary);
            }
        }
        this.bundle.initialize();
        this.bundle.process();
        object = new Diagnostics();
        ((Diagnostics)object).ok = this.bundle.isOk(true);
        this.bundle.gatherDiagnostics((Diagnostics)object);
        if (workDir != null) {
            FileUtils.deleteDir(workDir);
        }
        return object;
    }

    public static File getWorkDir() {
        return workDir;
    }

    public int getModuleType() {
        return this.moduleType;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setExportFiles(Vector<File> vector) {
        exportFiles = vector;
    }

    private void createWorkDir() {
        workDir = new File(System.getProperty("java.io.tmpdir") + "packager_temp_root_" + System.currentTimeMillis()).getAbsoluteFile();
        if (!workDir.mkdirs()) {
            System.out.println(ErrorKey.UnableToCreateWorkingFolder.getMessage(workDir));
            System.exit(1);
        }
    }
}

