/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.analysis.api;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.cnd.analysis.api.AbstractHintsPanel;
import org.netbeans.modules.cnd.analysis.api.AnalyzerRequest;
import org.netbeans.modules.cnd.analysis.api.AnalyzerResponse;
import org.netbeans.modules.cnd.analysis.api.options.HintsPanel;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmCompilationUnit;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAuditProvider;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public abstract class AbstractAnalyzer
implements Analyzer {
    private final Analyzer.Context ctx;
    private final AtomicBoolean cancel = new AtomicBoolean(false);
    private Thread processingThread;
    private final AtomicInteger count = new AtomicInteger(0);
    private int total;

    protected AbstractAnalyzer(Analyzer.Context ctx) {
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends ErrorDescription> analyze() {
        WorkSet set = new WorkSet();
        HashSet<String> antiLoop = new HashSet<String>();
        for (FileObject sr : this.ctx.getScope().getSourceRoots()) {
            this.doDryRun(sr, set, antiLoop);
        }
        for (NonRecursiveFolder nrf : this.ctx.getScope().getFolders()) {
            this.doDryRun(nrf, set);
        }
        for (FileObject file : this.ctx.getScope().getFiles()) {
            this.doDryRun(file, set, antiLoop);
        }
        set.processHeaders(this.cancel, this.isCompileUnitBased());
        this.total = set.compileUnits.size();
        this.ctx.start(this.total);
        ArrayList<? extends ErrorDescription> result = new ArrayList<ErrorDescription>();
        try {
            CsmErrorProvider errorProvider = this.getErrorProvider(this.ctx.getSettings());
            for (NativeFileItem item : set.compileUnits) {
                if (this.cancel.get()) {
                    break;
                }
                if (this.count.incrementAndGet() < this.total) {
                    this.ctx.progress(this.count.get());
                }
                try {
                    result.addAll(this.doRunImpl(item.getFileObject(), this.ctx, errorProvider, this.cancel));
                }
                catch (Throwable ex) {
                    CndUtils.printStackTraceOnce((Throwable)ex);
                }
            }
        }
        finally {
            this.ctx.finish();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        this.cancel.set(true);
        AbstractAnalyzer abstractAnalyzer = this;
        synchronized (abstractAnalyzer) {
            if (this.processingThread != null) {
                this.processingThread.interrupt();
            }
        }
        return false;
    }

    private void doDryRun(NonRecursiveFolder nrf, WorkSet set) {
        FileObject sr = nrf.getFolder();
        for (FileObject fo : sr.getChildren()) {
            if (this.cancel.get()) break;
            if (!fo.isData()) continue;
            set.add(fo);
        }
    }

    private void doDryRun(FileObject sr, WorkSet set, Set<String> antiLoop) {
        block6: {
            if (sr.isData()) {
                set.add(sr);
            } else {
                try {
                    String canonicalPath = FileSystemProvider.getCanonicalPath((FileObject)sr);
                    if (antiLoop.contains(canonicalPath)) break block6;
                    antiLoop.add(canonicalPath);
                    for (FileObject fo : sr.getChildren()) {
                        if (!this.cancel.get()) {
                            this.doDryRun(fo, set, antiLoop);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    protected abstract boolean isCompileUnitBased();

    protected abstract CsmErrorProvider getErrorProvider(Preferences var1);

    protected abstract Collection<? extends ErrorDescription> doRunImpl(FileObject var1, Analyzer.Context var2, CsmErrorProvider var3, AtomicBoolean var4);

    protected static AbstractHintsPanel createComponent(CodeAuditProvider provider) {
        return new HintsPanel(null, provider, provider.getMimeType());
    }

    private static class WorkSet {
        LinkedHashSet<NativeFileItem> compileUnits = new LinkedHashSet();
        LinkedHashSet<FileObject> headers = new LinkedHashSet();

        private WorkSet() {
        }

        void add(FileObject fo) {
            String mimeType = fo.getMIMEType();
            if (MIMENames.isCppOrC((String)mimeType)) {
                NativeFileItem item;
                NativeProject np;
                Project project = FileOwnerQuery.getOwner((FileObject)fo);
                if (project != null && (np = (NativeProject)project.getLookup().lookup(NativeProject.class)) != null && (item = np.findFileItem(fo)) != null && !item.isExcluded()) {
                    this.compileUnits.add(item);
                }
            } else if (MIMENames.isHeader((String)mimeType)) {
                this.headers.add(fo);
            }
        }

        private void processHeaders(AtomicBoolean cancel, boolean isCompileUnitBased) {
            block0: for (FileObject fo : this.headers) {
                if (cancel.get()) break;
                CsmFile csmFile = CsmUtilities.getCsmFile((FileObject)fo, (boolean)false, (boolean)false);
                if (csmFile == null) continue;
                if (isCompileUnitBased) {
                    for (CsmCompilationUnit cu : CsmFileInfoQuery.getDefault().getCompilationUnits(csmFile, 0)) {
                        NativeFileItem findItem;
                        CsmFile startFile = cu.getStartFile();
                        if (startFile == null || (findItem = this.findItem(startFile)) == null) continue;
                        if (this.compileUnits.contains(findItem)) continue block0;
                        this.compileUnits.add(findItem);
                        continue block0;
                    }
                    continue;
                }
                NativeFileItem findItem = this.findItem(csmFile);
                if (findItem == null || this.compileUnits.contains(findItem)) continue;
                this.compileUnits.add(findItem);
            }
            this.headers.clear();
        }

        private NativeFileItem findItem(CsmFile file) {
            Object platformProject = file.getProject().getPlatformProject();
            if (platformProject instanceof NativeProject) {
                return ((NativeProject)platformProject).findFileItem(file.getFileObject());
            }
            return null;
        }
    }

    protected static class LazyFixListImpl
    implements LazyFixList {
        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        public boolean probablyContainsFixes() {
            return false;
        }

        public List<Fix> getFixes() {
            return Collections.emptyList();
        }

        public boolean isComputed() {
            return false;
        }
    }

    protected static abstract class AbstractResponse
    implements CsmErrorProvider.Response,
    AnalyzerResponse {
        private final FileObject sr;
        private final ArrayList<ErrorDescription> res;
        private final AtomicBoolean cancel;

        public AbstractResponse(FileObject sr, ArrayList<ErrorDescription> res, AtomicBoolean cancel) {
            this.sr = sr;
            this.res = res;
            this.cancel = cancel;
        }

        public void addError(CsmErrorInfo errorInfo) {
            ErrorDescription error = this.addErrorImpl(errorInfo, this.sr);
            if (error != null) {
                this.res.add(error);
            }
        }

        @Override
        public void addError(AnalyzerResponse.AnalyzerSeverity severity, String message, FileObject file, CsmErrorInfo errorInfo) {
            switch (severity) {
                case FileError: {
                    break;
                }
                case ProjectError: {
                    this.cancel.set(true);
                    break;
                }
                case ToolError: {
                    this.cancel.set(true);
                    break;
                }
            }
            ErrorDescription error = this.addErrorImpl(errorInfo, file);
            if (error != null) {
                this.res.add(error);
            }
        }

        public void done() {
        }

        protected abstract ErrorDescription addErrorImpl(CsmErrorInfo var1, FileObject var2);
    }

    protected static class RequestImpl
    implements CsmErrorProvider.Request,
    AnalyzerRequest {
        private final CsmFile csmFile;
        private final AtomicBoolean cancel;
        private final Analyzer.Context ctx;

        public RequestImpl(CsmFile csmFile, Analyzer.Context ctx, AtomicBoolean cancel) {
            this.csmFile = csmFile;
            this.cancel = cancel;
            this.ctx = ctx;
        }

        public CsmFile getFile() {
            return this.csmFile;
        }

        public boolean isCancelled() {
            return this.cancel.get();
        }

        public Document getDocument() {
            return null;
        }

        @Override
        public String getSingleAuditId() {
            String singleWarningId = this.ctx.getSingleWarningId();
            if (singleWarningId != null && singleWarningId.indexOf(45) > 0) {
                singleWarningId = singleWarningId.substring(singleWarningId.indexOf(45) + 1);
            }
            return singleWarningId;
        }

        public CsmErrorProvider.EditorEvent getEvent() {
            return CsmErrorProvider.EditorEvent.FileBased;
        }
    }
}

