/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.nbtasks;

import com.sun.javacard.nbtasks.JCToolTask;
import java.io.File;
import java.io.FileFilter;
import org.apache.tools.ant.BuildException;

public class JCConverterTask
extends JCToolTask {
    public JCConverterTask() {
        super("com.sun.javacard.converter.Main");
    }

    public void execute() throws BuildException {
        if (!this.isClassicApplication() && !this.isClassicLibrary()) {
            return;
        }
        String expPath = this.getExportPath();
        expPath = expPath != null && expPath.length() > 0 ? expPath + File.pathSeparator : "";
        this.createArg().setValue("-exportpath");
        File jcHome = this.getFileProp("javacard.home");
        StringBuilder sb = new StringBuilder(jcHome.getAbsolutePath());
        if (!sb.toString().endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append("api_export_files");
        expPath = expPath + sb.toString();
        this.createArg().setValue(expPath);
        File classDir = this.getFileProp("build.classes.dir");
        this.createArg().setValue("-classdir");
        this.createArg().setFile(classDir);
        File destDir = this.getFileProp("dist.dir");
        this.createArg().setValue("-d");
        this.createArg().setFile(destDir);
        this.createArg().setValue("-i");
        this.setAdditionalArguments();
        this.createArg().setValue(this.getPackageName());
        this.createArg().setValue(this.getPackageAID());
        this.createArg().setValue("1.0");
        super.execute();
    }

    protected void setAdditionalArguments() throws BuildException {
    }

    protected String getPackageName() throws BuildException {
        File buildDir = this.getFileProp("build.classes.dir");
        File[] classFiles = null;
        classFiles = JCConverterTask.searchFiles(buildDir, "class");
        if (classFiles == null || classFiles.length == 0) {
            throw new BuildException("No classes found in directory: " + buildDir);
        }
        String packageDir = classFiles[0].getParent();
        packageDir = packageDir.substring(buildDir.getPath().length() + 1);
        return packageDir.replace(File.separatorChar, '.');
    }

    protected String getPackageAID() {
        String aid = this.getProp("package.aid");
        aid = aid.substring("//aid/".length());
        aid = aid.replaceAll("/", "");
        String packageAID = "";
        char[] aidChars = aid.toCharArray();
        char[] buf = new char[2];
        int index = 0;
        while (index < aidChars.length) {
            buf[0] = aidChars[index++];
            buf[1] = aidChars[index++];
            packageAID = packageAID + "0x" + new String(buf) + ":";
        }
        return packageAID.substring(0, packageAID.length() - 1);
    }

    static File[] searchFiles(File parent, final String ext) {
        if (parent.isDirectory()) {
            File[] files = parent.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith("." + ext);
                }
            });
            if (files == null || files.length == 0) {
                File child;
                File[] arr$ = parent.listFiles();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && ((files = JCConverterTask.searchFiles(child = arr$[i$], ext)) == null || files.length == 0); ++i$) {
                }
            }
            return files;
        }
        return null;
    }
}

