/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.values.FunctionSubEvent;

class FunctionBreakpointPanel
extends BreakpointPanel {
    private FunctionBreakpoint fb;
    private JLabel functionLabel;
    private JTextField functionText;
    private ButtonGroup buttonGroup1;
    private JRadioButton functionToggle;
    private JRadioButton functionsToggle;
    private JRadioButton returnToggle;

    @Override
    public void seed(NativeBreakpoint breakpoint) {
        FunctionSubEvent fbe;
        this.seedCommonComponents(breakpoint);
        this.fb = (FunctionBreakpoint)breakpoint;
        String function = this.fb.getFunction();
        if (function != null) {
            this.functionText.setText(function);
        }
        if ((fbe = this.fb.getSubEvent()) == FunctionSubEvent.IN) {
            this.functionToggle.setSelected(true);
        } else if (fbe == FunctionSubEvent.INFUNCTION) {
            this.functionsToggle.setSelected(true);
        } else if (fbe == FunctionSubEvent.RETURNS) {
            this.returnToggle.setSelected(true);
        }
    }

    public FunctionBreakpointPanel() {
        this(new FunctionBreakpoint(2), false);
    }

    public FunctionBreakpointPanel(NativeBreakpoint b) {
        this((FunctionBreakpoint)b, true);
    }

    private FunctionBreakpointPanel(FunctionBreakpoint breakpoint, boolean customizing) {
        super(breakpoint, customizing);
        String selection;
        this.fb = breakpoint;
        this.initComponents();
        this.initA11y();
        this.addCommonComponents(4);
        if (!customizing && (selection = EditorBridge.getCurrentSelection()) != null) {
            breakpoint.setFunction(selection);
        }
        this.seed(breakpoint);
        this.functionText.getDocument().addDocumentListener(this);
    }

    @Override
    public void setDescriptionEnabled(boolean enabled) {
        this.functionText.setEnabled(false);
        this.functionToggle.setEnabled(false);
        this.functionsToggle.setEnabled(false);
        this.returnToggle.setEnabled(false);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.functionLabel = new JLabel();
        this.functionText = new JTextField();
        this.functionToggle = new JRadioButton();
        this.functionsToggle = new JRadioButton();
        this.returnToggle = new JRadioButton();
        this.panel_settings.setLayout(new GridBagLayout());
        this.functionLabel.setText(Catalog.get("Function"));
        this.functionLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_Function"));
        this.functionLabel.setLabelFor(this.functionText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 17;
        this.panel_settings.add((Component)this.functionLabel, gridBagConstraints);
        this.functionText.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panel_settings.add((Component)this.functionText, gridBagConstraints);
        this.functionToggle.setMnemonic(Catalog.getMnemonic("MNEM_Func"));
        this.functionToggle.setText(FunctionSubEvent.IN.toString());
        this.functionToggle.setSelected(true);
        this.buttonGroup1.add(this.functionToggle);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.panel_settings.add((Component)this.functionToggle, gridBagConstraints);
        this.functionsToggle.setMnemonic(Catalog.getMnemonic("MNEM_AllFuncs"));
        this.functionsToggle.setText(FunctionSubEvent.INFUNCTION.toString());
        this.buttonGroup1.add(this.functionsToggle);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.panel_settings.add((Component)this.functionsToggle, gridBagConstraints);
        this.returnToggle.setMnemonic(Catalog.getMnemonic("MNEM_OnReturn"));
        this.returnToggle.setText(FunctionSubEvent.RETURNS.toString());
        this.buttonGroup1.add(this.returnToggle);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.panel_settings.add((Component)this.returnToggle, gridBagConstraints);
    }

    private void initA11y() {
        this.functionToggle.getAccessibleContext().setAccessibleDescription(this.functionToggle.getText());
        this.functionsToggle.getAccessibleContext().setAccessibleDescription(this.functionsToggle.getText());
        this.returnToggle.getAccessibleContext().setAccessibleDescription(this.returnToggle.getText());
        Catalog.setAccessibleDescription(this.functionText, "ACSD_Function");
    }

    @Override
    protected void assignProperties() {
        FunctionSubEvent fbe = null;
        if (this.functionToggle.isSelected()) {
            fbe = FunctionSubEvent.IN;
        } else if (this.functionsToggle.isSelected()) {
            fbe = FunctionSubEvent.INFUNCTION;
        } else if (this.returnToggle.isSelected()) {
            fbe = FunctionSubEvent.RETURNS;
        }
        String ff = this.functionText.getText();
        if (ff != null && !ff.equals(this.fb.getFunction())) {
            this.fb.setFunction(ff);
            this.fb.setQfunction(ff);
        }
        if (!this.fb.getSubEvent().equals(fbe)) {
            this.fb.setSubEvent(fbe);
        }
    }

    @Override
    protected boolean propertiesAreValid() {
        String text = this.functionText.getText();
        return !IpeUtils.isEmpty(text);
    }
}

