/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.SmallButton;
import org.netbeans.modules.profiler.api.icons.Icons;

public class PopupButton
extends SmallButton {
    private static final Icon DROPDOWN_ICON = Icons.getIcon((String)"GeneralIcons.PopupArrow");
    private static final int DROPDOWN_ICON_WIDTH = DROPDOWN_ICON.getIconWidth();
    private static final int DROPDOWN_ICON_HEIGHT = DROPDOWN_ICON.getIconHeight();
    private int iconOffset = UIUtils.isMetalLookAndFeel() ? 6 : (UIUtils.isNimbusLookAndFeel() ? 8 : 7);
    private int popupAlign = 10;

    public PopupButton() {
        this.setHorizontalAlignment(10);
    }

    public PopupButton(Icon icon) {
        super(icon);
        this.setHorizontalAlignment(10);
    }

    public PopupButton(String text) {
        super(text);
        this.setHorizontalAlignment(10);
    }

    public PopupButton(Action a) {
        super(a);
        this.setHorizontalAlignment(10);
    }

    public PopupButton(String text, Icon icon) {
        super(text, icon);
        this.setHorizontalAlignment(10);
    }

    public void setPopupAlign(int align) {
        this.popupAlign = align;
    }

    public int getPopupAlign() {
        return this.popupAlign;
    }

    @Override
    protected void fireActionPerformed(ActionEvent e) {
        super.fireActionPerformed(e);
        this.displayPopup();
    }

    protected void displayPopup() {
        JPopupMenu menu = new JPopupMenu();
        this.populatePopup(menu);
        if (menu.getComponentCount() > 0) {
            Dimension size = menu.getPreferredSize();
            size.width = Math.max(size.width, this.getWidth());
            menu.setPreferredSize(size);
            int align = this.getPopupAlign();
            int x = align == 11 || align == 4 ? this.getWidth() - size.width : 0;
            menu.show(this, x, this.getHeight());
        }
    }

    protected void populatePopup(JPopupMenu popup) {
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width = size.width + (DROPDOWN_ICON_WIDTH + (this.isEmpty() ? 3 : 5));
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (UIUtils.isWindowsLookAndFeel() && this.getParent() instanceof JToolBar) {
            if (this.getIcon() == NO_ICON) {
                this.setIconTextGap(2);
            }
            this.iconOffset = 5;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isEmpty()) {
            DROPDOWN_ICON.paintIcon(this, g, (this.getWidth() - DROPDOWN_ICON_WIDTH) / 2, (this.getHeight() - DROPDOWN_ICON_HEIGHT) / 2);
        } else {
            DROPDOWN_ICON.paintIcon(this, g, this.getWidth() - DROPDOWN_ICON_WIDTH - this.iconOffset, (this.getHeight() - DROPDOWN_ICON_HEIGHT) / 2);
        }
    }

    private boolean isEmpty() {
        if (this.getIcon() != NO_ICON) {
            return false;
        }
        String text = this.getText();
        return text == null || text.isEmpty();
    }
}

