/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cnd.makefile.wizard.CompilerFlags;
import org.netbeans.modules.cnd.makefile.wizard.MakefileData;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizard;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.utils.ui.CndUIUtilities;

public final class CompilerOptionsPanel
extends MakefileWizardPanel
implements FocusListener {
    static final long serialVersionUID = 5260017369797781413L;
    private JTextArea topLabel;
    private JTextField cText;
    private JTextField cppText;
    private JTextField fortranText;
    private JTextField basicText;
    private CompilerFlags copts;
    private JLabel cppCompilerLabel;
    private JComboBox cConformLevelCB;
    private ActionListener cConformLevelCBActionListener;
    private JComboBox cppConformLevelCB;
    private ActionListener cppConformLevelCBActionListener;
    private boolean initialized;

    public CompilerOptionsPanel(MakefileWizard wd) {
        super(wd);
        String subtitle = this.getString("LBL_CompilerOptionsPanel");
        this.setSubTitle(subtitle);
        this.getAccessibleContext().setAccessibleDescription(subtitle);
        this.initialized = false;
    }

    protected void create() {
        int gridy = 0;
        this.setLayout(new GridBagLayout());
        GridBagConstraints grid = new GridBagConstraints();
        grid.anchor = 18;
        grid.gridx = 0;
        this.topLabel = new JTextArea(this.getString("LBL_COptsTopLabel"));
        this.topLabel.addFocusListener(this);
        this.topLabel.setEditable(false);
        this.topLabel.setFocusable(false);
        this.topLabel.setBackground(new JPanel().getBackground());
        grid.gridy = gridy++;
        grid.fill = 2;
        grid.gridwidth = 0;
        grid.weightx = 1.0;
        this.add((Component)this.topLabel, grid);
        grid.insets.top = 5;
        JLabel cLabel = new JLabel(this.getString("LBL_COptsCCompiler"));
        cLabel.setDisplayedMnemonic(this.getString("MNEM_COptsCCompiler").charAt(0));
        grid.gridx = 0;
        grid.gridy = gridy++;
        grid.fill = 0;
        grid.gridwidth = 1;
        grid.insets.right = 11;
        grid.insets.top = 11;
        grid.weightx = 0.0;
        this.add((Component)cLabel, grid);
        this.cText = new JTextField();
        this.cText.addFocusListener(this);
        cLabel.setLabelFor(this.cText);
        grid.gridx = 1;
        grid.fill = 2;
        grid.gridwidth = 0;
        grid.insets.right = 0;
        this.add((Component)this.cText, grid);
        JLabel cCompilerLabel = new JLabel();
        cCompilerLabel.setText(this.getString("LBL_ConformLevel"));
        cCompilerLabel.setDisplayedMnemonic(this.getString("MNEM_ConformLevel1").charAt(0));
        grid.gridx = 1;
        grid.gridy = ++gridy;
        grid.gridwidth = 1;
        grid.fill = 0;
        grid.insets = new Insets(8, 0, 0, 0);
        grid.anchor = 18;
        this.add((Component)cCompilerLabel, grid);
        this.cConformLevelCB = new JComboBox();
        cCompilerLabel.setLabelFor(this.cConformLevelCB);
        grid.gridx = 2;
        grid.gridy = gridy++;
        grid.gridwidth = 1;
        grid.fill = 0;
        grid.insets = new Insets(5, 5, 0, 0);
        grid.anchor = 18;
        this.add((Component)this.cConformLevelCB, grid);
        JLabel cppLabel = new JLabel(this.getString("LBL_COptsCppCompiler"));
        cppLabel.setDisplayedMnemonic(this.getString("MNEM_COptsCppCompiler").charAt(0));
        grid.gridx = 0;
        grid.gridy = gridy++;
        grid.fill = 0;
        grid.gridwidth = 1;
        grid.insets = new Insets(0, 0, 0, 0);
        grid.insets.right = 11;
        grid.insets.top = 11;
        grid.weightx = 0.0;
        this.add((Component)cppLabel, grid);
        this.cppText = new JTextField();
        this.cppText.addFocusListener(this);
        cppLabel.setLabelFor(this.cppText);
        grid.gridx = 1;
        grid.fill = 2;
        grid.gridwidth = 0;
        grid.insets.right = 0;
        this.add((Component)this.cppText, grid);
        this.cppCompilerLabel = new JLabel();
        grid.gridx = 1;
        grid.gridy = ++gridy;
        grid.gridwidth = 1;
        grid.fill = 0;
        grid.insets = new Insets(8, 0, 0, 0);
        grid.anchor = 18;
        this.add((Component)this.cppCompilerLabel, grid);
        this.cppConformLevelCB = new JComboBox();
        this.cppCompilerLabel.setLabelFor(this.cppConformLevelCB);
        grid.gridx = 2;
        grid.gridy = gridy++;
        grid.gridwidth = 1;
        grid.fill = 0;
        grid.insets = new Insets(5, 5, 0, 0);
        grid.anchor = 18;
        this.add((Component)this.cppConformLevelCB, grid);
        JLabel fortranLabel = new JLabel(this.getString("LBL_COptsFortranCompiler"));
        fortranLabel.setDisplayedMnemonic(this.getString("MNEM_COptsFortranCompiler").charAt(0));
        grid.gridx = 0;
        grid.gridy = gridy++;
        grid.fill = 0;
        grid.gridwidth = 1;
        grid.insets = new Insets(0, 0, 0, 0);
        grid.insets.right = 11;
        grid.insets.top = 11;
        grid.weightx = 0.0;
        this.add((Component)fortranLabel, grid);
        this.fortranText = new JTextField();
        this.fortranText.addFocusListener(this);
        fortranLabel.setLabelFor(this.fortranText);
        grid.gridx = 1;
        grid.fill = 2;
        grid.gridwidth = 0;
        grid.insets.right = 0;
        this.add((Component)this.fortranText, grid);
        JLabel basicLabel = new JLabel(this.getString("LBL_BasicOptionsVar"));
        grid.gridx = 0;
        grid.gridy = gridy++;
        grid.fill = 0;
        grid.gridwidth = 1;
        grid.insets.right = 11;
        grid.weightx = 0.0;
        this.add((Component)basicLabel, grid);
        this.basicText = new JTextField();
        this.basicText.addFocusListener(this);
        this.basicText.setEditable(false);
        this.basicText.setFocusable(false);
        this.basicText.setBackground(basicLabel.getBackground());
        basicLabel.setLabelFor(this.basicText);
        grid.gridwidth = 0;
        grid.gridx = 1;
        grid.fill = 2;
        grid.gridwidth = 0;
        grid.insets.right = 0;
        grid.weightx = 1.0;
        grid.weighty = 1.0;
        this.add((Component)this.basicText, grid);
        grid.gridy = gridy++;
        grid.gridheight = 0;
        this.add((Component)new JLabel(""), grid);
        this.topLabel.setBackground(cLabel.getBackground());
        this.cConformLevelCBActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompilerOptionsPanel.this.cConformLevelCBActionPerformed(evt);
            }
        };
        this.cConformLevelCB.addActionListener(this.cConformLevelCBActionListener);
        this.cText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CompilerOptionsPanel.this.cTextKeyReleased(evt);
            }
        });
        this.cppConformLevelCBActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompilerOptionsPanel.this.cppConformLevelCBActionPerformed(evt);
            }
        };
        this.cppConformLevelCB.addActionListener(this.cppConformLevelCBActionListener);
        this.cppText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CompilerOptionsPanel.this.cppTextKeyReleased(evt);
            }
        });
    }

    @Override
    public void addNotify() {
        if (!this.initialized) {
            this.initialized = true;
            this.create();
            this.copts = this.getMakefileData().getCompilerFlags();
        }
        super.addNotify();
        this.cText.setText(this.copts.getCFlags(this.getMakefileData().getToolset()));
        this.cppText.setText(this.copts.getCcFlags(this.getMakefileData().getToolset()));
        this.fortranText.setText(this.copts.getF90Flags());
        this.basicText.setText(this.copts.getBasicOptions(this.getMakefileData().getToolset()));
        this.cText.selectAll();
        CndUIUtilities.requestFocus((Component)this.cText);
        this.cConformLevelCB.removeActionListener(this.cConformLevelCBActionListener);
        this.cppConformLevelCB.removeActionListener(this.cppConformLevelCBActionListener);
        this.cConformLevelCB.removeAllItems();
        this.cppConformLevelCB.removeAllItems();
        if (this.getMakefileData().getToolset() == 0) {
            this.cConformLevelCB.addItem(this.getString("CSunConform0"));
            this.cConformLevelCB.addItem(this.getString("CSunConform1"));
            this.cConformLevelCB.addItem(this.getString("CSunConform2"));
            this.cConformLevelCB.setSelectedIndex(this.getMakefileData().getConformLevelCSun());
            this.cppCompilerLabel.setText(this.getString("LBL_Compatibility"));
            this.cppCompilerLabel.setDisplayedMnemonic(this.getString("MNEM_Compatibility").charAt(0));
            this.cppConformLevelCB.addItem(this.getString("CppSunConform0"));
            this.cppConformLevelCB.addItem(this.getString("CppSunConform1"));
            this.cppConformLevelCB.setSelectedIndex(this.getMakefileData().getConformLevelCppSun());
        } else {
            this.cConformLevelCB.addItem(this.getString("CGNUConform0"));
            this.cConformLevelCB.addItem(this.getString("CGNUConform1"));
            this.cConformLevelCB.setSelectedIndex(this.getMakefileData().getConformLevelCGNU());
            this.cppCompilerLabel.setText(this.getString("LBL_ConformLevel"));
            this.cppCompilerLabel.setDisplayedMnemonic(this.getString("MNEM_ConformLevel2").charAt(0));
            this.cppConformLevelCB.addItem(this.getString("CppGNUConform0"));
            this.cppConformLevelCB.addItem(this.getString("CppGNUConform1"));
            this.cppConformLevelCB.setSelectedIndex(this.getMakefileData().getConformLevelCppGNU());
        }
        this.cConformLevelCB.addActionListener(this.cConformLevelCBActionListener);
        this.cppConformLevelCB.addActionListener(this.cppConformLevelCBActionListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.copts.setCFlags(this.getMakefileData().getToolset(), this.cText.getText());
        this.copts.setCcFlags(this.getMakefileData().getToolset(), this.cppText.getText());
        this.copts.setF90Flags(this.fortranText.getText());
        if (this.getMakefileData().getToolset() == 0) {
            this.getMakefileData().setConformLevelCSun(this.cConformLevelCB.getSelectedIndex());
            this.getMakefileData().setConformLevelCppSun(this.cppConformLevelCB.getSelectedIndex());
        } else {
            this.getMakefileData().setConformLevelCGNU(this.cConformLevelCB.getSelectedIndex());
            this.getMakefileData().setConformLevelCppGNU(this.cppConformLevelCB.getSelectedIndex());
        }
    }

    @Override
    public void focusGained(FocusEvent evt) {
        if (evt.getComponent() == this.basicText || evt.getComponent() == this.topLabel) {
            ((JTextComponent)evt.getComponent()).selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        ((JTextComponent)evt.getComponent()).setSelectionEnd(0);
    }

    private void cConformLevelCBActionPerformed(ActionEvent evt) {
        String[] levels = this.getMakefileData().getToolset() == 0 ? MakefileData.conformLevelsCSun : MakefileData.conformLevelsCGNU;
        int i = this.cConformLevelCB.getSelectedIndex();
        String newTxt = this.removeOptions(this.cText.getText(), levels);
        newTxt = this.addOption(newTxt, levels[i]);
        this.cText.setText(newTxt);
    }

    private void cppConformLevelCBActionPerformed(ActionEvent evt) {
        String[] levels = this.getMakefileData().getToolset() == 0 ? MakefileData.conformLevelsCppSun : MakefileData.conformLevelsCppGNU;
        int i = this.cppConformLevelCB.getSelectedIndex();
        String newTxt = this.removeOptions(this.cppText.getText(), levels);
        newTxt = this.addOption(newTxt, levels[i]);
        this.cppText.setText(newTxt);
    }

    private void cTextKeyReleased(KeyEvent evt) {
        String txt = this.cText.getText();
        String[] levels = this.getMakefileData().getToolset() == 0 ? MakefileData.conformLevelsCSun : MakefileData.conformLevelsCGNU;
        int def = 0;
        boolean foundOne = false;
        this.cConformLevelCB.removeActionListener(this.cConformLevelCBActionListener);
        for (int i = 0; i < levels.length; ++i) {
            if (levels[i].length() == 0) {
                def = i;
                continue;
            }
            if (this.containsOption(txt, levels[i]) < 0) continue;
            this.cConformLevelCB.setSelectedIndex(i);
            foundOne = true;
            break;
        }
        if (!foundOne) {
            this.cConformLevelCB.setSelectedIndex(def);
        }
        this.cConformLevelCB.addActionListener(this.cConformLevelCBActionListener);
    }

    private void cppTextKeyReleased(KeyEvent evt) {
        String txt = this.cppText.getText();
        String[] levels = this.getMakefileData().getToolset() == 0 ? MakefileData.conformLevelsCppSun : MakefileData.conformLevelsCppGNU;
        int def = 0;
        boolean foundOne = false;
        this.cppConformLevelCB.removeActionListener(this.cppConformLevelCBActionListener);
        for (int i = 0; i < levels.length; ++i) {
            if (levels[i].length() == 0) {
                def = i;
                continue;
            }
            if (this.containsOption(txt, levels[i]) < 0) continue;
            this.cppConformLevelCB.setSelectedIndex(i);
            foundOne = true;
            break;
        }
        if (!foundOne) {
            this.cppConformLevelCB.setSelectedIndex(def);
        }
        this.cppConformLevelCB.addActionListener(this.cppConformLevelCBActionListener);
    }

    private int containsOption(String txt, String option) {
        int start = 0;
        int lTxt = txt.length();
        int lOpt = option.length();
        while (start <= lTxt - lOpt) {
            int i = txt.indexOf(option, start);
            if (i < 0) {
                return -1;
            }
            if (i > 0 && !Character.isWhitespace(txt.charAt(i - 1))) {
                start = i + 1;
                continue;
            }
            if (i < lTxt - lOpt && !Character.isWhitespace(txt.charAt(i + lOpt))) {
                start = i + 1;
                continue;
            }
            return i;
        }
        return -1;
    }

    private String removeOptions(String txt, String[] options) {
        String newTxt = txt;
        for (int i = 0; i < options.length; ++i) {
            newTxt = this.removeOption(newTxt, options[i]);
        }
        return newTxt;
    }

    private String removeOption(String txt, String option) {
        if (option == null || option.length() == 0) {
            return txt;
        }
        int i = this.containsOption(txt, option);
        if (i < 0) {
            return txt;
        }
        String newTxt = i == 0 ? txt.substring(i + option.length()) : txt.substring(0, i - 1) + txt.substring(i + option.length());
        return newTxt;
    }

    private String addOption(String txt, String option) {
        String white = "";
        int i = this.containsOption(txt, option);
        if (i >= 0) {
            return txt;
        }
        if (txt.length() > 0 && !Character.isWhitespace(txt.charAt(txt.length() - 1))) {
            white = " ";
        }
        String newTxt = txt + white + option;
        return newTxt;
    }
}

