/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.toolchain;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.spi.toolchain.CSMInitializationTaskRunner;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetManagerImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.SPIAccessor;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;

public final class CompilerSetManagerEvents {
    private static final Map<ExecutionEnvironment, CompilerSetManagerEvents> map;
    private final ExecutionEnvironment executionEnvironment;
    private boolean isCodeModelInfoReady;
    private final CSMInitializationTaskRunner taskRunner;

    public static synchronized CompilerSetManagerEvents get(ExecutionEnvironment env) {
        CompilerSetManagerEvents instance = map.get(env);
        if (instance == null) {
            instance = new CompilerSetManagerEvents(env);
            map.put(env, instance);
        }
        return instance;
    }

    public void runProjectReadiness(NamedRunnable task) {
        this.taskRunner.runTask(this.executionEnvironment, this.isCodeModelInfoReady, task);
    }

    private CompilerSetManagerEvents(ExecutionEnvironment env) {
        this.executionEnvironment = env;
        this.isCodeModelInfoReady = CompilerSetManager.get(this.executionEnvironment).isComplete();
        this.taskRunner = CSMInitializationTaskRunner.getInstance();
    }

    private void runTasks() {
        this.isCodeModelInfoReady = true;
        this.taskRunner.runTasks();
    }

    static {
        SPIAccessor.register(new SPIAccessorImpl());
        map = new HashMap<ExecutionEnvironment, CompilerSetManagerEvents>();
    }

    private static final class SPIAccessorImpl
    extends SPIAccessor {
        private SPIAccessorImpl() {
        }

        @Override
        public void runTasks(CompilerSetManagerEvents event) {
            event.runTasks();
        }

        @Override
        public CompilerSetManagerEvents createEvent(ExecutionEnvironment env) {
            return new CompilerSetManagerEvents(env);
        }

        @Override
        public void add(ExecutionEnvironment env, CompilerSet cs) {
            ((CompilerSetManagerImpl)CompilerSetManagerImpl.get(env)).add(cs);
        }

        @Override
        public void remove(ExecutionEnvironment env, CompilerSet cs) {
            ((CompilerSetManagerImpl)CompilerSetManagerImpl.get(env)).remove(cs);
        }
    }
}

