/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sync;

import java.util.LinkedList;
import javax.swing.Icon;
import org.netbeans.modules.php.project.connections.TmpLocalFile;
import org.netbeans.modules.php.project.connections.sync.Bundle;
import org.netbeans.modules.php.project.connections.sync.SyncItems;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.openide.util.ImageUtilities;

public final class SyncItem {
    static final String NOOP_ICON_PATH = "org/netbeans/modules/php/project/ui/resources/noop.png";
    static final String DOWNLOAD_ICON_PATH = "org/netbeans/modules/php/project/ui/resources/download.png";
    static final String DOWNLOAD_MIRRORED_ICON_PATH = "org/netbeans/modules/php/project/ui/resources/download_mirrored.png";
    static final String UPLOAD_ICON_PATH = "org/netbeans/modules/php/project/ui/resources/upload.png";
    static final String UPLOAD_MIRRORED_ICON_PATH = "org/netbeans/modules/php/project/ui/resources/upload_mirrored.png";
    static final String DELETE_ICON_PATH = "org/netbeans/modules/php/project/ui/resources/delete.png";
    static final String SYMLINK_ICON_PATH = "org/netbeans/modules/php/project/ui/resources/symlink.png";
    static final String FILE_DIR_COLLISION_ICON_PATH = "org/netbeans/modules/php/project/ui/resources/file-dir-collision.png";
    static final String FILE_CONFLICT_ICON_PATH = "org/netbeans/modules/php/project/ui/resources/file-conflict.png";
    private final SyncItems syncItems;
    private final TransferFile remoteTransferFile;
    private final TransferFile localTransferFile;
    private final Operation defaultOperation;
    private final boolean hasLastTimestamp;
    private volatile Operation operation;
    private volatile TmpLocalFile tmpLocalFile = null;

    SyncItem(SyncItems syncItems, TransferFile remoteTransferFile, TransferFile localTransferFile, long lastTimestamp) {
        assert (syncItems != null);
        assert (remoteTransferFile != null || localTransferFile != null);
        this.syncItems = syncItems;
        this.remoteTransferFile = remoteTransferFile;
        this.localTransferFile = localTransferFile;
        this.defaultOperation = this.calculateDefaultOperation(lastTimestamp);
        this.hasLastTimestamp = lastTimestamp != -1L;
    }

    public String getName() {
        if (this.remoteTransferFile != null) {
            return this.remoteTransferFile.getName();
        }
        return this.localTransferFile.getName();
    }

    public String getPath() {
        if (this.remoteTransferFile != null) {
            return this.remoteTransferFile.getRemotePath();
        }
        return this.localTransferFile.getRemotePath();
    }

    public long getSize() {
        if (this.remoteTransferFile != null) {
            return this.remoteTransferFile.getSize();
        }
        return this.localTransferFile.getSize();
    }

    public String getRemotePath() {
        if (this.remoteTransferFile == null) {
            return null;
        }
        return this.remoteTransferFile.getRemotePath();
    }

    public String getLocalPath() {
        if (this.localTransferFile == null) {
            return null;
        }
        return this.localTransferFile.getLocalPath();
    }

    public TransferFile getRemoteTransferFile() {
        return this.remoteTransferFile;
    }

    public TransferFile getLocalTransferFile() {
        return this.localTransferFile;
    }

    public Operation getOperation() {
        if (this.operation != null) {
            return this.operation;
        }
        return this.defaultOperation;
    }

    public void setOperation(Operation operation) {
        assert (operation != null);
        this.operation = operation;
    }

    public void resetOperation() {
        this.cleanupTmpLocalFile();
        this.tmpLocalFile = null;
        this.operation = null;
    }

    public boolean hasLastTimestamp() {
        return this.hasLastTimestamp;
    }

    public void cleanupTmpLocalFile() {
        if (this.hasTmpLocalFile()) {
            this.tmpLocalFile.cleanup();
        }
    }

    public ValidationResult validate() {
        Operation op = this.getOperation();
        switch (op) {
            case NOOP: {
                break;
            }
            case FILE_CONFLICT: {
                return new ValidationResult(false, Bundle.SyncItem_error_fileConflict());
            }
            case FILE_DIR_COLLISION: {
                return new ValidationResult(false, Bundle.SyncItem_error_fileDirCollision());
            }
            case SYMLINK: {
                return new ValidationResult(true, Bundle.SyncItem_warn_symlink());
            }
            case DELETE: {
                if (this.localTransferFile != null && !this.verifyChildrenOperation(this.localTransferFile, true, Operation.DELETE)) {
                    return new ValidationResult(false, Bundle.SyncItem_error_childNotDeleted());
                }
                if (this.remoteTransferFile == null || this.verifyChildrenOperation(this.remoteTransferFile, false, Operation.DELETE)) break;
                return new ValidationResult(false, Bundle.SyncItem_error_childNotDeleted());
            }
            case DOWNLOAD: 
            case DOWNLOAD_REVIEW: {
                if (this.remoteTransferFile == null) {
                    return new ValidationResult(false, Bundle.SyncItem_error_cannotDownload());
                }
                if (op != Operation.DOWNLOAD_REVIEW) break;
                return new ValidationResult(true, Bundle.SyncItem_warn_downloadReview());
            }
            case UPLOAD: 
            case UPLOAD_REVIEW: {
                if (this.localTransferFile == null) {
                    return new ValidationResult(false, Bundle.SyncItem_error_cannotUpload());
                }
                if (op != Operation.UPLOAD_REVIEW) break;
                return new ValidationResult(true, Bundle.SyncItem_warn_uploadReview());
            }
            default: {
                throw new IllegalStateException("Unhandled operation: " + (Object)((Object)op));
            }
        }
        return ValidationResult.VALID;
    }

    public boolean isDiffPossible() {
        if (this.remoteTransferFile != null && this.localTransferFile != null) {
            return this.remoteTransferFile.isFile() && this.localTransferFile.isFile();
        }
        if (this.remoteTransferFile != null) {
            return this.remoteTransferFile.isFile();
        }
        return this.localTransferFile.isFile();
    }

    public boolean isOperationChangePossible() {
        return this.getOperation() != Operation.SYMLINK;
    }

    public boolean hasTmpLocalFile() {
        return this.tmpLocalFile != null;
    }

    public TmpLocalFile getTmpLocalFile() {
        return this.tmpLocalFile;
    }

    public void setTmpLocalFile(TmpLocalFile tmpLocalFile) {
        assert (tmpLocalFile != null);
        this.cleanupTmpLocalFile();
        this.tmpLocalFile = tmpLocalFile;
    }

    private Operation calculateDefaultOperation(long lastTimestamp) {
        if (this.remoteTransferFile != null && this.remoteTransferFile.isLink()) {
            return Operation.SYMLINK;
        }
        if (this.localTransferFile != null && this.remoteTransferFile != null) {
            if (this.localTransferFile.isFile() && !this.remoteTransferFile.isFile()) {
                return Operation.FILE_DIR_COLLISION;
            }
            if (this.localTransferFile.isDirectory() && !this.remoteTransferFile.isDirectory()) {
                return Operation.FILE_DIR_COLLISION;
            }
            if (this.localTransferFile.isDirectory() && this.remoteTransferFile.isDirectory()) {
                return Operation.NOOP;
            }
        }
        if (lastTimestamp == -1L) {
            return this.calculateFirstDefaultOperation();
        }
        return this.calculateNewDefaultOperation(lastTimestamp);
    }

    private Operation calculateFirstDefaultOperation() {
        if (this.localTransferFile == null || this.remoteTransferFile == null) {
            if (this.localTransferFile == null) {
                return Operation.DOWNLOAD;
            }
            return Operation.UPLOAD;
        }
        long localTimestamp = this.localTransferFile.getTimestamp();
        RemoteTimestamp remoteTimestamp = new RemoteTimestamp(this.remoteTransferFile.getTimestamp());
        long localSize = this.localTransferFile.getSize();
        long remoteSize = this.remoteTransferFile.getSize();
        if (remoteTimestamp.equalsTo(localTimestamp) && localSize == remoteSize) {
            return Operation.NOOP;
        }
        if (remoteTimestamp.newerThan(localTimestamp)) {
            return Operation.DOWNLOAD_REVIEW;
        }
        return Operation.UPLOAD_REVIEW;
    }

    private Operation calculateNewDefaultOperation(long lastTimestamp) {
        if (this.localTransferFile == null || this.remoteTransferFile == null) {
            if (this.localTransferFile == null) {
                return new RemoteTimestamp(this.remoteTransferFile.getTimestamp()).newerThan(lastTimestamp) ? Operation.DOWNLOAD : Operation.DELETE;
            }
            return this.localTransferFile.getTimestamp() > lastTimestamp ? Operation.UPLOAD : Operation.DELETE;
        }
        long localTimestamp = this.localTransferFile.getTimestamp();
        RemoteTimestamp remoteTimestamp = new RemoteTimestamp(this.remoteTransferFile.getTimestamp());
        long localSize = this.localTransferFile.getSize();
        long remoteSize = this.remoteTransferFile.getSize();
        if (remoteTimestamp.equalsTo(localTimestamp) && localSize == remoteSize) {
            return Operation.NOOP;
        }
        if (localTimestamp <= lastTimestamp && remoteTimestamp.equalsOrOlderThan(lastTimestamp) && localSize == remoteSize) {
            return Operation.NOOP;
        }
        if (localTimestamp > lastTimestamp && remoteTimestamp.newerThan(lastTimestamp)) {
            return Operation.FILE_CONFLICT;
        }
        if (remoteTimestamp.newerThan(localTimestamp)) {
            return Operation.DOWNLOAD;
        }
        return Operation.UPLOAD;
    }

    private boolean verifyChildrenOperation(TransferFile transferFile, boolean localChildren, Operation operation) {
        LinkedList<TransferFile> children = new LinkedList<TransferFile>();
        children.addAll(localChildren ? transferFile.getLocalChildren() : transferFile.getRemoteChildren());
        while (!children.isEmpty()) {
            TransferFile child = (TransferFile)children.pop();
            SyncItem syncItem = this.syncItems.getByRemotePath(child.getRemotePath());
            if (syncItem.getOperation() != operation) {
                return false;
            }
            children.addAll(localChildren ? child.getLocalChildren() : child.getRemoteChildren());
        }
        return true;
    }

    public String toString() {
        return "SyncItem{path: " + (this.localTransferFile != null ? this.localTransferFile.getRemotePath() : this.remoteTransferFile.getRemotePath()) + ", localFile: " + (this.localTransferFile != null) + ", remoteFile: " + (this.remoteTransferFile != null) + ", operation: " + (Object)((Object)this.getOperation()) + ", valid: " + this.validate() + ", tmpLocalFile: " + this.hasTmpLocalFile() + "}";
    }

    public static final class ValidationResult {
        static final ValidationResult VALID = new ValidationResult(true, null);
        private final boolean valid;
        private final String message;

        public ValidationResult(boolean valid, String message) {
            this.valid = valid;
            this.message = message;
        }

        public boolean hasError() {
            return !this.valid;
        }

        public boolean hasWarning() {
            return this.valid && this.message != null;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "ValidationResult{valid=" + this.valid + ", message=" + this.message + '}';
        }
    }

    private static final class RemoteTimestamp {
        private static final long TIMEDIFF_TOLERANCE = 30L;
        private final long remoteTimestamp;

        public RemoteTimestamp(long remoteTimestamp) {
            this.remoteTimestamp = remoteTimestamp;
        }

        public boolean equalsTo(long timestamp) {
            return Math.abs(timestamp - this.remoteTimestamp) < 30L;
        }

        public boolean equalsOrOlderThan(long timestamp) {
            if (this.equalsTo(timestamp)) {
                return true;
            }
            return this.remoteTimestamp <= timestamp;
        }

        public boolean newerThan(long timestamp) {
            if (this.equalsTo(timestamp)) {
                return false;
            }
            return this.remoteTimestamp > timestamp;
        }

        public String toString() {
            return String.valueOf(this.remoteTimestamp);
        }
    }

    public static enum Operation {
        NOOP(Bundle.Operation_noop_titleWithMnemonic(), Bundle.Operation_noop_toolTip(), "org/netbeans/modules/php/project/ui/resources/noop.png", false),
        DOWNLOAD(Bundle.Operation_download_titleWithMnemonic(), Bundle.Operation_download_toolTip(), "org/netbeans/modules/php/project/ui/resources/download.png", "org/netbeans/modules/php/project/ui/resources/download_mirrored.png", true),
        DOWNLOAD_REVIEW(Bundle.Operation_downloadReview_titleWithMnemonic(), "org/netbeans/modules/php/project/ui/resources/download.png", "org/netbeans/modules/php/project/ui/resources/download_mirrored.png", true),
        UPLOAD(Bundle.Operation_upload_titleWithMnemonic(), Bundle.Operation_upload_toolTip(), "org/netbeans/modules/php/project/ui/resources/upload.png", "org/netbeans/modules/php/project/ui/resources/upload_mirrored.png", true),
        UPLOAD_REVIEW(Bundle.Operation_uploadReview_titleWithMnemonic(), "org/netbeans/modules/php/project/ui/resources/upload.png", "org/netbeans/modules/php/project/ui/resources/upload_mirrored.png", true),
        DELETE(Bundle.Operation_delete_titleWithMnemonic(), Bundle.Operation_delete_toolTip(), "org/netbeans/modules/php/project/ui/resources/delete.png", false),
        SYMLINK(Bundle.Operation_symlink_titleWithMnemonic(), "org/netbeans/modules/php/project/ui/resources/symlink.png", false),
        FILE_DIR_COLLISION(Bundle.Operation_fileDirCollision_titleWithMnemonic(), "org/netbeans/modules/php/project/ui/resources/file-dir-collision.png", false),
        FILE_CONFLICT(Bundle.Operation_fileConflict_titleWithMnemonic(), "org/netbeans/modules/php/project/ui/resources/file-conflict.png", false);

        private final String titleWithMnemonic;
        private final String toolTip;
        private final String iconPath;
        private final String mirroredIconPath;
        private final boolean progress;

        private Operation(String titleWithMnemonic, String iconPath, boolean progress) {
            this(titleWithMnemonic, null, iconPath, iconPath, progress);
        }

        private Operation(String titleWithMnemonic, String toolTip, String iconPath, boolean progress) {
            this(titleWithMnemonic, toolTip, iconPath, iconPath, progress);
        }

        private Operation(String titleWithMnemonic, String toolTip, String iconPath, String mirroredIconPath, boolean progress) {
            this.titleWithMnemonic = titleWithMnemonic;
            this.toolTip = toolTip;
            this.iconPath = iconPath;
            this.mirroredIconPath = mirroredIconPath;
            this.progress = progress;
        }

        public String getTitle() {
            return this.titleWithMnemonic.replace("&", "");
        }

        public String getTitleWithMnemonic() {
            return this.titleWithMnemonic;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public Icon getIcon(boolean mirrored) {
            if (mirrored) {
                return ImageUtilities.loadImageIcon((String)this.mirroredIconPath, (boolean)false);
            }
            return ImageUtilities.loadImageIcon((String)this.iconPath, (boolean)false);
        }

        public boolean hasProgress() {
            return this.progress;
        }
    }
}

