/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.plugins;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.groovy.grails.api.ExecutionSupport;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.ProgressSupport;
import org.netbeans.modules.groovy.grailsproject.actions.RefreshProjectRunnable;
import org.netbeans.modules.groovy.grailsproject.plugins.GrailsPlugin;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class GrailsPluginSupport {
    private final GrailsProject project;

    private GrailsPluginSupport(GrailsProject project) {
        this.project = project;
    }

    public static GrailsPluginSupport forProject(Project project) {
        GrailsProject grailsProject = (GrailsProject)project.getLookup().lookup(GrailsProject.class);
        if (grailsProject != null) {
            return new GrailsPluginSupport(grailsProject);
        }
        return null;
    }

    public boolean usesPlugin(String name) {
        assert (name != null) : "Name is null";
        for (GrailsPlugin plugin : this.loadInstalledPlugins()) {
            if (!name.equals(plugin.getName())) continue;
            return true;
        }
        return false;
    }

    public FolderFilter getProjectPluginFilter() {
        GrailsProjectConfig projectConfig = (GrailsProjectConfig)this.project.getLookup().lookup(GrailsProjectConfig.class);
        if (projectConfig != null && GrailsPlatform.Version.VERSION_1_1.compareTo(projectConfig.getGrailsPlatform().getVersion()) <= 0) {
            List<GrailsPlugin> plugins = this.loadInstalledPlugins11();
            final HashSet<String> pluginDirs = new HashSet<String>();
            for (GrailsPlugin plugin : plugins) {
                pluginDirs.add(plugin.getDirName());
            }
            return new FolderFilter(){

                @Override
                public boolean accept(String folderName) {
                    return pluginDirs.contains(folderName);
                }
            };
        }
        return new FolderFilter(){

            @Override
            public boolean accept(String folderName) {
                return true;
            }
        };
    }

    public List<GrailsPlugin> refreshAvailablePlugins() throws InterruptedException {
        String command = "list-plugins";
        ProjectInformation inf = ProjectUtils.getInformation((Project)this.project);
        String displayName = inf.getDisplayName() + " (" + "list-plugins" + ")";
        Callable callable = ExecutionSupport.getInstance().createSimpleCommand("list-plugins", GrailsProjectConfig.forProject((Project)this.project), new String[0]);
        final PluginProcessor processor = new PluginProcessor();
        ExecutionDescriptor descriptor = new ExecutionDescriptor().frontWindow(true);
        descriptor = descriptor.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{defaultProcessor, InputProcessors.bridge((LineProcessor)processor)});
            }
        });
        ExecutionService service = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)descriptor, (String)displayName);
        Future task = service.run();
        try {
            task.get();
        }
        catch (InterruptedException ex) {
            task.cancel(true);
            throw ex;
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex.getCause());
        }
        return processor.getPlugins();
    }

    public List<GrailsPlugin> loadInstalledPlugins() {
        GrailsPlatform.Version version = GrailsPlatform.getDefault().getVersion();
        if (GrailsPlatform.Version.VERSION_1_1.compareTo(version) <= 0) {
            return this.loadInstalledPlugins11();
        }
        return this.loadInstalledPlugins10();
    }

    private List<GrailsPlugin> loadInstalledPlugins10() {
        ArrayList<GrailsPlugin> plugins = new ArrayList<GrailsPlugin>();
        try {
            FileObject pluginsDir = this.project.getProjectDirectory().getFileObject("plugins");
            if (pluginsDir != null && pluginsDir.isFolder()) {
                pluginsDir.refresh();
                for (FileObject child : pluginsDir.getChildren()) {
                    FileObject descriptor;
                    if (!child.isFolder() || (descriptor = child.getFileObject("plugin.xml")) == null || !descriptor.canRead()) continue;
                    plugins.add(this.getPluginFromInputStream(descriptor.getInputStream(), null));
                }
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Collections.sort(plugins);
        return plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GrailsPlugin> loadInstalledPlugins11() {
        ArrayList<GrailsPlugin> plugins;
        block7: {
            plugins = new ArrayList<GrailsPlugin>();
            try {
                FileObject propertiesFile = this.project.getProjectDirectory().getFileObject("application.properties");
                if (propertiesFile == null || !propertiesFile.isData()) break block7;
                Properties props = new Properties();
                try (BufferedInputStream is = new BufferedInputStream(propertiesFile.getInputStream());){
                    props.load(is);
                    Enumeration<?> e = props.propertyNames();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        if (!name.startsWith("plugins.")) continue;
                        String value = props.getProperty(name);
                        name = name.substring("plugins.".length());
                        plugins.add(new GrailsPlugin(name, value, null));
                    }
                }
            }
            catch (FileNotFoundException ex) {
                return Collections.emptyList();
            }
            catch (IOException ex) {
                return Collections.emptyList();
            }
        }
        Collections.sort(plugins);
        return plugins;
    }

    public boolean uninstallPlugins(Collection<GrailsPlugin> selectedPlugins) {
        GrailsPlatform.Version version = GrailsPlatform.getDefault().getVersion();
        if (GrailsPlatform.Version.VERSION_1_1.compareTo(version) <= 0) {
            return this.uninstallPlugins11(selectedPlugins);
        }
        return this.uninstallPlugins10(selectedPlugins);
    }

    private boolean uninstallPlugins10(Collection<GrailsPlugin> selectedPlugins) {
        FileObject pluginsDir;
        if (selectedPlugins != null && selectedPlugins.size() > 0 && (pluginsDir = this.project.getProjectDirectory().getFileObject("plugins")) != null && pluginsDir.isFolder() && pluginsDir.canWrite()) {
            pluginsDir.refresh();
            try {
                for (GrailsPlugin plugin : selectedPlugins) {
                    FileObject pluginZipFile;
                    FileObject pluginDir = pluginsDir.getFileObject(plugin.getDirName());
                    if (pluginDir != null && pluginDir.isValid()) {
                        pluginDir.delete();
                    }
                    if ((pluginZipFile = pluginsDir.getFileObject(plugin.getZipName())) == null || !pluginZipFile.isValid()) continue;
                    pluginZipFile.delete();
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return true;
    }

    private boolean uninstallPlugins11(Collection<GrailsPlugin> selectedPlugins) {
        return this.handlePlugins(selectedPlugins, true);
    }

    public boolean installPlugins(Collection<GrailsPlugin> selectedPlugins) {
        return this.handlePlugins(selectedPlugins, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handlePlugins(Collection<GrailsPlugin> selectedPlugins, boolean uninstall) {
        assert (SwingUtilities.isEventDispatchThread());
        if (selectedPlugins == null || selectedPlugins.size() <= 0) {
            return false;
        }
        boolean installed = true;
        GrailsPlatform platform = GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform();
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try {
            for (GrailsPlugin plugin : selectedPlugins) {
                String title = NbBundle.getMessage(GrailsPluginSupport.class, (String)(uninstall ? "Uninstallation" : "Installation"));
                String message = NbBundle.getMessage(GrailsPluginSupport.class, (String)(uninstall ? "PluginUninstallPleaseWait" : "PluginInstallPleaseWait"), (Object)plugin.getName());
                ProgressHandle handle = ProgressHandleFactory.createHandle((String)message);
                ProgressSupport.ProgressDialogDescriptor descriptor = ProgressSupport.createProgressDialog(title, handle, null);
                final Dialog dlg = DialogDisplayer.getDefault().createDialog((DialogDescriptor)descriptor);
                descriptor.addCancelListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dlg.setVisible(false);
                        dlg.dispose();
                    }
                });
                Callable<Boolean> runner = this.getPluginHandlerCallable(platform, plugin, descriptor, dlg, uninstall);
                Future<Boolean> result = executor.submit(runner);
                handle.start();
                handle.progress(message);
                dlg.setVisible(true);
                try {
                    installed = installed && result.get() != false;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)(ex.getCause() != null ? ex.getCause() : ex));
                }
                finally {
                    handle.finish();
                }
            }
            executor.shutdown();
        }
        catch (Throwable throwable) {
            executor.shutdown();
            FileUtil.refreshFor((File[])new File[]{this.project.getBuildConfig().getProjectPluginsDir()});
            throw throwable;
        }
        FileUtil.refreshFor((File[])new File[]{this.project.getBuildConfig().getProjectPluginsDir()});
        return installed;
    }

    private Callable<Boolean> getPluginHandlerCallable(final GrailsPlatform platform, final GrailsPlugin plugin, final ProgressSupport.ProgressDialogDescriptor desc, final Dialog dlg, boolean uninstall) {
        final String command = uninstall ? "uninstall-plugin" : "install-plugin";
        return new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                Boolean bl;
                ProjectInformation inf = ProjectUtils.getInformation((Project)GrailsPluginSupport.this.project);
                String displayName = inf.getDisplayName() + " (" + command + ")";
                ArrayList<String> args = new ArrayList<String>(3);
                if (GrailsPlatform.Version.VERSION_1_1.compareTo(platform.getVersion()) <= 0) {
                    args.add("--non-interactive");
                }
                if (plugin.getPath() == null) {
                    args.add(plugin.getName());
                    args.add(plugin.getVersion());
                } else {
                    args.add(plugin.getPath().getAbsolutePath());
                }
                Callable callable = ExecutionSupport.getInstance().createSimpleCommand(command, GrailsProjectConfig.forProject((Project)GrailsPluginSupport.this.project), args.toArray(new String[args.size()]));
                ExecutionDescriptor descriptor = new ExecutionDescriptor().frontWindow(true).postExecution((Runnable)new RefreshProjectRunnable(GrailsPluginSupport.this.project));
                ExecutionService service = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)descriptor, (String)displayName);
                final Future future = service.run();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        desc.addCancelListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ev) {
                                future.cancel(true);
                            }
                        });
                    }
                });
                boolean broken = false;
                boolean interrupted = false;
                try {
                    try {
                        Integer retValue = (Integer)future.get();
                        if (retValue != 0) {
                            broken = true;
                        }
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                        future.cancel(true);
                        broken = true;
                    }
                    catch (ExecutionException ex) {
                        broken = true;
                        Exceptions.printStackTrace((Throwable)(ex.getCause() != null ? ex.getCause() : ex));
                    }
                    catch (CancellationException ex) {
                        broken = true;
                    }
                    bl = !broken;
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            dlg.setVisible(false);
                            dlg.dispose();
                        }
                    });
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return bl;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrailsPlugin getPluginFromZipFile(String path) {
        GrailsPlugin plugin;
        block6: {
            plugin = null;
            try {
                File pluginFile = new File(path);
                if (!pluginFile.exists() || !pluginFile.isFile()) break block6;
                try (ZipFile file = new ZipFile(pluginFile);){
                    ZipEntry entry = file.getEntry("plugin.xml");
                    if (entry != null) {
                        InputStream stream = file.getInputStream(entry);
                        plugin = this.getPluginFromInputStream(stream, pluginFile);
                    }
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return plugin;
    }

    private GrailsPlugin getPluginFromInputStream(InputStream inputStream, File path) throws Exception {
        Document doc = XMLUtil.parse((InputSource)new InputSource(inputStream), (boolean)false, (boolean)false, null, null);
        Node root = doc.getFirstChild();
        String name = root.getAttributes().getNamedItem("name").getTextContent();
        String version = null;
        String description = null;
        if (root.getAttributes().getNamedItem("version") != null) {
            version = root.getAttributes().getNamedItem("version").getTextContent();
        }
        if (doc.getElementsByTagName("title") != null && doc.getElementsByTagName("title").getLength() > 0) {
            description = doc.getElementsByTagName("title").item(0).getTextContent();
        }
        return new GrailsPlugin(name, version, description, path);
    }

    private static class PluginProcessor
    implements LineProcessor {
        private final List<GrailsPlugin> plugins = Collections.synchronizedList(new ArrayList());
        private static final Pattern PLUGIN_PATTERN = Pattern.compile("(.+)[\\s]+<(.+)>[\\s]+--(.+)");

        private PluginProcessor() {
        }

        public void processLine(String line) {
            GrailsPlugin plugin = null;
            Matcher matcher = PLUGIN_PATTERN.matcher(line);
            if (matcher.matches() && !"no releases".equals(matcher.group(2))) {
                plugin = new GrailsPlugin(matcher.group(1).trim(), matcher.group(2), matcher.group(3));
            }
            if (plugin != null) {
                this.plugins.add(plugin);
            }
        }

        public void reset() {
        }

        public void close() {
        }

        public List<GrailsPlugin> getPlugins() {
            return this.plugins;
        }
    }

    public static interface FolderFilter {
        public boolean accept(String var1);
    }
}

