/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.classview.ChildrenUpdater;
import org.netbeans.modules.cnd.classview.PersistentKey;
import org.netbeans.modules.cnd.classview.SortedName;
import org.netbeans.modules.cnd.classview.UpdatebleHost;
import org.netbeans.modules.cnd.classview.model.CVUtil;
import org.netbeans.modules.cnd.modelutil.AbstractCsmNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.CharSequences;
import org.openide.util.RequestProcessor;

public abstract class HostKeyArray
extends Children.Keys<PersistentKey>
implements UpdatebleHost {
    private static final boolean traceEvents = Boolean.getBoolean("cnd.classview.key-events");
    private static final RequestProcessor RP = new RequestProcessor(HostKeyArray.class.getName(), 1);
    private static final boolean noLoadinNode = Boolean.getBoolean("cnd.classview.no-loading-node");
    private static Comparator<Map.Entry<PersistentKey, SortedName>> COMARATOR = new MyComparator();
    private ChildrenUpdater childrenUpdater;
    private CsmProject myProject;
    private PersistentKey myID;
    private boolean update;
    private Map<PersistentKey, SortedName> myKeys;
    private Map<PersistentKey, ChangeListener> myChanges;
    private boolean isInited = false;
    private boolean isDisposed = false;

    public HostKeyArray(ChildrenUpdater childrenUpdater, CsmProject project, PersistentKey id) {
        this.childrenUpdater = childrenUpdater;
        this.myProject = project;
        this.myID = id;
        childrenUpdater.register(project, id, this);
    }

    protected ChildrenUpdater getUpdater() {
        return this.childrenUpdater;
    }

    protected void dispose() {
        this.isDisposed = true;
        if (this.isInited) {
            this.isInited = false;
            this.myKeys.clear();
            this.myChanges.clear();
            this.childrenUpdater.unregister(this.myProject, this.myID);
        }
    }

    private synchronized void resetKeys() {
        ArrayList<Map.Entry<PersistentKey, SortedName>> list = new ArrayList<Map.Entry<PersistentKey, SortedName>>();
        if (this.myKeys != null) {
            list.addAll(this.myKeys.entrySet());
        }
        Collections.sort(list, COMARATOR);
        ArrayList<PersistentKey> res = new ArrayList<PersistentKey>();
        for (Map.Entry entry : list) {
            PersistentKey key = (PersistentKey)entry.getKey();
            if (key == null) continue;
            res.add(key);
        }
        this.setKeys(res);
    }

    protected abstract Map<PersistentKey, SortedName> getMembers();

    protected abstract CsmOffsetableDeclaration findDeclaration(PersistentKey var1);

    protected abstract boolean canCreateNode(CsmOffsetableDeclaration var1);

    protected abstract Node createNode(PersistentKey var1);

    protected boolean isGlobalNamespace() {
        return false;
    }

    protected boolean isNamespace() {
        return false;
    }

    protected SortedName getSortedName(CsmNamespace ns) {
        return new SortedName(0, CVUtil.getNamespaceDisplayName(ns), 0);
    }

    protected SortedName getSortedName(CsmOffsetableDeclaration d) {
        if (CsmKindUtilities.isClass((CsmObject)d)) {
            return new SortedName(1, d.getName(), 0);
        }
        if (d.getKind() == CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION) {
            return new SortedName(1, d.getName(), 0);
        }
        if (d.getKind() == CsmDeclaration.Kind.ENUM) {
            return new SortedName(1, d.getName(), 1);
        }
        if (d.getKind() == CsmDeclaration.Kind.ENUM_FORWARD_DECLARATION) {
            return new SortedName(1, d.getName(), 1);
        }
        if (d.getKind() == CsmDeclaration.Kind.TYPEDEF) {
            return new SortedName(1, d.getName(), 2);
        }
        if (d.getKind() == CsmDeclaration.Kind.VARIABLE) {
            return new SortedName(2, d.getName(), 0);
        }
        if (d.getKind() == CsmDeclaration.Kind.FUNCTION) {
            return new SortedName(3, CVUtil.getSignature((CsmFunction)d), 0);
        }
        if (d.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION) {
            return new SortedName(3, CVUtil.getSignature((CsmFunction)d), 1);
        }
        if (d.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND) {
            return new SortedName(3, CVUtil.getSignature((CsmFunction)d), 0);
        }
        if (d.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION) {
            return new SortedName(3, CVUtil.getSignature((CsmFunction)d), 1);
        }
        return new SortedName(9, d.getName(), 0);
    }

    protected CsmProject getProject() {
        return this.myProject;
    }

    protected PersistentKey getHostId() {
        return this.myID;
    }

    @Override
    public boolean newNamespsce(CsmNamespace ns) {
        if (!this.isInited) {
            return false;
        }
        PersistentKey key = PersistentKey.createKey(ns);
        this.myKeys.put(key, this.getSortedName(ns));
        this.update = true;
        return true;
    }

    @Override
    public boolean removeNamespsce(CsmNamespace ns) {
        if (!this.isInited) {
            return false;
        }
        PersistentKey key = PersistentKey.createKey(ns);
        this.myKeys.remove(key);
        this.childrenUpdater.unregister(this.myProject, key);
        this.update = true;
        return true;
    }

    @Override
    public boolean newDeclaration(CsmOffsetableDeclaration decl) {
        PersistentKey defKey;
        CsmFunction fun;
        CsmFunctionDefinition def;
        if (!this.isInited) {
            return false;
        }
        if (CsmKindUtilities.isFunctionDefinition((CsmObject)decl)) {
            CsmFunctionDefinition def2 = (CsmFunctionDefinition)decl;
            CsmFunction fun2 = def2.getDeclaration();
            if (fun2 != null && fun2 != decl) {
                PersistentKey funKey = PersistentKey.createKey(fun2);
                if (this.myKeys.containsKey(funKey)) {
                    return false;
                }
                decl = fun2;
            }
        } else if (CsmKindUtilities.isFunctionDeclaration((CsmObject)decl) && (def = (fun = (CsmFunction)decl).getDefinition()) != null && def != decl && this.myKeys.containsKey(defKey = PersistentKey.createKey(def))) {
            this.myKeys.remove(defKey);
            this.myChanges.remove(defKey);
            this.childrenUpdater.unregister(this.myProject, defKey);
        }
        PersistentKey key = PersistentKey.createKey(decl);
        this.myKeys.put(key, this.getSortedName(decl));
        this.myChanges.remove(key);
        this.update = true;
        return true;
    }

    @Override
    public boolean removeDeclaration(CsmOffsetableDeclaration decl) {
        if (!this.isInited) {
            return false;
        }
        PersistentKey key = PersistentKey.createKey(decl);
        if (!this.myKeys.containsKey(key)) {
            return false;
        }
        this.myKeys.remove(key);
        this.myChanges.remove(key);
        this.childrenUpdater.unregister(this.myProject, key);
        if (CsmKindUtilities.isFunctionDeclaration((CsmObject)decl)) {
            this.removeFunctionDeclaration(decl);
        } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)decl)) {
            this.removeFunctionDefinition(decl);
        }
        this.update = true;
        return true;
    }

    private void removeFunctionDeclaration(CsmOffsetableDeclaration decl) {
        PersistentKey defKey;
        PersistentKey otherKey;
        CsmOffsetableDeclaration other;
        CsmFunction fun = (CsmFunction)decl;
        CsmFile file = fun.getContainingFile();
        if (file != null && file.isValid() && (other = (CsmOffsetableDeclaration)file.getProject().findDeclaration(fun.getUniqueName())) != null && !this.myKeys.containsKey(otherKey = PersistentKey.createKey(other))) {
            this.myKeys.put(otherKey, this.getSortedName(other));
            this.myChanges.remove(otherKey);
            return;
        }
        CsmFunctionDefinition def = fun.getDefinition();
        if (def != null && def != decl && (file = fun.getContainingFile()) != null && file.isValid() && file.getProject().findDeclaration(def.getUniqueName()) != null && !this.myKeys.containsKey(defKey = PersistentKey.createKey(def))) {
            this.myKeys.put(defKey, this.getSortedName((CsmOffsetableDeclaration)def));
            this.myChanges.remove(defKey);
        }
    }

    private void removeFunctionDefinition(CsmOffsetableDeclaration decl) {
        PersistentKey otherKey;
        CsmOffsetableDeclaration other;
        CsmFile file;
        CsmFunctionDefinition def = (CsmFunctionDefinition)decl;
        CsmFunction fun = def.getDeclaration();
        if (fun != null && fun != decl && (file = fun.getContainingFile()) != null && file.isValid() && (other = (CsmOffsetableDeclaration)file.getProject().findDeclaration(fun.getUniqueName())) != null && !this.myKeys.containsKey(otherKey = PersistentKey.createKey(other))) {
            this.myKeys.put(otherKey, this.getSortedName(other));
            this.myChanges.remove(otherKey);
            return;
        }
        file = def.getContainingFile();
        if (file != null && file.isValid() && (other = (CsmOffsetableDeclaration)file.getProject().findDeclaration(def.getUniqueName())) != null && !this.myKeys.containsKey(otherKey = PersistentKey.createKey(other))) {
            this.myKeys.put(otherKey, this.getSortedName(other));
            this.myChanges.remove(otherKey);
        }
    }

    @Override
    public boolean changeDeclaration(CsmOffsetableDeclaration oldDecl, CsmOffsetableDeclaration newDecl) {
        if (!this.isInited) {
            return false;
        }
        PersistentKey oldKey = PersistentKey.createKey(oldDecl);
        if (newDecl == null) {
            this.myKeys.remove(oldKey);
            this.myChanges.remove(oldKey);
            this.childrenUpdater.unregister(this.myProject, oldKey);
            this.update = true;
            return true;
        }
        PersistentKey newKey = PersistentKey.createKey(newDecl);
        if (oldKey.equals(newKey)) {
            if (this.myKeys.containsKey(newKey)) {
                this.myKeys.put(newKey, this.getSortedName(newDecl));
                ChangeListener l = this.myChanges.get(newKey);
                if (l != null) {
                    l.stateChanged(new ChangeEvent(newDecl));
                }
                return this.updateFunction(newDecl);
            }
            return this.newDeclaration(newDecl);
        }
        this.removeDeclaration(oldDecl);
        this.newDeclaration(newDecl);
        this.update = true;
        return true;
    }

    private boolean updateFunction(CsmOffsetableDeclaration decl) {
        PersistentKey funKey;
        CsmFunctionDefinition def;
        CsmFunction fun;
        if (CsmKindUtilities.isFunctionDeclaration((CsmObject)decl)) {
            PersistentKey defKey;
            CsmFunction fun2 = (CsmFunction)decl;
            CsmFunctionDefinition def2 = fun2.getDefinition();
            if (def2 != null && def2 != decl && this.myKeys.containsKey(defKey = PersistentKey.createKey(def2))) {
                this.myKeys.remove(defKey);
                this.myChanges.remove(defKey);
                this.childrenUpdater.unregister(this.myProject, defKey);
                this.update = true;
                return true;
            }
        } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)decl) && (fun = (def = (CsmFunctionDefinition)decl).getDeclaration()) != null && fun != decl && this.myKeys.containsKey(funKey = PersistentKey.createKey(fun))) {
            return this.removeDeclaration(decl);
        }
        return false;
    }

    @Override
    public boolean reset(CsmOffsetableDeclaration decl, List<CsmOffsetableDeclaration> recursive) {
        this.myID = PersistentKey.createKey(decl);
        if (!this.isInited) {
            return false;
        }
        boolean needUpdate = false;
        Map<PersistentKey, SortedName> members = this.getMembers();
        ArrayList<PersistentKey> toDelete = null;
        for (PersistentKey persistentKey : this.myKeys.keySet()) {
            if (members.containsKey(persistentKey)) continue;
            if (toDelete == null) {
                toDelete = new ArrayList<PersistentKey>();
            }
            toDelete.add(persistentKey);
        }
        if (toDelete != null) {
            for (PersistentKey persistentKey : toDelete) {
                this.myKeys.remove(persistentKey);
                this.myChanges.remove(persistentKey);
                needUpdate = true;
            }
        }
        for (Map.Entry entry : members.entrySet()) {
            PersistentKey key = (PersistentKey)entry.getKey();
            if (this.myKeys.containsKey(key)) {
                this.myKeys.put(key, (SortedName)entry.getValue());
                CsmOffsetableDeclaration what = this.findDeclaration(key);
                if (what == null) {
                    this.myKeys.remove(key);
                    this.myChanges.remove(key);
                    needUpdate = true;
                    continue;
                }
                ChangeListener l = this.myChanges.get(key);
                if (l != null) {
                    l.stateChanged(new ChangeEvent(what));
                }
                if (!CsmKindUtilities.isClassifier((CsmObject)what) && !CsmKindUtilities.isEnum((CsmObject)what)) continue;
                recursive.add(what);
                continue;
            }
            this.myKeys.put(key, (SortedName)entry.getValue());
            this.myChanges.remove(key);
            needUpdate = true;
        }
        if (needUpdate) {
            this.update = true;
            return true;
        }
        return false;
    }

    @Override
    public void flush() {
        if (this.update && this.isInited) {
            this.resetKeys();
        }
        this.update = false;
    }

    protected Node[] createNodes(PersistentKey object) {
        Node node = this.createNode(object);
        if (node != null) {
            if (node instanceof ChangeListener) {
                this.myChanges.put(object, (ChangeListener)node);
            }
            return new Node[]{node};
        }
        return new Node[0];
    }

    public Node findChild(CsmObject object) {
        Node[] list = this.getNodes();
        if (list.length == 0) {
            return null;
        }
        if (object == null) {
            return list[0];
        }
        Node res = null;
        CharSequence qname = null;
        if (CsmKindUtilities.isQualified((CsmObject)object)) {
            qname = ((CsmQualifiedNamedElement)object).getQualifiedName();
        }
        CharSequence signature = null;
        if (CsmKindUtilities.isFunction((CsmObject)object)) {
            signature = ((CsmFunction)object).getSignature();
        }
        for (int i = 0; i < list.length; ++i) {
            if (!(list[i] instanceof AbstractCsmNode)) continue;
            CsmObject tested = ((AbstractCsmNode)list[i]).getCsmObject();
            if (object.equals(tested)) {
                return list[i];
            }
            if (res != null || tested == null || qname == null || !CsmKindUtilities.isQualified((CsmObject)tested)) continue;
            CharSequence testedName = ((CsmQualifiedNamedElement)tested).getQualifiedName();
            if (CharSequences.comparator().compare(qname, testedName) != 0) continue;
            if (CsmKindUtilities.isFunction((CsmObject)object) || CsmKindUtilities.isFunction((CsmObject)tested)) {
                if (!CsmKindUtilities.isFunction((CsmObject)object) || !CsmKindUtilities.isFunction((CsmObject)tested)) continue;
                CharSequence testedSignature = ((CsmFunction)tested).getSignature();
                if (CharSequences.comparator().compare(signature, testedSignature) == 0) {
                    return list[i];
                }
                res = list[i];
                continue;
            }
            res = list[i];
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureInited() {
        Object object = this.childrenUpdater.getLock(this.getProject());
        synchronized (object) {
            if (!this.isInited) {
                this.addNotify(true);
            }
        }
    }

    protected void addNotify() {
        this.addNotify(noLoadinNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNotify(boolean force) {
        Object object = this.childrenUpdater.getLock(this.getProject());
        synchronized (object) {
            if (this.isInited || this.isDisposed) {
                return;
            }
            if (this.isNamespace() && !force) {
                this.myKeys = new HashMap<PersistentKey, SortedName>();
                this.myKeys.put(PersistentKey.createKey(this.getProject()), new SortedName(0, "", 0));
            } else {
                this.myKeys = this.getMembers();
            }
            this.myChanges = new HashMap<PersistentKey, ChangeListener>();
            this.isInited = true;
            this.resetKeys();
        }
        super.addNotify();
        if (this.isNamespace() && !force) {
            RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = HostKeyArray.this.childrenUpdater.getLock(HostKeyArray.this.getProject());
                    synchronized (object) {
                        HostKeyArray.this.myKeys = HostKeyArray.this.getMembers();
                        HostKeyArray.this.resetKeys();
                    }
                }
            });
        }
    }

    protected void removeNotify() {
        super.removeNotify();
        this.isInited = false;
        this.myKeys.clear();
        this.myChanges.clear();
        this.childrenUpdater.unregister(this.myProject, this.myID);
        this.resetKeys();
        if (traceEvents) {
            System.out.println("Remove key " + this.myID.toString());
        }
    }

    protected void destroyNodes(Node[] node) {
        for (Node n : node) {
            Children children = n.getChildren();
            if (!(children instanceof HostKeyArray)) continue;
            ((HostKeyArray)children).dispose();
        }
        super.destroyNodes(node);
        if (traceEvents) {
            System.out.println("Destroy nodes " + node.length + " in " + this.myID.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPprojectParsingFinished(CsmProject project) {
        if (!this.isInited || project != this.getProject()) {
            return;
        }
        Object object = this.childrenUpdater.getLock(this.getProject());
        synchronized (object) {
            PersistentKey key = PersistentKey.createKey(project);
            if (this.myKeys.containsKey(key)) {
                this.myKeys.remove(key);
                this.resetKeys();
            }
        }
    }

    private static class MyComparator
    implements Comparator<Map.Entry<PersistentKey, SortedName>>,
    Serializable {
        private MyComparator() {
        }

        @Override
        public int compare(Map.Entry<PersistentKey, SortedName> o1, Map.Entry<PersistentKey, SortedName> o2) {
            SortedName n2;
            SortedName n1 = o1.getValue();
            int res = n1.compareTo(n2 = o2.getValue());
            if (res != 0) {
                return res;
            }
            String s1 = o1.getKey().toString();
            String s2 = o2.getKey().toString();
            return s1.compareTo(s2);
        }
    }
}

