/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.diff;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.mercurial.remote.FileInformation;
import org.netbeans.modules.mercurial.remote.FileStatus;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.diff.DiffNode;
import org.netbeans.modules.mercurial.remote.ui.diff.DiffStreamSource;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.diff.AbstractDiffSetup;
import org.openide.util.NbBundle;

public final class Setup
extends AbstractDiffSetup {
    public static final int DIFFTYPE_LOCAL = 0;
    public static final int DIFFTYPE_REMOTE = 1;
    public static final int DIFFTYPE_ALL = 2;
    private final VCSFileProxy baseFile;
    private final HgLogMessage.HgRevision firstRevision;
    private final HgLogMessage.HgRevision secondRevision;
    private final FileInformation info;
    private final DiffStreamSource firstSource;
    private final DiffStreamSource secondSource;
    private DiffController view;
    private DiffNode node;
    private String title;

    public Setup(VCSFileProxy baseFile, String propertyName, int type) {
        String secondTitle;
        String firstTitle;
        this.baseFile = baseFile;
        this.info = Mercurial.getInstance().getFileStatusCache().getStatus(baseFile);
        int status = this.info.getStatus();
        FileStatus fileStatus = this.info.getStatus(null);
        ResourceBundle loc = NbBundle.getBundle(Setup.class);
        switch (type) {
            case 0: {
                if (Setup.match(status, 4100)) {
                    this.firstRevision = HgLogMessage.HgRevision.BASE;
                    VCSFileProxy originalFile = null;
                    if (fileStatus != null && fileStatus.isCopied()) {
                        originalFile = fileStatus.getOriginalFile();
                    }
                    firstTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_BaseRevision"), originalFile == null ? this.firstRevision.getRevisionNumber() : originalFile.getName());
                    break;
                }
                if (Setup.match(status, 512)) {
                    this.firstRevision = null;
                    firstTitle = NbBundle.getMessage(Setup.class, (String)"LBL_Diff_NoLocalFile");
                    break;
                }
                if (Setup.match(status, 2304)) {
                    this.firstRevision = HgLogMessage.HgRevision.BASE;
                    firstTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_BaseRevision"), this.firstRevision.getRevisionNumber());
                    break;
                }
                this.firstRevision = HgLogMessage.HgRevision.BASE;
                firstTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_BaseRevision"), this.firstRevision.getRevisionNumber());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow diff type: " + type);
            }
        }
        switch (type) {
            case 0: {
                if (Setup.match(status, 64)) {
                    this.secondRevision = HgLogMessage.HgRevision.CURRENT;
                    secondTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_LocalConflict"), this.secondRevision.getRevisionNumber());
                    break;
                }
                if (Setup.match(status, 4100)) {
                    this.secondRevision = HgLogMessage.HgRevision.CURRENT;
                    if (fileStatus != null && fileStatus.isCopied()) {
                        if (fileStatus.getOriginalFile() != null && !fileStatus.getOriginalFile().exists()) {
                            if (fileStatus.getOriginalFile().getParentFile().getPath().equals(baseFile.getParentFile().getPath())) {
                                secondTitle = loc.getString("MSG_DiffPanel_LocalRenamed");
                                break;
                            }
                            secondTitle = loc.getString("MSG_DiffPanel_LocalMoved");
                            break;
                        }
                        secondTitle = loc.getString("MSG_DiffPanel_LocalCopied");
                        break;
                    }
                    secondTitle = loc.getString("MSG_DiffPanel_LocalNew");
                    break;
                }
                if (Setup.match(status, 512)) {
                    this.secondRevision = null;
                    secondTitle = NbBundle.getMessage(Setup.class, (String)"LBL_Diff_NoLocalFile");
                    break;
                }
                if (Setup.match(status, 256)) {
                    this.secondRevision = null;
                    secondTitle = loc.getString("MSG_DiffPanel_LocalRemoved");
                    break;
                }
                if (Setup.match(status, 2048)) {
                    this.secondRevision = null;
                    secondTitle = loc.getString("MSG_DiffPanel_LocalDeleted");
                    break;
                }
                this.secondRevision = HgLogMessage.HgRevision.CURRENT;
                secondTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_LocalModified"), this.secondRevision.getRevisionNumber());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow diff type: " + type);
            }
        }
        this.firstSource = new DiffStreamSource(baseFile, baseFile, this.firstRevision, firstTitle);
        this.secondSource = new DiffStreamSource(baseFile, baseFile, this.secondRevision, secondTitle);
        this.title = "<html>" + Mercurial.getInstance().getMercurialAnnotator().annotateNameHtml(baseFile, this.info);
    }

    public Setup(VCSFileProxy baseFile, HgLogMessage.HgRevision firstRevision, HgLogMessage.HgRevision secondRevision, FileInformation info, final boolean forceNonEditable) {
        this.title = baseFile.getName();
        this.baseFile = baseFile;
        this.firstRevision = firstRevision;
        this.secondRevision = secondRevision;
        this.info = info;
        VCSFileProxy firstSourceBaseFile = baseFile;
        if (info != null && info.getStatus(null) != null && info.getStatus(null).getOriginalFile() != null) {
            firstSourceBaseFile = info.getStatus(null).getOriginalFile();
        }
        this.firstSource = new DiffStreamSource(firstSourceBaseFile, firstSourceBaseFile, firstRevision, firstRevision.toString());
        this.secondSource = new DiffStreamSource(baseFile, baseFile, secondRevision, secondRevision.toString()){

            @Override
            public boolean isEditable() {
                return !forceNonEditable && super.isEditable();
            }
        };
    }

    public VCSFileProxy getBaseFile() {
        return this.baseFile;
    }

    public FileInformation getInfo() {
        return this.info;
    }

    public void setView(DiffController view) {
        this.view = view;
    }

    public DiffController getView() {
        return this.view;
    }

    public StreamSource getFirstSource() {
        return this.firstSource;
    }

    public StreamSource getSecondSource() {
        return this.secondSource;
    }

    void setNode(DiffNode node) {
        this.node = node;
    }

    DiffNode getNode() {
        return this.node;
    }

    public String toString() {
        return this.title;
    }

    void initSources() throws IOException {
        if (this.firstSource != null) {
            this.firstSource.init();
        }
        if (this.secondSource != null) {
            this.secondSource.init();
        }
    }

    private static boolean match(int status, int mask) {
        return (status & mask) != 0;
    }
}

