/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard;

import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.spi.JavacardPlatformLocator;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class Installer {
    private static final String ATTR = "isRiBundle302";
    private static final String[] SUPERSEDED_ATTRS = new String[]{"isRiBundle"};
    private static final String PLATFORM_DIRECTORY_NAME = "JCDK3.0.2_ConnectedEdition";
    private static boolean installing = false;
    private static final Object LOCK = new Object();
    private static RequestProcessor rp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void install() {
        Object object = LOCK;
        synchronized (object) {
            if (installing) {
                return;
            }
            installing = true;
        }
        rp = new RequestProcessor();
        rp.post(new Runnable(){

            @Override
            public void run() {
                Installer.installImpl();
                rp.shutdown();
                rp = null;
                installing = false;
            }
        });
    }

    private static void installImpl() throws MissingResourceException {
        FileObject sdkFolder;
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Installer.class, (String)"MSG_CHECKING_RUNTIME"));
        FileObject platformsFolder = Utils.sfsFolderForRegisteredJavaPlatforms();
        for (FileObject fo : platformsFolder.getChildren()) {
            if (Boolean.TRUE.equals(fo.getAttribute(ATTR))) {
                return;
            }
            for (String s : SUPERSEDED_ATTRS) {
                if (!Boolean.TRUE.equals(fo.getAttribute(s))) continue;
                Installer.cleanUp(fo);
            }
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Installer.class, (String)"MSG_UNPACKING_RUNTIME"));
        File sdk = InstalledFileLocator.getDefault().locate(PLATFORM_DIRECTORY_NAME, "org.netbeans.modules.javacard.ri.bundle", false);
        if (sdk != null && sdk.exists() && sdk.isDirectory() && (sdkFolder = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)sdk))) != null) {
            for (JavacardPlatformLocator l : Lookup.getDefault().lookupAll(JavacardPlatformLocator.class)) {
                if (!l.accept(sdkFolder)) continue;
                String runtimeName = NbBundle.getMessage(Installer.class, (String)"BUNDLED_RUNTIME_NAME");
                try {
                    FileObject platform = l.install(sdkFolder, runtimeName);
                    assert (platform != null) : "Platform not created";
                    platform.setAttribute(ATTR, (Object)Boolean.TRUE);
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
                return;
            }
        }
    }

    private static void cleanUp(FileObject platformFileObject) {
        try {
            FileObject eepromFolder;
            FileObject serversFolder = Utils.sfsFolderForDeviceConfigsForPlatformNamed((String)platformFileObject.getName(), (boolean)false);
            if (serversFolder != null) {
                serversFolder.delete();
            }
            if ((eepromFolder = Utils.sfsFolderForDeviceEepromsForPlatformNamed((String)platformFileObject.getName(), (boolean)false)) != null) {
                eepromFolder.delete();
            }
            platformFileObject.delete();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void uninstall() {
        FileObject platformsFolder = Utils.sfsFolderForRegisteredJavaPlatforms();
        for (FileObject fo : platformsFolder.getChildren()) {
            if (!Boolean.TRUE.equals(fo.getAttribute(ATTR))) continue;
            Installer.cleanUp(fo);
        }
    }
}

