/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.deps;

import java.util.EnumSet;
import java.util.Set;
import org.netbeans.modules.javacard.project.deps.ArtifactKind;
import org.netbeans.modules.javacard.project.deps.DeploymentStrategy;
import org.openide.util.NbBundle;

public enum DependencyKind {
    CLASSIC_LIB,
    EXTENSION_LIB,
    JAVA_PROJECT,
    RAW_JAR,
    CLASSIC_LIB_JAR,
    EXTENSION_LIB_JAR,
    JAR_WITH_EXP_FILE;


    public boolean isProjectDependency() {
        return this == CLASSIC_LIB || this == EXTENSION_LIB;
    }

    public boolean isOriginAFolder() {
        return this.isProjectDependency();
    }

    public Set<ArtifactKind> supportedArtifacts() {
        switch (this) {
            case CLASSIC_LIB: 
            case EXTENSION_LIB: 
            case JAVA_PROJECT: {
                return EnumSet.of(ArtifactKind.ORIGIN);
            }
            case CLASSIC_LIB_JAR: {
                return EnumSet.of(ArtifactKind.ORIGIN, ArtifactKind.SIG_FILE, ArtifactKind.EXP_FILE);
            }
            case EXTENSION_LIB_JAR: {
                return EnumSet.of(ArtifactKind.ORIGIN, ArtifactKind.SIG_FILE);
            }
            case RAW_JAR: {
                return EnumSet.of(ArtifactKind.ORIGIN, ArtifactKind.SOURCES_PATH);
            }
            case JAR_WITH_EXP_FILE: {
                return EnumSet.of(ArtifactKind.ORIGIN, ArtifactKind.SOURCES_PATH, ArtifactKind.EXP_FILE);
            }
        }
        throw new AssertionError();
    }

    public Set<DeploymentStrategy> supportedDeploymentStrategies() {
        switch (this) {
            case JAR_WITH_EXP_FILE: {
                return EnumSet.of(DeploymentStrategy.ALREADY_ON_CARD, DeploymentStrategy.INCLUDE_IN_PROJECT_CLASSES);
            }
            case CLASSIC_LIB_JAR: 
            case EXTENSION_LIB_JAR: {
                return EnumSet.of(DeploymentStrategy.DEPLOY_TO_CARD, DeploymentStrategy.ALREADY_ON_CARD, DeploymentStrategy.INCLUDE_IN_PROJECT_CLASSES);
            }
            case CLASSIC_LIB: 
            case EXTENSION_LIB: {
                return EnumSet.of(DeploymentStrategy.DEPLOY_TO_CARD, DeploymentStrategy.ALREADY_ON_CARD);
            }
            case RAW_JAR: {
                return EnumSet.of(DeploymentStrategy.ALREADY_ON_CARD, DeploymentStrategy.INCLUDE_IN_PROJECT_CLASSES);
            }
        }
        return EnumSet.of(DeploymentStrategy.DEPLOY_TO_CARD, DeploymentStrategy.ALREADY_ON_CARD, DeploymentStrategy.INCLUDE_IN_PROJECT_CLASSES);
    }

    public static DependencyKind parse(String s) {
        return DependencyKind.valueOf(s);
    }

    public String toString() {
        return NbBundle.getMessage(DependencyKind.class, (String)this.name());
    }
}

