/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.templates;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.javacard.templates.ServletDeploymentWizardPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class ServletDeploymentVisualPanel
extends JPanel
implements DocumentListener,
ActionListener {
    private ServletDeploymentWizardPanel wizardPanel;
    private JCheckBox addInfoCheckBox;
    private JTextField classNameTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField servletNameTextField;
    private JTextField urlPatternTextField;

    ServletDeploymentVisualPanel(ServletDeploymentWizardPanel wizardPanel) {
        this.initComponents();
        this.wizardPanel = wizardPanel;
        this.servletNameTextField.getDocument().addDocumentListener(this);
        this.urlPatternTextField.getDocument().addDocumentListener(this);
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ServletDeploymentVisualPanel.class, (String)"LBL_wizard_deployment");
    }

    void setClassName(String className) {
        String oldClassName = this.classNameTextField.getText();
        boolean update = oldClassName != null && !oldClassName.equals("");
        this.classNameTextField.setText(className);
        if (update) {
            String oldText = this.servletNameTextField.getText();
            if (oldText.startsWith(oldClassName)) {
                this.servletNameTextField.setText(className + oldText.substring(oldClassName.length()));
            }
            if ((oldText = this.urlPatternTextField.getText()).startsWith("/" + oldClassName)) {
                this.urlPatternTextField.setText("/" + className + oldText.substring(oldClassName.length() + 1));
            }
        } else {
            this.servletNameTextField.setText(className);
            this.urlPatternTextField.setText("/" + className);
        }
    }

    String getServletName() {
        return this.servletNameTextField.getText();
    }

    String getUrlPattern() {
        return this.urlPatternTextField.getText();
    }

    boolean isAddInfoSelected() {
        return this.addInfoCheckBox.isSelected();
    }

    private void initComponents() {
        this.addInfoCheckBox = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.classNameTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.servletNameTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.urlPatternTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.addInfoCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.addInfoCheckBox, (String)NbBundle.getMessage(ServletDeploymentVisualPanel.class, (String)"LBL_add_to_web_descr"));
        this.addInfoCheckBox.addActionListener(this);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ServletDeploymentVisualPanel.class, (String)"LBL_class_name"));
        this.classNameTextField.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ServletDeploymentVisualPanel.class, (String)"LBL_servlet_name"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ServletDeploymentVisualPanel.class, (String)"LBL_url_pattern"));
        this.urlPatternTextField.addActionListener(this);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)"<html>Register the Servlet with the application by giving the URL Pattern(s)</html>");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING).addComponent(this.addInfoCheckBox, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.jLabel2)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.classNameTextField, GroupLayout.Alignment.TRAILING, -1, 321, Short.MAX_VALUE).addComponent(this.servletNameTextField, -1, 317, Short.MAX_VALUE).addComponent(this.urlPatternTextField, -1, 321, Short.MAX_VALUE)))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.addInfoCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.classNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.servletNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.urlPatternTextField, -2, -1, -2)).addContainerGap(103, Short.MAX_VALUE)));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.addInfoCheckBox) {
            this.addInfoCheckBoxActionPerformed(evt);
        } else if (evt.getSource() == this.urlPatternTextField) {
            this.urlPatternTextFieldActionPerformed(evt);
        }
    }

    private void urlPatternTextFieldActionPerformed(ActionEvent evt) {
    }

    private void addInfoCheckBoxActionPerformed(ActionEvent evt) {
        this.servletNameTextField.setEditable(this.addInfoCheckBox.isSelected());
        this.urlPatternTextField.setEditable(this.addInfoCheckBox.isSelected());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.textsUpdated(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textsUpdated(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.textsUpdated(e);
    }

    private void textsUpdated(DocumentEvent e) {
        this.wizardPanel.fireChangeEvent();
        if (this.servletNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange("servletName", null, this.getServletName());
        }
        if (this.urlPatternTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange("urlPattern", null, this.getUrlPattern());
        }
    }
}

