/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.marker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;

public class PackageMarker
implements Marker {
    private static Logger LOGGER = Logger.getLogger(PackageMarker.class.getName());
    private Map markMap = new HashMap();

    @Override
    public MarkMapping[] getMappings() {
        ArrayList<MarkMapping> mappings = new ArrayList<MarkMapping>();
        for (String packageName : this.markMap.keySet()) {
            ClientUtils.SourceCodeSelection markerMethod = new ClientUtils.SourceCodeSelection(packageName, "", "");
            markerMethod.setMarkerMethod(true);
            mappings.add(new MarkMapping(markerMethod, (Mark)this.markMap.get(packageName)));
        }
        return mappings.toArray(new MarkMapping[0]);
    }

    @Override
    public Mark[] getMarks() {
        return new HashSet(this.markMap.values()).toArray(new Mark[0]);
    }

    public void addPackageMark(String packageName, Mark mark, boolean recursive) {
        if (packageName.length() == 0) {
            packageName = "default";
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Marking package " + packageName + " with " + mark.getId());
        }
        this.markMap.put(packageName + (recursive ? ".**" : ".*"), mark);
    }

    public void removePackageMark(String packageName) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Unmarking package " + packageName);
        }
        this.markMap.remove(packageName);
    }

    public void resetPackageMarks() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Unmarking all packages");
        }
        this.markMap.clear();
    }
}

