/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.creator;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.IndexerFieldVersion;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.creator.AbstractIndexCreator;
import org.apache.maven.index.creator.LegacyDocumentUpdater;
import org.apache.maven.index.util.zip.ZipFacade;
import org.apache.maven.index.util.zip.ZipHandle;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=IndexCreator.class, hint="jarContent")
public class JarFileContentsIndexCreator
extends AbstractIndexCreator
implements LegacyDocumentUpdater {
    public static final String ID = "jarContent";
    public static final IndexerField FLD_CLASSNAMES = new IndexerField(MAVEN.CLASSNAMES, IndexerFieldVersion.V3, "classnames", "Artifact Classes (tokenized)", Field.Store.NO, Field.Index.ANALYZED);
    public static final IndexerField FLD_CLASSNAMES_KW = new IndexerField(MAVEN.CLASSNAMES, IndexerFieldVersion.V1, "c", "Artifact Classes (tokenized on newlines only)", Field.Store.YES, Field.Index.ANALYZED);

    public JarFileContentsIndexCreator() {
        super(ID);
    }

    @Override
    public void populateArtifactInfo(ArtifactContext artifactContext) throws IOException {
        ArtifactInfo ai = artifactContext.getArtifactInfo();
        File artifactFile = artifactContext.getArtifact();
        if (artifactFile != null && artifactFile.isFile() && (artifactFile.getName().endsWith(".jar") || artifactFile.getName().endsWith(".war"))) {
            this.updateArtifactInfo(ai, artifactFile);
        }
    }

    @Override
    public void updateDocument(ArtifactInfo ai, Document doc) {
        if (ai.classNames != null) {
            doc.add((Fieldable)FLD_CLASSNAMES_KW.toField(ai.classNames));
            doc.add((Fieldable)FLD_CLASSNAMES.toField(ai.classNames));
        }
    }

    @Override
    public void updateLegacyDocument(ArtifactInfo ai, Document doc) {
        if (ai.classNames != null) {
            String classNames = ai.classNames;
            if (classNames.length() > 0 && classNames.charAt(0) == '/') {
                String[] lines = classNames.split("\\n");
                StringBuilder sb = new StringBuilder();
                for (String line : lines) {
                    sb.append(line.substring(1)).append('\n');
                }
                classNames = sb.toString();
            }
            doc.add((Fieldable)FLD_CLASSNAMES_KW.toField(classNames));
        }
    }

    @Override
    public boolean updateArtifactInfo(Document doc, ArtifactInfo artifactInfo) {
        String names = doc.get(FLD_CLASSNAMES_KW.getKey());
        if (names != null) {
            if (names.length() == 0 || names.charAt(0) == '/') {
                artifactInfo.classNames = names;
            } else {
                String[] lines = names.split("\\n");
                StringBuilder sb = new StringBuilder();
                for (String line : lines) {
                    sb.append('/').append(line).append('\n');
                }
                artifactInfo.classNames = sb.toString();
            }
            return true;
        }
        return false;
    }

    private void updateArtifactInfo(ArtifactInfo ai, File f) throws IOException {
        if (f.getName().endsWith(".jar")) {
            this.updateArtifactInfo(ai, f, null);
        } else if (f.getName().endsWith(".war")) {
            this.updateArtifactInfo(ai, f, "WEB-INF/classes/");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateArtifactInfo(ArtifactInfo ai, File f, String strippedPrefix) throws IOException {
        ZipHandle handle = null;
        try {
            handle = ZipFacade.getZipHandle(f);
            List<String> entries = handle.getEntries();
            StringBuilder sb = new StringBuilder();
            for (String name : entries) {
                int i;
                if (!name.endsWith(".class") || (i = name.indexOf("$")) != -1) continue;
                if (name.charAt(0) != '/') {
                    sb.append('/');
                }
                if (StringUtils.isBlank((String)strippedPrefix)) {
                    sb.append(name.substring(0, name.length() - 6)).append('\n');
                    continue;
                }
                if (!name.startsWith(strippedPrefix) || name.length() <= strippedPrefix.length() + 6) continue;
                sb.append(name.substring(strippedPrefix.length(), name.length() - 6)).append('\n');
            }
            String fieldValue = sb.toString().trim();
            ai.classNames = fieldValue.length() != 0 ? fieldValue : null;
        }
        finally {
            try {
                ZipFacade.close(handle);
            }
            catch (Exception e) {
                this.getLogger().error("Could not close jar file properly.", (Throwable)e);
            }
        }
    }

    public String toString() {
        return ID;
    }

    @Override
    public Collection<IndexerField> getIndexerFields() {
        return Arrays.asList(FLD_CLASSNAMES, FLD_CLASSNAMES_KW);
    }
}

