/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.CharSourceRange;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FullSourceLoc;
import org.clang.basic.LangOptions;
import org.clang.basic.target.TargetInfo;
import org.clang.lex.Lexer;
import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.aliases.ushort;
import org.clank.support.void;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.ConvertUTFGlobals;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public final class LiteralSupportStatics {
    private static final int byteMask = 191;
    private static final int byteMark = 128;
    private static final byte[] firstByteMark = new byte[]{0, 0, -64, -32, -16};

    public static int getCharWidth(char kind, TargetInfo Target) {
        switch (kind) {
            default: {
                throw new llvm_unreachable("Unknown token type!");
            }
            case '\b': 
            case '\n': 
            case '\r': 
            case '\u0010': {
                return Target.getCharWidth();
            }
            case '\t': 
            case '\u000e': {
                return Target.getWCharWidth();
            }
            case '\u000b': 
            case '\u0011': {
                return Target.getChar16Width();
            }
            case '\f': 
            case '\u0012': 
        }
        return Target.getChar32Width();
    }

    public static CharSourceRange MakeCharSourceRange(LangOptions Features, FullSourceLoc TokLoc, char.ptr TokBegin, char.ptr TokRangeBegin, char.ptr TokRangeEnd) {
        int Begin = Lexer.AdvanceToTokenCharacter(TokLoc.getRawEncoding(), TokRangeBegin.$sub((abstract_iterator)TokBegin), TokLoc.getManager(), Features);
        int End = Lexer.AdvanceToTokenCharacter(Begin, TokRangeEnd.$sub((abstract_iterator)TokRangeBegin), TokLoc.getManager(), Features);
        return CharSourceRange.getCharRange((int)Begin, (int)End);
    }

    public static DiagnosticBuilder Diag(DiagnosticsEngine Diags, LangOptions Features, FullSourceLoc TokLoc, char.ptr TokBegin, char.ptr TokRangeBegin, char.ptr TokRangeEnd, int DiagID) {
        int Begin = Lexer.AdvanceToTokenCharacter(TokLoc.getRawEncoding(), TokRangeBegin.$sub((abstract_iterator)TokBegin), TokLoc.getManager(), Features);
        return BasicClangGlobals.$out_DiagnosticBuilder_CharSourceRange((DiagnosticBuilder)Diags.Report(Begin, DiagID), (CharSourceRange)LiteralSupportStatics.MakeCharSourceRange(Features, TokLoc, TokBegin, TokRangeBegin, TokRangeEnd));
    }

    public static int ProcessCharEscape(char.ptr ThisTokBegin, char.ptr ThisTokBuf, char.ptr ThisTokEnd, bool.ref HadError, FullSourceLoc Loc, int CharWidth, DiagnosticsEngine Diags, LangOptions Features) {
        char.ptr EscapeBegin = Native.$tryClone((char.ptr)ThisTokBuf);
        ThisTokBuf.$preInc();
        byte ResultChar = ThisTokBuf.$star();
        ThisTokBuf.$preInc();
        switch (ResultChar) {
            case 34: 
            case 39: 
            case 63: 
            case 92: {
                break;
            }
            case 97: {
                ResultChar = 7;
                break;
            }
            case 98: {
                ResultChar = 8;
                break;
            }
            case 101: {
                if (Diags != null) {
                    BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)LiteralSupportStatics.Diag(Diags, Features, Loc, ThisTokBegin, EscapeBegin, ThisTokBuf, 880), (String)"e").$destroy();
                }
                ResultChar = 27;
                break;
            }
            case 69: {
                if (Diags != null) {
                    BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)LiteralSupportStatics.Diag(Diags, Features, Loc, ThisTokBegin, EscapeBegin, ThisTokBuf, 880), (String)"E").$destroy();
                }
                ResultChar = 27;
                break;
            }
            case 102: {
                ResultChar = 12;
                break;
            }
            case 110: {
                ResultChar = 10;
                break;
            }
            case 114: {
                ResultChar = 13;
                break;
            }
            case 116: {
                ResultChar = 9;
                break;
            }
            case 118: {
                ResultChar = 11;
                break;
            }
            case 120: {
                int CharVal;
                ResultChar = 0;
                if (ThisTokBuf.$eq((Object)ThisTokEnd) || !BasicClangGlobals.isHexDigit((byte)ThisTokBuf.$star())) {
                    if (Diags != null) {
                        BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)LiteralSupportStatics.Diag(Diags, Features, Loc, ThisTokBegin, EscapeBegin, ThisTokBuf, 735), (String)"x").$destroy();
                    }
                    HadError.$set(true);
                    break;
                }
                boolean Overflow = false;
                while (ThisTokBuf.$noteq((Object)ThisTokEnd) && (CharVal = llvm.hexDigitValue((byte)ThisTokBuf.$at(0))) != -1) {
                    if ((ResultChar & 0xF0000000) != 0) {
                        Overflow = true;
                    }
                    ResultChar = (byte)(ResultChar << 4);
                    ResultChar = (byte)(ResultChar | CharVal);
                    ThisTokBuf.$preInc();
                }
                if (CharWidth != 32 && ResultChar >> CharWidth != 0) {
                    Overflow = true;
                    ResultChar = (byte)(ResultChar & -1 >> 32 - CharWidth);
                }
                if (!Overflow || Diags == null) break;
                BasicClangGlobals.$out_DiagnosticBuilder_int((DiagnosticBuilder)LiteralSupportStatics.Diag(Diags, Features, Loc, ThisTokBegin, EscapeBegin, ThisTokBuf, 730), (int)0).$destroy();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                ThisTokBuf.$preDec();
                ResultChar = 0;
                int NumDigits = 0;
                do {
                    ResultChar = (byte)(ResultChar << 3);
                    ResultChar = (byte)(ResultChar | ThisTokBuf.$star() - 48);
                    ThisTokBuf.$preInc();
                } while (ThisTokBuf.$noteq((Object)ThisTokEnd) && ++NumDigits < 3 && ThisTokBuf.$at(0) >= NativePointer.$((char)'0') && ThisTokBuf.$at(0) <= NativePointer.$((char)'7'));
                if (CharWidth == 32 || ResultChar >> CharWidth == 0) break;
                if (Diags != null) {
                    BasicClangGlobals.$out_DiagnosticBuilder_int((DiagnosticBuilder)LiteralSupportStatics.Diag(Diags, Features, Loc, ThisTokBegin, EscapeBegin, ThisTokBuf, 730), (int)1).$destroy();
                }
                ResultChar = (byte)(ResultChar & -1 >> 32 - CharWidth);
                break;
            }
            case 37: 
            case 40: 
            case 91: 
            case 123: {
                if (Diags == null) break;
                BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)LiteralSupportStatics.Diag(Diags, Features, Loc, ThisTokBegin, EscapeBegin, ThisTokBuf, 880), (StringRef)new StringRef(new std.string(1, ResultChar))).$destroy();
                break;
            }
            default: {
                if (Diags == null) break;
                if (BasicClangGlobals.isPrintable((byte)ResultChar)) {
                    BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)LiteralSupportStatics.Diag(Diags, Features, Loc, ThisTokBegin, EscapeBegin, ThisTokBuf, 904), (StringRef)new StringRef(new std.string(1, ResultChar))).$destroy();
                    break;
                }
                BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)LiteralSupportStatics.Diag(Diags, Features, Loc, ThisTokBegin, EscapeBegin, ThisTokBuf, 904), (StringRef)new StringRef(std.$add_T_str((CharSequence)"x", (std.string)llvm.utohexstr((long)ResultChar)))).$destroy();
            }
        }
        return ResultChar;
    }

    public static boolean ProcessUCNEscape(char.ptr ThisTokBegin, char.ptr ThisTokBuf, char.ptr ThisTokEnd, uint.ref UcnVal, ushort.ref UcnLen, FullSourceLoc Loc, DiagnosticsEngine Diags, LangOptions Features) {
        return LiteralSupportStatics.ProcessUCNEscape(ThisTokBegin, ThisTokBuf, ThisTokEnd, UcnVal, UcnLen, Loc, Diags, Features, false);
    }

    public static boolean ProcessUCNEscape(char.ptr ThisTokBegin, char.ptr ThisTokBuf, char.ptr ThisTokEnd, uint.ref UcnVal, ushort.ref UcnLen, FullSourceLoc Loc, DiagnosticsEngine Diags, LangOptions Features, boolean in_char_string_literal) {
        int CharVal;
        char UcnLenSave;
        char.ptr UcnBegin = Native.$tryClone((char.ptr)ThisTokBuf);
        ThisTokBuf.$inc(2);
        if (ThisTokBuf == ThisTokEnd || !BasicClangGlobals.isHexDigit((byte)ThisTokBuf.$star())) {
            if (Diags != null) {
                BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)LiteralSupportStatics.Diag(Diags, Features, Loc, ThisTokBegin, UcnBegin, ThisTokBuf, 735), (StringRef)new StringRef((char.ptr)ThisTokBuf.$sub(1), 1)).$destroy();
            }
            return false;
        }
        UcnLen.$set((char)(ThisTokBuf.$at(-1) == NativePointer.$((char)'u') ? 4 : 8));
        for (UcnLenSave = UcnLen.$deref(); ThisTokBuf.$noteq((Object)ThisTokEnd) && UcnLenSave != '\u0000' && (CharVal = llvm.hexDigitValue((byte)ThisTokBuf.$at(0))) != -1; UcnLenSave = (char)(UcnLenSave - '\u0001')) {
            int _UcnVal = UcnVal.$deref();
            _UcnVal <<= 4;
            UcnVal.$set(_UcnVal |= CharVal);
            ThisTokBuf.$preInc();
        }
        if (UcnLenSave != '\u0000') {
            if (Diags != null) {
                LiteralSupportStatics.Diag(Diags, Features, Loc, ThisTokBegin, UcnBegin, ThisTokBuf, 849).$destroy();
            }
            return false;
        }
        if (55296 <= UcnVal.$deref() && UcnVal.$deref() <= 57343 || UcnVal.$deref() > 0x10FFFF) {
            if (Diags != null) {
                LiteralSupportStatics.Diag(Diags, Features, Loc, ThisTokBegin, UcnBegin, ThisTokBuf, 850).$destroy();
            }
            return false;
        }
        if (UcnVal.$deref() < 160 && UcnVal.$deref() != 36 && UcnVal.$deref() != 64 && UcnVal.$deref() != 96) {
            boolean IsError;
            boolean bl = IsError = !Features.CPlusPlus11 || !in_char_string_literal;
            if (Diags != null) {
                byte BasicSCSChar = (byte)UcnVal.$deref();
                if (UcnVal.$deref() >= 32 && UcnVal.$deref() < 127) {
                    BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)LiteralSupportStatics.Diag(Diags, Features, Loc, ThisTokBegin, UcnBegin, ThisTokBuf, IsError ? 848 : 957), (StringRef)new StringRef(NativePointer.new$char$elem((byte)BasicSCSChar), 1)).$destroy();
                } else {
                    LiteralSupportStatics.Diag(Diags, Features, Loc, ThisTokBegin, UcnBegin, ThisTokBuf, IsError ? 847 : 956).$destroy();
                }
            }
            if (IsError) {
                return false;
            }
        }
        if (!Features.CPlusPlus && !Features.C99 && Diags != null) {
            LiteralSupportStatics.Diag(Diags, Features, Loc, ThisTokBegin, UcnBegin, ThisTokBuf, 1008).$destroy();
        }
        return true;
    }

    public static int MeasureUCNEscape(char.ptr ThisTokBegin, char.ptr ThisTokBuf, char.ptr ThisTokEnd, int CharByteWidth, LangOptions Features, bool.ref HadError) {
        FullSourceLoc Loc;
        ushort.ref UcnLen;
        if (CharByteWidth == 4) {
            return 4;
        }
        uint.ref UcnVal = NativePointer.create_uint$ref((int)0);
        if (!LiteralSupportStatics.ProcessUCNEscape(ThisTokBegin, ThisTokBuf, ThisTokEnd, UcnVal, UcnLen = NativePointer.create_ushort$ref((int)0), Loc = new FullSourceLoc(), null, Features, true)) {
            HadError.$set(true);
            return 0;
        }
        if (CharByteWidth == 2) {
            return UcnVal.$deref() <= 65535 ? 2 : 4;
        }
        if (UcnVal.$deref() < 128) {
            return 1;
        }
        if (UcnVal.$deref() < 2048) {
            return 2;
        }
        if (UcnVal.$deref() < 65536) {
            return 3;
        }
        return 4;
    }

    public static void EncodeUCNEscape(char.ptr ThisTokBegin, char.ptr ThisTokBuf, char.ptr ThisTokEnd, type.ref<char.ptr> ResultBuf, bool.ref HadError, FullSourceLoc Loc, int CharByteWidth, DiagnosticsEngine Diags, LangOptions Features) {
        ushort.ref UcnLen;
        uint.ref UcnVal = NativePointer.create_uint$ref((int)0);
        if (!LiteralSupportStatics.ProcessUCNEscape(ThisTokBegin, ThisTokBuf, ThisTokEnd, UcnVal, UcnLen = NativePointer.create_ushort$ref((int)0), Loc, Diags, Features, true)) {
            HadError.$set(true);
            return;
        }
        assert (CharByteWidth == 1 || CharByteWidth == 2 || CharByteWidth == 4) : "only character widths of 1, 2, or 4 bytes supported";
        assert (UcnLen.$deref() == '\u0004' || UcnLen.$deref() == '\b') : "only ucn length of 4 or 8 supported";
        if (CharByteWidth == 4) {
            uint.ptr ResultPtr = (uint.ptr)Casts.reinterpret_cast(uint.ptr.class, (void.ptr)((void.ptr)ResultBuf.$deref()));
            ResultPtr.$set(UcnVal.$deref());
            ((char.ptr)ResultBuf.$deref()).$inc(4);
            return;
        }
        if (CharByteWidth == 2) {
            ushort.ptr ResultPtr = (ushort.ptr)Casts.reinterpret_cast(ushort.ptr.class, (void.ptr)((void.ptr)ResultBuf.$deref()));
            if (UcnVal.$deref() <= 65535) {
                ResultPtr.$set((char)UcnVal.$deref());
                ((char.ptr)ResultBuf.$deref()).$inc(2);
                return;
            }
            int _UcnVal = UcnVal.$deref();
            ResultPtr.$set((char)(55296 + ((_UcnVal -= 65536) >> 10)));
            ((ushort.ptr)ResultPtr.$add(1)).$set((char)(56320 + (_UcnVal & 0x3FF)));
            ((char.ptr)ResultBuf.$deref()).$inc(4);
            return;
        }
        assert (CharByteWidth == 1) : "UTF-8 encoding is only for 1 byte characters";
        int bytesToWrite = 0;
        bytesToWrite = UcnVal.$deref() < 128 ? 1 : (UcnVal.$deref() < 2048 ? 2 : (UcnVal.$deref() < 65536 ? 3 : 4));
        ((char.ptr)ResultBuf.$deref()).$inc(bytesToWrite);
        int _UcnVal = UcnVal.$deref();
        switch (bytesToWrite) {
            case 4: {
                ((char.ptr)((char.ptr)ResultBuf.$deref()).$preDec()).$set((byte)((_UcnVal | 0x80) & 0xBF));
                _UcnVal >>>= 6;
            }
            case 3: {
                ((char.ptr)((char.ptr)ResultBuf.$deref()).$preDec()).$set((byte)((_UcnVal | 0x80) & 0xBF));
                _UcnVal >>>= 6;
            }
            case 2: {
                ((char.ptr)((char.ptr)ResultBuf.$deref()).$preDec()).$set((byte)((_UcnVal | 0x80) & 0xBF));
                _UcnVal >>>= 6;
            }
            case 1: {
                ((char.ptr)((char.ptr)ResultBuf.$deref()).$preDec()).$set((byte)(_UcnVal | firstByteMark[bytesToWrite]));
            }
        }
        UcnVal.$set(_UcnVal);
        ((char.ptr)ResultBuf.$deref()).$inc(bytesToWrite);
    }

    public static boolean alwaysFitsInto64Bits(int Radix, int NumDigits) {
        switch (Radix) {
            case 2: {
                return NumDigits <= 64;
            }
            case 8: {
                return NumDigits <= 21;
            }
            case 10: {
                return NumDigits <= 19;
            }
            case 16: {
                return NumDigits <= 16;
            }
        }
        llvm.llvm_unreachable_internal((String)"impossible Radix");
        throw new IllegalStateException("impossible Radix");
    }

    public static char.ptr resyncUTF8(char.ptr Err, char.ptr End) {
        if (Err == End) {
            return End;
        }
        End = (char.ptr)Err.$add(std.min((int)ConvertUTFGlobals.getNumBytesForUTF8((byte)Err.$star()), (int)End.$sub((abstract_iterator)Err)));
        while (((char.ptr)Err.$preInc()).$noteq((Object)End) && (Err.$star() & 0xC0) == 128) {
        }
        return Err;
    }

    public static void appendCodePoint(int Codepoint, SmallVectorImplChar Str) {
        byte[] ResultBuf = NativePointer.new$char((int)4, (byte[])new byte[0]);
        type.ref ResultPtr = NativePointer.create_type$ref((Object)NativePointer.create_char$ptr((byte[])ResultBuf));
        boolean Res = llvm.ConvertCodePointToUTF8((int)Codepoint, (type.ref)ResultPtr);
        assert (Res) : "Unexpected conversion failure";
        Str.append(ResultBuf, 0, ((char.ptr)ResultPtr.$deref()).$index() + 1);
    }
}

