/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

class URLUtils {
    private static final Logger LOG = Logger.getLogger(URLUtils.class.getName());

    private URLUtils() {
    }

    public static InputStream openStream(URL url) throws IOException {
        FileObject f;
        if (url.getProtocol().equals("jar") && (f = URLMapper.findFileObject((URL)url)) != null) {
            return f.getInputStream();
        }
        if (url.getProtocol().startsWith("http")) {
            LOG.log(Level.FINE, "opening network stream: {0}", url);
        }
        return url.openStream();
    }

    public static InputStream open(URL base, String ... specs) {
        for (String spec : specs) {
            try {
                URL url = new URL(base, spec);
                try {
                    return URLUtils.openStream(url);
                }
                catch (IOException x) {
                    LOG.log(Level.FINE, "Could not open " + url, x);
                }
            }
            catch (MalformedURLException x) {
                LOG.log(Level.INFO, "Could not construct " + base + spec, x);
            }
        }
        return null;
    }

    public static URL findOpenable(URL base, String ... specs) {
        for (String spec : specs) {
            try {
                URL url = new URL(base, spec);
                try {
                    URLUtils.openStream(url).close();
                    return url;
                }
                catch (IOException x) {
                    LOG.log(Level.FINE, "Could not open " + url, x);
                }
                catch (Exception x) {
                    LOG.log(Level.INFO, "Could not open " + url, x);
                }
            }
            catch (MalformedURLException x) {
                LOG.log(Level.INFO, "Could not construct " + base + spec, x);
            }
        }
        return null;
    }

    public static String getDisplayName(URL url) {
        FileObject fo = URLMapper.findFileObject((URL)url);
        return fo != null ? FileUtil.getFileDisplayName((FileObject)fo) : url.toString();
    }
}

