/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.includes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionUtils;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CompletionSupport;
import org.netbeans.modules.cnd.completion.includes.CsmIncludeCompletionItem;
import org.netbeans.modules.cnd.completion.includes.CsmIncludeCompletionQuery;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public class CsmIncludeCompletionProvider
implements CompletionProvider {
    private static final boolean TRACE = Boolean.getBoolean("cnd.completion.includes.trace");

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        CompletionSupport sup = CompletionSupport.get(component);
        if (sup == null) {
            return 0;
        }
        String[] triggers = CsmCompletionUtils.getPreprocAutoCompletionTrigers();
        if (!CompletionSupport.needShowCompletionOnTextLite(component, typedText, triggers)) {
            return 0;
        }
        if (CompletionSupport.needShowCompletionOnText(component, typedText, triggers)) {
            int dot = component.getCaret().getDot();
            if (TRACE) {
                System.err.println("offset " + dot);
            }
            if (CompletionSupport.isIncludeCompletionEnabled(component.getDocument(), dot)) {
                if (TRACE) {
                    System.err.println("include completion will be shown on " + dot);
                }
                return 1;
            }
            if (TRACE) {
                System.err.println("include completion will NOT be shown on " + dot);
            }
        }
        return 0;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (TRACE) {
            System.err.println("queryType = " + queryType);
        }
        if ((queryType & 1) != 0) {
            boolean all = queryType == 9;
            int dot = component.getCaret().getDot();
            if (CompletionSupport.isIncludeCompletionEnabled(component.getDocument(), dot)) {
                if (TRACE) {
                    System.err.println("include completion task is created with offset " + dot);
                }
                return new AsyncCompletionTask((AsyncCompletionQuery)new Query(dot, all), component);
            }
            if (TRACE) {
                System.err.println("include completion task is NOT created on " + dot);
            }
        }
        return null;
    }

    static Collection<CsmIncludeCompletionItem> getFilteredData(BaseDocument doc, int caretOffset, int queryType) {
        Query query = new Query(caretOffset, true);
        Collection items = query.getItems(doc, caretOffset);
        items = query.getFilteredData(items, query.filterPrefix);
        if (TRACE) {
            System.err.println("Completion Items " + items.size());
            for (CsmIncludeCompletionItem completionItem : items) {
                System.err.println(completionItem.toString());
            }
        }
        return items;
    }

    private static final class Query
    extends AsyncCompletionQuery {
        private JTextComponent component;
        private Collection<CsmIncludeCompletionItem> results;
        private int creationCaretOffset;
        private int resultSetAnchorOffset;
        private int queryAnchorOffset;
        private int queryAnchorOffsetDelta;
        private String dirPrefix;
        private String filterPrefix;
        private Boolean usrInclude;
        private boolean showAll;
        private boolean caseSensitive;

        Query(int caretOffset, boolean showAll) {
            this.creationCaretOffset = caretOffset;
            this.queryAnchorOffset = -1;
            this.resultSetAnchorOffset = this.creationCaretOffset;
            this.showAll = showAll;
            this.caseSensitive = false;
        }

        protected void preQueryUpdate(JTextComponent component) {
            int caretOffset = component.getCaretPosition();
            if (TRACE) {
                System.err.println("preQueryUpdate on " + caretOffset + " created on " + this.creationCaretOffset);
            }
            Document doc = component.getDocument();
            if (this.creationCaretOffset > 0 && caretOffset >= this.creationCaretOffset) {
                try {
                    if (this.isValidIncludeNamePart(doc.getText(this.creationCaretOffset, caretOffset - this.creationCaretOffset))) {
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            Completion.get().hideCompletion();
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            if (TRACE) {
                System.err.println("query on " + caretOffset + " anchor " + this.queryAnchorOffset);
            }
            Collection<CsmIncludeCompletionItem> items = this.getItems((BaseDocument)doc, caretOffset);
            if (this.queryAnchorOffset > 0) {
                if (items != null && items.size() > 0) {
                    this.caseSensitive = this.isCaseSensitive(this.component);
                    this.results = items;
                    items = this.getFilteredData(items, this.filterPrefix);
                    resultSet.estimateItems(items.size(), -1);
                    resultSet.addAllItems(items);
                    resultSet.setAnchorOffset(this.resultSetAnchorOffset);
                }
                resultSet.setHasAdditionalItems(true);
            }
            resultSet.finish();
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        protected boolean canFilter(JTextComponent component) {
            int caretOffset = component.getCaretPosition();
            Document doc = component.getDocument();
            this.filterPrefix = null;
            String oldDir = this.dirPrefix;
            this.dirPrefix = "";
            if (this.queryAnchorOffset > -1 && caretOffset > this.queryAnchorOffset) {
                try {
                    String typedText = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
                    if (this.isValidIncludeNamePart(typedText)) {
                        this.filterPrefix = typedText;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            this.fixFilter();
            if (TRACE) {
                System.err.println("canFilter INCINFO: usrInclude=" + this.usrInclude + " anchorOffset=" + this.queryAnchorOffset + " oldDir=" + oldDir + " dirPrefix=" + this.dirPrefix + " filterPrefix=" + this.filterPrefix);
            }
            return this.filterPrefix != null && oldDir.equals(this.dirPrefix);
        }

        protected void filter(CompletionResultSet resultSet) {
            if (this.filterPrefix != null && this.results != null) {
                resultSet.setAnchorOffset(this.resultSetAnchorOffset);
                Collection<CsmIncludeCompletionItem> items = this.getFilteredData(this.results, this.filterPrefix);
                resultSet.estimateItems(items.size(), -1);
                resultSet.addAllItems(items);
            }
            resultSet.setHasAdditionalItems(true);
            resultSet.finish();
        }

        private void fixFilter() {
            String pref = this.filterPrefix;
            if (pref != null) {
                int slash;
                int origSlash = pref.lastIndexOf("/");
                this.resultSetAnchorOffset = this.queryAnchorOffset;
                if (origSlash != -1) {
                    this.resultSetAnchorOffset += origSlash + 1;
                }
                if ((slash = (pref = this.trimIncludeSigns(pref)).lastIndexOf("/")) != -1) {
                    this.dirPrefix = pref.substring(0, slash + 1);
                    pref = pref.substring(slash + 1);
                }
                this.filterPrefix = pref;
            }
        }

        private Collection<CsmIncludeCompletionItem> getItems(BaseDocument doc, int caretOffset) {
            Collection<CsmIncludeCompletionItem> items = Collections.emptyList();
            try {
                if (this.init(doc, caretOffset)) {
                    CsmIncludeCompletionQuery query = new CsmIncludeCompletionQuery(null);
                    items = query.query(doc, this.dirPrefix, this.queryAnchorOffset, this.queryAnchorOffsetDelta, this.usrInclude, this.showAll);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return items;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean init(BaseDocument doc, int caretOffset) throws BadLocationException {
            block16: {
                this.resultSetAnchorOffset = caretOffset;
                this.filterPrefix = null;
                this.queryAnchorOffset = -1;
                this.usrInclude = null;
                this.dirPrefix = "";
                if (doc != null) {
                    doc.readLock();
                    try {
                        TokenId id2;
                        TokenItem tok = CndTokenUtilities.getTokenCheckPrev((Document)doc, (int)caretOffset);
                        if (tok == null) break block16;
                        TokenId id = tok.id();
                        if (id instanceof CppTokenId) {
                            switch ((CppTokenId)id) {
                                case PREPROCESSOR_SYS_INCLUDE: {
                                    this.usrInclude = Boolean.FALSE;
                                    this.queryAnchorOffset = tok.offset();
                                    this.filterPrefix = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
                                    break;
                                }
                                case PREPROCESSOR_USER_INCLUDE: {
                                    this.usrInclude = Boolean.TRUE;
                                    this.queryAnchorOffset = tok.offset();
                                    this.filterPrefix = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
                                    if (tok.partType() != PartType.COMPLETE && tok.partType() != PartType.START) break;
                                    ++this.queryAnchorOffset;
                                    this.queryAnchorOffsetDelta = -1;
                                    break;
                                }
                                case PREPROCESSOR_IDENTIFIER: {
                                    this.usrInclude = Boolean.TRUE;
                                    this.queryAnchorOffset = tok.offset();
                                    this.filterPrefix = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
                                    break;
                                }
                            }
                        }
                        if (this.queryAnchorOffset < 0 && "whitespace".equals(tok.id().primaryCategory()) && (tok = CndTokenUtilities.getFirstNonWhiteBwd((Document)doc, (int)caretOffset)) != null && (id2 = tok.id()) instanceof CppTokenId) {
                            switch ((CppTokenId)id2) {
                                case PREPROCESSOR_INCLUDE: 
                                case PREPROCESSOR_INCLUDE_NEXT: {
                                    this.usrInclude = null;
                                    this.queryAnchorOffset = caretOffset;
                                    this.filterPrefix = null;
                                    break;
                                }
                                default: {
                                    break;
                                }
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                    }
                    finally {
                        doc.readUnlock();
                    }
                }
            }
            this.fixFilter();
            if (TRACE) {
                System.err.println("INCINFO: usrInclude=" + this.usrInclude + " anchorOffset=" + this.queryAnchorOffset + " dirPrefix=" + this.dirPrefix + " filterPrefix=" + this.filterPrefix);
            }
            if (this.queryAnchorOffset <= 0) return false;
            return true;
        }

        private boolean isCaseSensitive(JTextComponent component) {
            return CsmCompletionUtils.isCaseSensitive(CsmCompletionUtils.getMimeType(component));
        }

        private String trimIncludeSigns(String str) {
            if (str.startsWith("\"") || str.startsWith("<")) {
                str = str.substring(1);
            }
            if (str.endsWith("\"") || str.endsWith(">")) {
                str = str.substring(0, str.length() - 1);
            }
            return str;
        }

        private boolean isValidIncludeNamePart(String text) {
            if (text == null || text.length() == 0) {
                return true;
            }
            if (text.length() == 1) {
                if (text.startsWith("\"")) {
                    return true;
                }
                if (text.startsWith("<")) {
                    return this.usrInclude == Boolean.FALSE;
                }
            }
            return !text.endsWith("\"") && !text.endsWith(">");
        }

        private Collection<CsmIncludeCompletionItem> getFilteredData(Collection<CsmIncludeCompletionItem> data, String prefix) {
            Collection<CsmIncludeCompletionItem> out;
            if (prefix == null) {
                out = data;
            } else {
                ArrayList<CsmIncludeCompletionItem> ret = new ArrayList<CsmIncludeCompletionItem>(data.size());
                for (CsmIncludeCompletionItem itm : data) {
                    if (!this.matchPrefix(itm, prefix)) continue;
                    ret.add(itm);
                }
                out = ret;
            }
            return out;
        }

        private boolean matchPrefix(CsmIncludeCompletionItem itm, String prefix) {
            String item = itm.getItemText();
            if (!this.caseSensitive) {
                item = item.toLowerCase(Locale.getDefault());
                prefix = prefix.toLowerCase(Locale.getDefault());
            }
            return item.startsWith(prefix);
        }
    }
}

