/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetUtils;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.makeproject.api.BuildActionsProvider;
import org.netbeans.modules.cnd.makeproject.api.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.api.wizards.PreBuildSupport;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.spi.toolchain.CompilerLineConvertor;
import org.netbeans.modules.cnd.spi.utils.CndNotifier;
import org.netbeans.modules.cnd.toolchain.support.ToolchainUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.NativeProcessChangeEvent;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionDescriptor;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionService;
import org.netbeans.modules.nativeexecution.api.execution.PostMessageDisplayer;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminalProvider;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public class DefaultProjectActionHandler
implements ProjectActionHandler {
    private ProjectActionEvent pae;
    private Collection<BuildActionsProvider.OutputStreamHandler> outputHandlers;
    private volatile Future<Integer> executorTask;
    private final List<ExecutionListener> listeners = new CopyOnWriteArrayList<ExecutionListener>();
    private static final boolean RUN_REMOTE_IN_OUTPUT_WINDOW = false;
    private static final RequestProcessor RP = new RequestProcessor("DefaultProjectActionHandler", 1);

    @Override
    public void init(ProjectActionEvent pae, ProjectActionEvent[] paes, Collection<BuildActionsProvider.OutputStreamHandler> outputHandlers) {
        this.pae = pae;
        this.outputHandlers = outputHandlers;
    }

    @Override
    public void execute(InputOutput io) {
        ExecutionListener listener = new ExecutionListener(){

            public void executionStarted(int pid) {
                DefaultProjectActionHandler.this.listeners.forEach(l -> l.executionStarted(pid));
            }

            public void executionFinished(int rc) {
                DefaultProjectActionHandler.this.listeners.forEach(l -> l.executionFinished(rc));
            }
        };
        Runnable executor = () -> {
            try {
                this._execute(io, listener);
            }
            catch (Throwable th) {
                try {
                    if (io != null && io.getErr() != null) {
                        io.getErr().println("Internal error occured. Please report a bug.", null, true);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace(System.err);
                }
                try {
                    if (io != null && io.getOut() != null) {
                        io.getOut().close();
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace(System.err);
                }
                listener.executionFinished(-1);
                throw new RuntimeException(th);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            RP.post(executor);
        } else {
            executor.run();
        }
    }

    private void _execute(InputOutput io, ExecutionListener listener) {
        Project p;
        String workingDirectory;
        ProjectActionEvent.Type actionType = this.pae.getType();
        if (actionType != ProjectActionEvent.PredefinedType.RUN && actionType != ProjectActionEvent.PredefinedType.PRE_BUILD && actionType != ProjectActionEvent.PredefinedType.BUILD && actionType != ProjectActionEvent.PredefinedType.COMPILE_SINGLE && actionType != ProjectActionEvent.PredefinedType.CLEAN && actionType != ProjectActionEvent.PredefinedType.BUILD_TESTS && actionType != ProjectActionEvent.PredefinedType.TEST) assert (false);
        String origRunDir = this.pae.getProfile().getRunDir();
        boolean preventRunPathConvertion = origRunDir.startsWith("///");
        String runDirectory = RemoteFileUtil.normalizeAbsolutePath((String)this.pae.getProfile().getRunDirectory(), (Project)this.pae.getProject());
        MakeConfiguration conf = this.pae.getConfiguration();
        PlatformInfo pi = conf.getPlatformInfo();
        ExecutionEnvironment execEnv = conf.getDevelopmentHost().getExecutionEnvironment();
        CompilerSet cs = conf.getCompilerSet().getCompilerSet();
        Map<String, String> env = this.pae.getProfile().getEnvironment().getenvAsMap();
        boolean showInput = actionType == ProjectActionEvent.PredefinedType.RUN;
        boolean unbuffer = false;
        boolean statusEx = false;
        String commandLine = null;
        int consoleType = this.pae.getProfile().getConsoleType().getValue();
        ArrayList<String> args = null;
        if (actionType == ProjectActionEvent.PredefinedType.RUN) {
            boolean runInExternalTerminal;
            statusEx = true;
            boolean runInInternalTerminal = consoleType == 3;
            boolean bl = runInExternalTerminal = consoleType == 1;
            if (runInExternalTerminal && (this.pae.getProfile().getTerminalType() == null || this.pae.getProfile().getTerminalPath() == null)) {
                String errmsg = Utilities.isMac() ? DefaultProjectActionHandler.getString("Err_NoTermFoundMacOSX") : DefaultProjectActionHandler.getString("Err_NoTermFound");
                CndNotifier.getDefault().notifyInfo(errmsg);
                consoleType = 2;
                runInInternalTerminal = false;
                runInExternalTerminal = false;
            }
            if (!conf.getDevelopmentHost().isLocalhost() && runInExternalTerminal) {
                consoleType = RunProfile.getDefaultConsoleType();
                boolean bl2 = runInInternalTerminal = 3 == consoleType;
            }
            if (consoleType == 2) {
                unbuffer = true;
            } else if (!runInInternalTerminal) {
                showInput = false;
                if (consoleType == 0) {
                    consoleType = RunProfile.getDefaultConsoleType();
                }
            }
            if (conf.getPrependToolCollectionPath().getValue() && cs != null && env.get("__CND_TOOL_WRAPPER__") == null) {
                ToolchainUtilities.modifyPathEnvVariable((ExecutionEnvironment)execEnv, env, (CompilerSet)cs, (String)"run");
            }
            commandLine = this.pae.getRunCommandAsString();
        } else {
            String executable;
            String baseName;
            if (conf.getPrependToolCollectionPath().getValue() && env.get("__CND_TOOL_WRAPPER__") == null) {
                ToolchainUtilities.modifyPathEnvVariable((ExecutionEnvironment)execEnv, env, (CompilerSet)cs, (String)"build");
            }
            if (conf.isQmakeConfiguration()) {
                String qmakePath = cs.getTool((ToolKind)PredefinedToolKind.QMakeTool).getPath();
                qmakePath = CppUtils.normalizeDriveLetter(cs, qmakePath.replace('\\', '/'));
                args = this.pae.getArguments();
                args.add("QMAKE=" + CndPathUtilities.escapeOddCharacters((String)qmakePath));
            }
            if (conf.isMakefileConfiguration() && !"${AUTO_COMPILE}".equals(conf.getCompileConfiguration().getCompileCommand().getValue())) {
                commandLine = this.pae.getRunCommandAsString();
            }
            if (conf.getDevelopmentHost().isLocalhost() && Utilities.isWindows() && CompilerSetUtils.isMsysBased((CompilerSet)cs) && (baseName = CndPathUtilities.getBaseName((String)(executable = this.pae.getExecutable()))).startsWith("make")) {
                env.put("MAKE", WindowsSupport.getInstance().convertToMSysPath(this.pae.getExecutable()));
            }
        }
        CompilerLineConvertor converter = null;
        if (actionType == ProjectActionEvent.PredefinedType.BUILD || actionType == ProjectActionEvent.PredefinedType.COMPILE_SINGLE || actionType == ProjectActionEvent.PredefinedType.BUILD_TESTS) {
            converter = new CompilerLineConvertor(this.pae.getProject(), conf.getCompilerSet().getCompilerSet(), execEnv, RemoteFileUtil.getFileObject((String)runDirectory, (Project)this.pae.getProject()), io);
        }
        env.put("SPRO_EXPAND_ERRORS", "");
        String string = workingDirectory = preventRunPathConvertion ? runDirectory : ProjectSupport.convertWorkingDirToRemoteIfNeeded(this.pae, runDirectory);
        if (workingDirectory == null) {
            // empty if block
        }
        WriterRedirector writer = null;
        if (this.outputHandlers != null && this.outputHandlers.size() > 0) {
            writer = new WriterRedirector(this.outputHandlers);
        }
        ProcessChangeListener processChangeListener = new ProcessChangeListener(listener, writer, (LineConvertor)converter, io);
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv).setWorkingDirectory(workingDirectory).unbufferOutput(unbuffer).setStatusEx(statusEx).addNativeProcessListener((ChangeListener)processChangeListener);
        StringBuilder buf = new StringBuilder();
        if (commandLine != null) {
            buf.append(commandLine);
            npb.setCommandLine(commandLine);
        } else {
            String exe = this.getExecutable(cs);
            if (args == null) {
                args = this.pae.getArguments();
            }
            if (actionType == ProjectActionEvent.PredefinedType.PRE_BUILD) {
                ArrayList<String> expandedArgs = new ArrayList<String>();
                for (String s : args) {
                    expandedArgs.add(PreBuildSupport.expandMacros(s, cs, env));
                }
                args = expandedArgs;
            }
            npb.setExecutable(exe).setArguments(args.toArray(new String[args.size()]));
            buf.append(exe);
            for (String a : args) {
                buf.append(' ');
                buf.append(a);
            }
        }
        if (actionType == ProjectActionEvent.PredefinedType.PRE_BUILD || actionType == ProjectActionEvent.PredefinedType.BUILD || actionType == ProjectActionEvent.PredefinedType.BUILD_TESTS) {
            npb.redirectError();
        }
        npb.getEnvironment().putAll(env);
        if ((actionType == ProjectActionEvent.PredefinedType.RUN || actionType == ProjectActionEvent.PredefinedType.DEBUG) && ServerList.get((ExecutionEnvironment)execEnv).getX11Forwarding() && !env.containsKey("DISPLAY")) {
            npb.setX11Forwarding(true);
        }
        if (actionType == ProjectActionEvent.PredefinedType.RUN && consoleType == 1) {
            String termPath = this.pae.getProfile().getTerminalPath();
            CndUtils.assertNotNull((Object)termPath, (String)"null terminal path");
            if (termPath != null) {
                String termBaseName = CndPathUtilities.getBaseName((String)termPath);
                if (ExternalTerminalProvider.getSupportedTerminalIDs().contains(termBaseName)) {
                    npb.useExternalTerminal(ExternalTerminalProvider.getTerminal((ExecutionEnvironment)execEnv, (String)termBaseName));
                }
            }
        }
        boolean requestFocus = actionType == ProjectActionEvent.PredefinedType.RUN || actionType == ProjectActionEvent.PredefinedType.DEBUG || actionType == ProjectActionEvent.PredefinedType.DEBUG_STEPINTO || actionType == ProjectActionEvent.PredefinedType.DEBUG_TEST || actionType == ProjectActionEvent.PredefinedType.DEBUG_STEPINTO_TEST || actionType == ProjectActionEvent.PredefinedType.CUSTOM_ACTION;
        NativeExecutionDescriptor descr = new NativeExecutionDescriptor().controllable(true).frontWindow(true).requestFocus(requestFocus).inputVisible(showInput).inputOutput(io).outLineBased(!unbuffer).showProgress(false).postMessageDisplayer((PostMessageDisplayer)new PostMessageDisplayer.Default(this.pae.getActionName())).postExecution((Runnable)processChangeListener).errConvertorFactory((ExecutionDescriptor.LineConvertorFactory)processChangeListener).outConvertorFactory((ExecutionDescriptor.LineConvertorFactory)processChangeListener).keepInputOutputOnFinish();
        if (actionType == ProjectActionEvent.PredefinedType.PRE_BUILD || actionType == ProjectActionEvent.PredefinedType.BUILD || actionType == ProjectActionEvent.PredefinedType.COMPILE_SINGLE || actionType == ProjectActionEvent.PredefinedType.CLEAN) {
            descr.noReset(true);
            if (cs != null) {
                descr.charset(cs.getEncoding());
            }
        }
        if (actionType == ProjectActionEvent.PredefinedType.RUN && (p = this.pae.getProject()) instanceof MakeProject) {
            descr.charset(Charset.forName(((MakeProject)p).getSourceEncoding()));
        }
        if (actionType == ProjectActionEvent.PredefinedType.PRE_BUILD || actionType == ProjectActionEvent.PredefinedType.COMPILE_SINGLE || actionType == ProjectActionEvent.PredefinedType.BUILD || actionType == ProjectActionEvent.PredefinedType.CLEAN) {
            if (io != null && io.getOut() != null) {
                io.getOut().println("cd '" + workingDirectory + "'");
                io.getOut().println(buf.toString());
            } else {
                System.out.println("cd '" + workingDirectory + "'");
                System.out.println(buf.toString());
            }
        }
        NativeExecutionService es = NativeExecutionService.newService((NativeProcessBuilder)npb, (NativeExecutionDescriptor)descr, (String)this.pae.getActionName());
        this.executorTask = es.run();
    }

    private String getExecutable(CompilerSet cs) {
        String executable = this.pae.getExecutable();
        if (executable.contains("cmake") && DefaultProjectActionHandler.isCygwinCompilerSet(cs)) {
            return PreBuildSupport.getCmakePath(cs);
        }
        return executable;
    }

    @Override
    public void addExecutionListener(ExecutionListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeExecutionListener(ExecutionListener l) {
        this.listeners.remove(l);
    }

    @Override
    public boolean canCancel() {
        return true;
    }

    @Override
    public void cancel() {
        RP.post(() -> {
            Future<Integer> et = this.executorTask;
            if (et != null) {
                et.cancel(true);
            }
        });
    }

    private static String getString(String s) {
        return NbBundle.getMessage(DefaultProjectActionHandler.class, (String)s);
    }

    protected static String getString(String key, String ... a1) {
        return NbBundle.getMessage(DefaultProjectActionHandler.class, (String)key, (Object[])a1);
    }

    private static boolean isCygwinCompilerSet(CompilerSet compilerSet) {
        CompilerFlavor flavor = compilerSet.getCompilerFlavor();
        return flavor.isCygwinCompiler();
    }

    private static final class MacroConverter {
        private final MacroExpanderFactory.MacroExpander expander;
        private final Map<String, String> envVariables;
        private String homeDir;

        public MacroConverter(ExecutionEnvironment env, Map<String, String> envVariables) {
            this.envVariables = new HashMap<String, String>(envVariables);
            if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env)) {
                try {
                    HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
                    this.envVariables.putAll(hostInfo.getEnvironment());
                    this.homeDir = hostInfo.getUserDir();
                }
                catch (IOException | ConnectionManager.CancellationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.expander = MacroExpanderFactory.getExpander((ExecutionEnvironment)env, (boolean)false);
        }

        private void updateUtilitiesPath(String utilitiesPath) {
            this.envVariables.put("UTILITIES_PATH", utilitiesPath);
        }

        private void updateToolPath(String toolPath) {
            this.envVariables.put("TOOLS_PATH", toolPath);
        }

        public String expand(String in) {
            try {
                if (this.homeDir != null) {
                    if (in.startsWith("~")) {
                        in = this.homeDir + in.substring(1);
                    }
                    in = in.replace(":~", ":" + this.homeDir);
                    in = in.replace(";~", ";" + this.homeDir);
                }
                return this.expander != null ? this.expander.expandMacros(in, this.envVariables) : in;
            }
            catch (ParseException parseException) {
                return in;
            }
        }
    }

    private static final class WriterRedirector
    extends Writer {
        private final Collection<BuildActionsProvider.OutputStreamHandler> handlers;

        WriterRedirector(Collection<BuildActionsProvider.OutputStreamHandler> handlers) {
            this.handlers = handlers;
        }

        @Override
        public void write(String line) throws IOException {
            this.handlers.forEach(outputStreamHandler -> outputStreamHandler.handleLine(line));
        }

        @Override
        public void flush() throws IOException {
            this.handlers.forEach(outputStreamHandler -> outputStreamHandler.flush());
        }

        @Override
        public void close() throws IOException {
            this.handlers.forEach(outputStreamHandler -> outputStreamHandler.close());
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static final class ProcessChangeListener
    implements ChangeListener,
    Runnable,
    ExecutionDescriptor.LineConvertorFactory {
        private final AtomicReference<NativeProcess> processRef = new AtomicReference();
        private final ExecutionListener listener;
        private Writer outputListener;
        private final LineConvertor lineConvertor;

        public ProcessChangeListener(ExecutionListener listener, Writer outputListener, LineConvertor lineConvertor, InputOutput tab) {
            this.listener = listener;
            this.outputListener = outputListener;
            this.lineConvertor = lineConvertor;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!(e instanceof NativeProcessChangeEvent)) {
                return;
            }
            NativeProcessChangeEvent event = (NativeProcessChangeEvent)e;
            this.processRef.compareAndSet(null, (NativeProcess)event.getSource());
            if (event.state == NativeProcess.State.RUNNING && this.listener != null) {
                this.listener.executionStarted(event.pid);
            }
        }

        @Override
        public void run() {
            this.closeOutputListener();
            NativeProcess process = this.processRef.get();
            if (process != null && this.listener != null) {
                this.listener.executionFinished(process.exitValue());
            }
        }

        public LineConvertor newLineConvertor() {
            return this::convert;
        }

        private synchronized void closeOutputListener() {
            if (this.outputListener != null) {
                try {
                    this.outputListener.flush();
                    this.outputListener.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                this.outputListener = null;
            }
            if (this.lineConvertor instanceof ChangeListener) {
                ((ChangeListener)this.lineConvertor).stateChanged(new ChangeEvent(this));
            }
        }

        private synchronized List<ConvertedLine> convert(String line) {
            if (this.outputListener != null) {
                try {
                    this.outputListener.write(line);
                    this.outputListener.write("\n");
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (this.lineConvertor != null) {
                return this.lineConvertor.convert(line);
            }
            return null;
        }
    }
}

