/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.makeproject.MakeActionProviderImpl;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;

public class ProjectSupport {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");

    private ProjectSupport() {
    }

    public static boolean saveAllProjects(String extraMessage) {
        boolean ok = true;
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < openProjects.length; ++i) {
            MakeConfigurationDescriptor projectDescriptor = MakeConfigurationDescriptor.getMakeConfigurationDescriptor((Lookup.Provider)openProjects[i]);
            if (projectDescriptor == null) continue;
            ok = ok && projectDescriptor.save(extraMessage);
        }
        return ok;
    }

    public static Date lastModified(Project project) {
        FileObject projectFile = null;
        try {
            char separator = FileSystemProvider.getFileSeparatorChar((FileSystem)project.getProjectDirectory().getFileSystem());
            projectFile = project.getProjectDirectory().getFileObject("nbproject" + separator + "Makefile-impl.mk");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (projectFile == null) {
            projectFile = project.getProjectDirectory();
        }
        return projectFile.lastModified();
    }

    public static void executeCustomAction(Project project, ProjectActionHandler customProjectActionHandler) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp == null) {
            return;
        }
        MakeConfigurationDescriptor projectDescriptor = pdp.getConfigurationDescriptor();
        MakeConfiguration conf = projectDescriptor.getActiveConfiguration();
        if (conf == null) {
            return;
        }
        MakeActionProviderImpl ap = (MakeActionProviderImpl)project.getLookup().lookup(MakeActionProviderImpl.class);
        if (ap == null) {
            return;
        }
        ap.invokeCustomAction(projectDescriptor, conf, customProjectActionHandler);
    }

    public static MakeProjectOptions.PathMode getPathMode(Project project) {
        return MakeProjectOptions.getPathMode();
    }

    public static String toProperPath(FileObject base, FileObject path, Project project) {
        return ProjectSupport.toProperPath(base, path, ProjectSupport.getPathMode(project));
    }

    public static String toProperPath(FileObject base, String path, Project project) {
        return ProjectSupport.toProperPath(base, path, ProjectSupport.getPathMode(project));
    }

    public static String toProperPath(FSPath base, String path, Project project) {
        return ProjectSupport.toProperPath(base, path, ProjectSupport.getPathMode(project));
    }

    public static String toProperPath(FileObject base, FileObject path, MakeProjectOptions.PathMode pathMode) {
        switch (pathMode) {
            case REL_OR_ABS: {
                return CndPathUtilities.toAbsoluteOrRelativePath((FileObject)base, (FileObject)path);
            }
            case REL: {
                return CndPathUtilities.toRelativePath((FileObject)base, (FileObject)path);
            }
            case ABS: {
                try {
                    return CndFileUtils.getCanonicalPath((FileObject)path);
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                    return path.getPath();
                }
            }
        }
        throw new IllegalStateException("Unexpected path mode: " + (Object)((Object)pathMode));
    }

    public static String toProperPath(FileObject base, String path, MakeProjectOptions.PathMode pathMode) {
        switch (pathMode) {
            case REL_OR_ABS: {
                return CndPathUtilities.toAbsoluteOrRelativePath((FileObject)base, (String)path);
            }
            case REL: {
                return CndPathUtilities.toRelativePath((FileObject)base, (String)path);
            }
            case ABS: {
                return CndPathUtilities.toAbsolutePath((FileObject)base, (String)path);
            }
        }
        throw new IllegalStateException("Unexpected path mode: " + (Object)((Object)pathMode));
    }

    public static String toProperPath(FSPath base, String path, MakeProjectOptions.PathMode pathMode) {
        switch (pathMode) {
            case REL_OR_ABS: {
                return CndPathUtilities.toAbsoluteOrRelativePath((String)base.getPath(), (String)path);
            }
            case REL: {
                return CndPathUtilities.toRelativePath((String)base.getPath(), (String)path);
            }
            case ABS: {
                return CndPathUtilities.toAbsolutePath((FSPath)base, (String)path);
            }
        }
        throw new IllegalStateException("Unexpected path mode: " + (Object)((Object)pathMode));
    }

    public static String convertWorkingDirToRemoteIfNeeded(ProjectActionEvent pae, String localDir) {
        ExecutionEnvironment execEnv = pae.getConfiguration().getDevelopmentHost().getExecutionEnvironment();
        if (!ProjectSupport.checkConnection(execEnv)) {
            return null;
        }
        if (execEnv.isRemote()) {
            RemoteSyncFactory remoteSyncFactory = pae.getConfiguration().getRemoteSyncFactory();
            PathMap mapper = remoteSyncFactory.getPathMap(execEnv);
            if (mapper != null) {
                String aLocalDir = mapper.getRemotePath(localDir, false);
                if (aLocalDir != null) {
                    localDir = aLocalDir;
                }
            } else {
                LOGGER.log(Level.SEVERE, "Path Mapper not found for project {0} - using local path {1}", new Object[]{pae.getProject(), localDir});
            }
            return localDir;
        }
        return localDir;
    }

    public static boolean checkConnection(ExecutionEnvironment execEnv) {
        if (execEnv.isRemote()) {
            try {
                ConnectionManager.getInstance().connectTo(execEnv);
                ServerRecord record = ServerList.get((ExecutionEnvironment)execEnv);
                if (record.isOffline()) {
                    record.validate(true);
                }
                return record.isOnline();
            }
            catch (IOException ex) {
                return false;
            }
            catch (ConnectionManager.CancellationException ex) {
                return false;
            }
        }
        return true;
    }
}

