/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerFileElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LinkerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Platform;
import org.netbeans.modules.cnd.makeproject.api.configurations.Platforms;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.packaging.DummyPackager;
import org.netbeans.modules.cnd.utils.CndPathUtilities;

public class PackagingConfiguration
implements Cloneable {
    private MakeConfiguration makeConfiguration;
    private StringConfiguration type;
    private BooleanConfiguration verbose;
    private VectorConfiguration<PackagerInfoElement> info;
    private VectorConfiguration<String> additionalInfo;
    private VectorConfiguration<PackagerFileElement> files;
    private StringConfiguration output;
    private StringConfiguration tool;
    private StringConfiguration options;
    private StringConfiguration topDir;

    public PackagingConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.type = new StringConfiguration(null, "Tar");
        this.verbose = new BooleanConfiguration(true);
        this.info = new VectorConfiguration(null);
        this.additionalInfo = new VectorConfiguration(null);
        this.files = new VectorConfiguration(null);
        this.output = new StringConfiguration(null, "");
        this.tool = new StringConfiguration(null, "");
        this.options = new StringConfiguration(null, "");
        this.topDir = new StringConfiguration(null, null);
        this.setDefaultValues();
    }

    public final void setDefaultValues() {
        LinkerConfiguration linkerConfiguration;
        VectorConfiguration<PackagerFileElement> customFiles = new VectorConfiguration<PackagerFileElement>(null);
        for (PackagerFileElement packagerFileElement : this.files.getValue()) {
            if (packagerFileElement.isDefaultValue()) continue;
            customFiles.add(packagerFileElement);
        }
        if (this.files.getValue().size() != customFiles.getValue().size()) {
            this.files.assign(customFiles);
        }
        String perm = MakeOptions.getInstance().getDefExePerm();
        String packageDir = "${PACKAGE_TOP_DIR}bin";
        String suffix = "";
        if (this.makeConfiguration.isMakefileConfiguration()) {
            perm = MakeOptions.getInstance().getDefExePerm();
            packageDir = "${PACKAGE_TOP_DIR}bin";
        } else if (this.makeConfiguration.isApplicationConfiguration()) {
            perm = MakeOptions.getInstance().getDefExePerm();
            packageDir = "${PACKAGE_TOP_DIR}bin";
            if (this.makeConfiguration.getDevelopmentHost().getBuildPlatform() == 3) {
                suffix = ".exe";
            }
        } else if (this.makeConfiguration.isLibraryConfiguration()) {
            perm = MakeOptions.getInstance().getDefFilePerm();
            packageDir = "${PACKAGE_TOP_DIR}lib";
        } else assert (false);
        if (this.makeConfiguration.isLinkerConfiguration() && (linkerConfiguration = this.makeConfiguration.getLinkerConfiguration()).getCopyLibrariesConfiguration().getValue()) {
            LibrariesConfiguration librariesConfiguration = linkerConfiguration.getLibrariesConfiguration();
            Set<String> sharedLibraries = librariesConfiguration.getSharedLibraries();
            for (String sharedLibrary : sharedLibraries) {
                String outputDir = CndPathUtilities.getDirName((String)linkerConfiguration.getOutputValue());
                String libName = CndPathUtilities.getBaseName((String)sharedLibrary);
                PackagerFileElement elem = new PackagerFileElement(PackagerFileElement.FileType.FILE, outputDir + "/" + libName, packageDir + "/" + libName, perm, MakeOptions.getInstance().getDefOwner(), MakeOptions.getInstance().getDefGroup());
                elem.setDefaultValue(true);
                this.files.add(elem);
            }
        }
        PackagerFileElement elem = new PackagerFileElement(PackagerFileElement.FileType.FILE, "${OUTPUT_PATH}" + suffix, packageDir + "/${OUTPUT_BASENAME}" + suffix, perm, MakeOptions.getInstance().getDefOwner(), MakeOptions.getInstance().getDefGroup());
        elem.setDefaultValue(true);
        this.files.add(elem);
        List<PackagerInfoElement> infoList = this.getInfo().getValue();
        if (infoList.isEmpty()) {
            List<PackagerDescriptor> packagerList = PackagerManager.getDefault().getPackagerList();
            for (PackagerDescriptor packagerDescriptor : packagerList) {
                if (!packagerDescriptor.hasInfoList()) continue;
                infoList.addAll(packagerDescriptor.getDefaultInfoList(this.makeConfiguration, this));
            }
        }
    }

    public List<PackagerInfoElement> getHeaderSubList(String packager) {
        ArrayList<PackagerInfoElement> list = new ArrayList<PackagerInfoElement>();
        List<PackagerInfoElement> headerList = this.getInfo().getValue();
        for (PackagerInfoElement elem : headerList) {
            if (!elem.getPackager().equals(packager)) continue;
            list.add(elem);
        }
        return list;
    }

    public boolean isModified() {
        if (this.getType().getModified() || this.getOutput().getModified() || this.getOptions().getModified() || this.getVerbose().getModified() || this.getTool().getModified()) {
            return true;
        }
        if (this.files.getValue().size() != 1) {
            return true;
        }
        for (PackagerFileElement elem : this.files.getValue()) {
            if (elem.isDefaultValue()) continue;
            return true;
        }
        List<PackagerInfoElement> headerList = this.getHeaderSubList(this.getType().getValue());
        PackagerDescriptor packager = PackagerManager.getDefault().getPackager(this.getType().getValue());
        return packager != null && packager.hasInfoList() && headerList.size() != packager.getDefaultInfoList(this.makeConfiguration, this).size();
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public StringConfiguration getType() {
        return this.type;
    }

    public void setType(StringConfiguration type) {
        PackagerDescriptor packager = PackagerManager.getDefault().getPackager(type.getValue());
        if (packager == null) {
            packager = new DummyPackager(type.getValue());
            PackagerManager.getDefault().addPackagingDescriptor(packager);
        }
        this.type = type;
    }

    public BooleanConfiguration getVerbose() {
        return this.verbose;
    }

    public void setVerbose(BooleanConfiguration verbose) {
        this.verbose = verbose;
    }

    public VectorConfiguration<PackagerInfoElement> getInfo() {
        return this.info;
    }

    public void setInfo(VectorConfiguration<PackagerInfoElement> svr4Header) {
        this.info = svr4Header;
    }

    public VectorConfiguration<String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(VectorConfiguration<String> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public VectorConfiguration<PackagerFileElement> getFiles() {
        this.setDefaultValues();
        return this.files;
    }

    public void setFiles(VectorConfiguration<PackagerFileElement> files) {
        this.files = files;
    }

    public void setOutput(StringConfiguration output) {
        this.output = output;
    }

    public StringConfiguration getOutput() {
        return this.output;
    }

    public void setTool(StringConfiguration output) {
        this.tool = output;
    }

    public StringConfiguration getTool() {
        return this.tool;
    }

    public void setOptions(StringConfiguration options) {
        this.options = options;
    }

    public StringConfiguration getOptions() {
        return this.options;
    }

    public void setTopDir(StringConfiguration topDir) {
        this.topDir = topDir;
    }

    public StringConfiguration getTopDir() {
        return this.topDir;
    }

    public void assign(PackagingConfiguration conf) {
        this.getType().assign(conf.getType());
        this.getVerbose().assign(conf.getVerbose());
        this.getInfo().assign(conf.getInfo());
        this.getAdditionalInfo().assign(conf.getAdditionalInfo());
        this.getFiles().assign(conf.getFiles());
        this.getOutput().assign(conf.getOutput());
        this.getTool().assign(conf.getTool());
        this.getOptions().assign(conf.getOptions());
        this.getTopDir().assign(conf.getTopDir());
    }

    public PackagingConfiguration clone() {
        PackagingConfiguration clone = new PackagingConfiguration(this.getMakeConfiguration());
        clone.setType(this.getType().clone());
        clone.setVerbose(this.getVerbose().clone());
        clone.setInfo((VectorConfiguration<PackagerInfoElement>)this.getInfo().clone());
        clone.setAdditionalInfo((VectorConfiguration<String>)this.getAdditionalInfo().clone());
        clone.setFiles((VectorConfiguration<PackagerFileElement>)this.getFiles().clone());
        clone.setOutput(this.getOutput().clone());
        clone.setTool(this.getTool().clone());
        clone.setOptions(this.getOptions().clone());
        clone.setTopDir(this.getTopDir().clone());
        return clone;
    }

    public String getOutputValue() {
        if (this.getOutput().getModified()) {
            return this.getOutput().getValue();
        }
        return this.getOutputDefault();
    }

    public String getTopDirValue() {
        if (this.getTopDir().getModified()) {
            return this.getTopDir().getValue();
        }
        PackagerDescriptor packager = PackagerManager.getDefault().getPackager(this.getType().getValue());
        if (packager != null) {
            return packager.getTopDir(this.makeConfiguration, this);
        }
        return "";
    }

    public String getOutputName() {
        String outputName = CndPathUtilities.getBaseName((String)this.getMakeConfiguration().getBaseDir());
        if (this.getMakeConfiguration().getConfigurationType().getValue() == 1 || this.getMakeConfiguration().getConfigurationType().getValue() == 7) {
            outputName = outputName.toLowerCase(Locale.getDefault());
        } else if (this.getMakeConfiguration().getConfigurationType().getValue() == 2) {
            Platform platform = Platforms.getPlatform(this.getMakeConfiguration().getDevelopmentHost().getBuildPlatform());
            outputName = platform.getLibraryName(outputName);
        }
        outputName = this.createValidPackageName(outputName);
        return outputName;
    }

    public String getOutputDefault() {
        String outputPath = "${CND_DISTDIR}/${CND_CONF}/${CND_PLATFORM}/package";
        PackagerDescriptor packager = PackagerManager.getDefault().getPackager(this.getType().getValue());
        if (!packager.isOutputAFolder()) {
            outputPath = outputPath + "/" + packager.getOutputFileName(this.makeConfiguration, this) + "." + packager.getOutputFileSuffix();
        }
        return outputPath;
    }

    public String getToolValue() {
        if (this.getTool().getModified()) {
            return this.getTool().getValue();
        }
        return this.getToolDefault();
    }

    public String getToolDefault() {
        PackagerDescriptor packager = PackagerManager.getDefault().getPackager(this.getType().getValue());
        return packager.getDefaultTool();
    }

    public String getOptionsValue() {
        if (this.getOptions().getModified()) {
            return this.getOptions().getValue();
        }
        return this.getOptionsDefault();
    }

    public String getOptionsDefault() {
        PackagerDescriptor packager = PackagerManager.getDefault().getPackager(this.getType().getValue());
        return packager.getDefaultOptions();
    }

    public String[] getDisplayNames() {
        return PackagerManager.getDefault().getDisplayNames();
    }

    public String getDisplayName() {
        return PackagerManager.getDefault().getDisplayName(this.getType().getValue());
    }

    public String getName() {
        return this.getType().getValue();
    }

    public String expandMacros(String s) {
        s = this.makeConfiguration.expandMacros(s);
        s = CndPathUtilities.expandMacro((String)s, (String)"${PACKAGE_TOP_DIR}", (String)(this.getTopDirValue().length() > 0 ? this.getTopDirValue() + "/" : ""));
        return s;
    }

    private String createValidPackageName(String name) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_' || c == ' ') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public PackagerInfoElement findInfoElement(String name) {
        List<PackagerInfoElement> infoList = this.getInfo().getValue();
        for (PackagerInfoElement elem : infoList) {
            if (!elem.getName().equals(name)) continue;
            return elem;
        }
        return null;
    }

    public String findInfoValueName(String name) {
        List<PackagerInfoElement> infoList = this.getInfo().getValue();
        for (PackagerInfoElement elem : infoList) {
            if (!elem.getName().equals(name)) continue;
            return elem.getValue();
        }
        return null;
    }
}

