/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.lib.editor.util.swing.PositionRegion;
import org.openide.ErrorManager;

public final class SyncDocumentRegion {
    private final Document doc;
    private final List<? extends MutablePositionRegion> regions;
    private final List<? extends MutablePositionRegion> sortedRegions;
    private final boolean regionsSortPerformed;

    public SyncDocumentRegion(Document doc, List<? extends MutablePositionRegion> regions) {
        this.doc = doc;
        this.regions = regions;
        this.regionsSortPerformed = PositionRegion.isRegionsSorted(regions);
        if (this.regionsSortPerformed) {
            this.sortedRegions = regions;
        } else {
            this.sortedRegions = new ArrayList<MutablePositionRegion>(regions);
            Collections.sort(this.sortedRegions, PositionRegion.getComparator());
        }
    }

    public int getRegionCount() {
        return this.regions.size();
    }

    public MutablePositionRegion getRegion(int regionIndex) {
        return this.regions.get(regionIndex);
    }

    public int getFirstRegionStartOffset() {
        return this.getRegion(0).getStartOffset();
    }

    public int getFirstRegionEndOffset() {
        return this.getRegion(0).getEndOffset();
    }

    public int getFirstRegionLength() {
        return this.getFirstRegionEndOffset() - this.getFirstRegionStartOffset();
    }

    public MutablePositionRegion getSortedRegion(int regionIndex) {
        return this.sortedRegions.get(regionIndex);
    }

    public boolean sync(int moveStartDownLength) {
        if (moveStartDownLength != 0) {
            MutablePositionRegion firstRegion = this.getRegion(0);
            try {
                Position newStartPos = this.doc.createPosition(firstRegion.getStartOffset() - moveStartDownLength);
                firstRegion.setStartPosition(newStartPos);
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        String firstRegionText = this.getFirstRegionText();
        boolean insideRegionsTextModification = false;
        if (firstRegionText != null) {
            int regionCount = this.getRegionCount();
            for (int i = 1; i < regionCount; ++i) {
                MutablePositionRegion region = this.getRegion(i);
                int offset = region.getStartOffset();
                int length = region.getEndOffset() - offset;
                try {
                    CharSequence old = DocumentUtilities.getText((Document)this.doc, (int)offset, (int)length);
                    if (CharSequenceUtilities.textEquals((CharSequence)firstRegionText, (CharSequence)old)) continue;
                    int res = -1;
                    int k = 0;
                    while (k < Math.min(old.length(), firstRegionText.length()) && old.charAt(k) == firstRegionText.charAt(k)) {
                        res = k++;
                    }
                    insideRegionsTextModification = true;
                    String insert = firstRegionText.substring(res + 1);
                    CharSequence remove = old.subSequence(res + 1, old.length());
                    if (insert.length() > 0) {
                        this.doc.insertString(offset + res + 1, insert, null);
                    }
                    if (remove.length() <= 0) continue;
                    this.doc.remove(offset + res + 1 + insert.length(), remove.length());
                    continue;
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }
        return insideRegionsTextModification;
    }

    private String getFirstRegionText() {
        return this.getRegionText(0);
    }

    private String getRegionText(int regionIndex) {
        try {
            MutablePositionRegion region = this.getRegion(regionIndex);
            int offset = region.getStartOffset();
            int length = region.getEndOffset() - offset;
            return this.doc.getText(offset, length);
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }
}

