/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.completion.implmethod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.completion.implmethod.CsmImplementsMethodCompletionItem;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public class CsmImplementsMethodCompletionProvider
implements CompletionProvider {
    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if ((queryType & 1) != 0) {
            int dot = component.getCaret().getDot();
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(dot), component);
        }
        return null;
    }

    static Collection<CsmImplementsMethodCompletionItem> getFilteredData(BaseDocument doc, int caretOffset, int queryType) {
        Query query = new Query(caretOffset);
        Collection items = query.getItems(doc, caretOffset);
        return items;
    }

    private static final class Query
    extends AsyncCompletionQuery {
        private Collection<CsmImplementsMethodCompletionItem> results;
        private final int creationCaretOffset;
        private int queryAnchorOffset;
        private String filterPrefix;
        private boolean isApplicable = true;
        private CsmScope insertScope;

        Query(int caretOffset) {
            this.creationCaretOffset = caretOffset;
            this.queryAnchorOffset = -1;
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            Collection<CsmImplementsMethodCompletionItem> items = this.getItems((BaseDocument)doc, caretOffset);
            if (this.queryAnchorOffset >= 0) {
                if (items != null && items.size() > 0) {
                    this.results = items;
                    items = this.getFilteredData(items, this.filterPrefix);
                    resultSet.estimateItems(items.size(), -1);
                    resultSet.addAllItems(items);
                    resultSet.setAnchorOffset(this.queryAnchorOffset);
                }
                resultSet.setHasAdditionalItems(false);
            }
            resultSet.finish();
        }

        protected boolean canFilter(JTextComponent component) {
            int caretOffset = component.getCaretPosition();
            this.filterPrefix = null;
            if (this.queryAnchorOffset > -1 && caretOffset >= this.queryAnchorOffset) {
                Document doc = component.getDocument();
                try {
                    this.filterPrefix = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
                }
                catch (BadLocationException ex) {
                    Completion.get().hideCompletion();
                }
            } else {
                Completion.get().hideCompletion();
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet resultSet) {
            if (this.filterPrefix != null && this.results != null) {
                resultSet.setAnchorOffset(this.queryAnchorOffset);
                Collection<CsmImplementsMethodCompletionItem> items = this.getFilteredData(this.results, this.filterPrefix);
                resultSet.estimateItems(items.size(), -1);
                resultSet.addAllItems(items);
            }
            resultSet.setHasAdditionalItems(false);
            resultSet.finish();
        }

        private void visitDeclarations(Set<CsmClass> classes, Collection<CsmOffsetableDeclaration> decls, int caretOffset) {
            for (CsmOffsetableDeclaration decl : decls) {
                CsmMember method;
                CsmClass cls;
                CsmFunction declaration;
                if (!this.isApplicable) {
                    return;
                }
                if (CsmKindUtilities.isNamespaceDefinition((CsmObject)decl)) {
                    if (decl.getStartOffset() > caretOffset || caretOffset > decl.getEndOffset()) continue;
                    this.insertScope = (CsmNamespaceDefinition)decl;
                    this.visitDeclarations(classes, ((CsmNamespaceDefinition)decl).getDeclarations(), caretOffset);
                    continue;
                }
                if (decl.getStartOffset() <= caretOffset && caretOffset <= decl.getEndOffset()) {
                    this.isApplicable = false;
                }
                if (!CsmKindUtilities.isMethodDefinition((CsmObject)decl) || !CsmKindUtilities.isFunctionDeclaration((CsmObject)(declaration = ((CsmFunctionDefinition)decl).getDeclaration())) || !CsmKindUtilities.isClassMember((CsmObject)declaration) || (cls = (method = (CsmMember)declaration).getContainingClass()) == null) continue;
                classes.add(cls);
            }
        }

        private void visitClasses(Set<CsmClass> classes, Collection<? extends CsmOffsetableDeclaration> decls, int caretOffset) {
            for (CsmOffsetableDeclaration csmOffsetableDeclaration : decls) {
                if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration)) {
                    this.visitClasses(classes, ((CsmNamespaceDefinition)csmOffsetableDeclaration).getDeclarations(), caretOffset);
                    continue;
                }
                if (!CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration)) continue;
                this.visitClasses(classes, ((CsmClass)csmOffsetableDeclaration).getMembers(), caretOffset);
                classes.add((CsmClass)csmOffsetableDeclaration);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<CsmImplementsMethodCompletionItem> getItems(BaseDocument doc, int caretOffset) {
            ArrayList<CsmImplementsMethodCompletionItem> items = new ArrayList<CsmImplementsMethodCompletionItem>();
            CsmCacheManager.enter();
            try {
                CsmFile csmFile;
                if (this.init(doc, caretOffset) && (csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false)) != null) {
                    this.insertScope = csmFile;
                    HashSet<CsmClass> classes = new HashSet<CsmClass>();
                    this.visitDeclarations(classes, csmFile.getDeclarations(), caretOffset);
                    if (this.isApplicable) {
                        String name = CndPathUtilities.getBaseName((String)csmFile.getAbsolutePath().toString());
                        if (name.lastIndexOf(46) > 0) {
                            name = name.substring(0, name.lastIndexOf(46));
                        }
                        CsmFile bestInterface = null;
                        for (CsmInclude incl : csmFile.getIncludes()) {
                            CsmFile includeFile = incl.getIncludeFile();
                            if (includeFile == null) continue;
                            String inclName = CndPathUtilities.getBaseName((String)includeFile.getAbsolutePath().toString());
                            if (inclName.lastIndexOf(46) > 0) {
                                inclName = inclName.substring(0, inclName.lastIndexOf(46));
                            }
                            if (!name.equals(inclName)) continue;
                            bestInterface = includeFile;
                            break;
                        }
                        if (bestInterface != null) {
                            this.visitClasses(classes, bestInterface.getDeclarations(), caretOffset);
                        }
                        for (CsmClass cls : classes) {
                            CsmImplementsMethodCompletionItem item;
                            CsmFunctionDefinition definition;
                            CsmFunction method;
                            for (CsmMember member : cls.getMembers()) {
                                if (!CsmKindUtilities.isMethodDeclaration((CsmObject)member) || ((CsmMethod)member).isAbstract()) continue;
                                method = (CsmFunction)member;
                                definition = method.getDefinition();
                                if (definition == null) {
                                    items.add(CsmImplementsMethodCompletionItem.createImplementItem(this.queryAnchorOffset, caretOffset, cls, method, this.insertScope));
                                    continue;
                                }
                                if (method != definition || definition.getDefinitionKind() != CsmFunctionDefinition.DefinitionKind.REGULAR || (item = CsmImplementsMethodCompletionItem.createExtractBodyItem(this.queryAnchorOffset, caretOffset, cls, method, this.insertScope)) == null) continue;
                                items.add(item);
                            }
                            for (CsmMember member : cls.getFriends()) {
                                if (!CsmKindUtilities.isFriendMethod((CsmObject)member)) continue;
                                method = (CsmFriendFunction)member;
                                definition = method.getDefinition();
                                if (definition == null) {
                                    items.add(CsmImplementsMethodCompletionItem.createImplementItem(this.queryAnchorOffset, caretOffset, cls, method, this.insertScope));
                                    continue;
                                }
                                if (method != definition || definition.getDefinitionKind() != CsmFunctionDefinition.DefinitionKind.REGULAR || (item = CsmImplementsMethodCompletionItem.createExtractBodyItem(this.queryAnchorOffset, caretOffset, cls, method, this.insertScope)) == null) continue;
                                items.add(item);
                            }
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                CsmCacheManager.leave();
            }
            return items;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean init(BaseDocument doc, int caretOffset) throws BadLocationException {
            this.filterPrefix = "";
            this.queryAnchorOffset = caretOffset;
            if (doc != null) {
                doc.readLock();
                try {
                    TokenId id;
                    TokenItem tok = CndTokenUtilities.getTokenCheckPrev((Document)doc, (int)caretOffset);
                    if (tok != null && (id = tok.id()) instanceof CppTokenId && !"whitespace".equals(id.primaryCategory())) {
                        this.queryAnchorOffset = tok.offset();
                        this.filterPrefix = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    doc.readUnlock();
                }
            }
            return this.queryAnchorOffset >= 0;
        }

        private Collection<CsmImplementsMethodCompletionItem> getFilteredData(Collection<CsmImplementsMethodCompletionItem> data, String prefix) {
            Collection<CsmImplementsMethodCompletionItem> out;
            if (prefix == null) {
                out = data;
            } else {
                ArrayList<CsmImplementsMethodCompletionItem> ret = new ArrayList<CsmImplementsMethodCompletionItem>(data.size());
                for (CsmImplementsMethodCompletionItem itm : data) {
                    if (!this.matchPrefix(itm, prefix)) continue;
                    ret.add(itm);
                }
                out = ret;
            }
            return out;
        }

        private boolean matchPrefix(CsmImplementsMethodCompletionItem itm, String prefix) {
            return CharSequenceUtils.startsWith((CharSequence)itm.getSortText(), (CharSequence)prefix);
        }
    }
}

