/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.ModelVisitor;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.css.visual.api.CssStylesTC;
import org.netbeans.modules.css.visual.api.RuleEditorController;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.windows.WindowManager;

public final class CssCaretAwareSourceTask
extends ParserResultTask<CssParserResult> {
    private static final Logger LOG = Logger.getLogger("rule.editor");
    private static final String CSS_MIMETYPE = "text/css";
    private boolean cancelled;

    public int getPriority() {
        return 5000;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(final CssParserResult result, SchedulerEvent event) {
        int caretOffset;
        final FileObject file = result.getSnapshot().getSource().getFileObject();
        if (file == null) {
            LOG.log(Level.FINE, "run() -  file is null.");
            return;
        }
        final String mimeType = file.getMIMEType();
        LOG.log(Level.FINER, "run(), file: {0}", new Object[]{file});
        if (!mimeType.equals(CSS_MIMETYPE)) {
            LOG.log(Level.FINE, "ignoring non-pure (text/css) file, actual mimetype is {0}", mimeType);
            return;
        }
        this.cancelled = false;
        if (event == null) {
            caretOffset = -1;
        } else if (event instanceof CursorMovedSchedulerEvent) {
            caretOffset = ((CursorMovedSchedulerEvent)event).getCaretOffset();
        } else {
            LOG.log(Level.FINE, "run() - !(event instanceof CursorMovedSchedulerEvent)");
            caretOffset = -1;
        }
        final Model model = Model.getModel((CssParserResult)result);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CssCaretAwareSourceTask.this.runInEDT(result.getSnapshot(), model, file, mimeType, caretOffset);
            }
        });
    }

    private void runInEDT(Snapshot snapshot, Model model, FileObject file, String mimeType, int caretOffset) {
        Rule rule;
        LOG.log(Level.FINER, "runInEDT(), file: {0}, caret: {1}", new Object[]{file, caretOffset});
        if (this.cancelled) {
            LOG.log(Level.FINER, "cancelled");
            return;
        }
        if (caretOffset == -1) {
            try {
                JEditorPane pane;
                DataObject dobj = DataObject.find((FileObject)file);
                EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
                if (ec != null && (pane = NbDocument.findRecentEditorPane((EditorCookie)ec)) != null) {
                    caretOffset = pane.getCaretPosition();
                }
            }
            catch (DataObjectNotFoundException ex) {
                return;
            }
            LOG.log(Level.INFO, "workarounded caret offset: {0}", caretOffset);
        }
        if ((rule = this.findRuleAtOffset(snapshot, model, caretOffset)) != null && rule.getSelectorsGroup() == null) {
            rule = null;
        }
        if (rule != null && snapshot.getOriginalOffset(rule.getSelectorsGroup().getStartOffset()) == -1) {
            LOG.log(Level.FINER, "the found rule is virtual, exiting w/o change of the RuleEditor", caretOffset);
            return;
        }
        if (!mimeType.equals(CSS_MIMETYPE) && rule == null) {
            LOG.log(Level.FINER, "not a css file and rule not found at {0} offset, exiting w/o change of the RuleEditor", caretOffset);
            return;
        }
        CssStylesTC cssStylesTC = (CssStylesTC)WindowManager.getDefault().findTopComponent("CssStylesTC");
        if (cssStylesTC == null) {
            return;
        }
        RuleEditorController controller = cssStylesTC.getRuleEditorController();
        LOG.log(Level.FINER, "SourceTask: calling controller.setModel({0})", model);
        controller.setModel(model);
        if (rule == null) {
            controller.setNoRuleState();
        } else {
            controller.setRule(rule);
        }
    }

    private Rule findRuleAtOffset(final Snapshot snapshot, Model model, int documentOffset) {
        final int astOffset = snapshot.getEmbeddedOffset(documentOffset);
        if (astOffset == -1) {
            return null;
        }
        final AtomicReference ruleRef = new AtomicReference();
        model.runReadTask(new Model.ModelTask(){

            public void run(StyleSheet styleSheet) {
                styleSheet.accept((ModelVisitor)new ModelVisitor.Adapter(){

                    public void visitRule(Rule rule) {
                        if (CssCaretAwareSourceTask.this.cancelled) {
                            return;
                        }
                        if (astOffset >= rule.getStartOffset()) {
                            if (astOffset <= rule.getEndOffset()) {
                                ruleRef.set(rule);
                            } else {
                                CharSequence source = snapshot.getText();
                                int adjustedAstOffset = Math.min(source.length(), astOffset);
                                for (int i = adjustedAstOffset - 1; i >= 0; --i) {
                                    if (i == rule.getEndOffset()) {
                                        ruleRef.set(rule);
                                        return;
                                    }
                                    char c = source.charAt(i);
                                    if (c != ' ' && c != '\t' || c == '\n') break;
                                }
                            }
                        }
                    }
                });
            }
        });
        return (Rule)ruleRef.get();
    }

    public static class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            String mimeType = snapshot.getMimeType();
            if (mimeType.equals(CssCaretAwareSourceTask.CSS_MIMETYPE)) {
                return Collections.singletonList(new CssCaretAwareSourceTask());
            }
            return Collections.emptyList();
        }
    }
}

