/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.spi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.web.browser.Helper;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;

public final class ExternalModificationsSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void handle(String url, String type, String content, URL currentBrowserURL) {
        Helper.urlBeingRefreshedFromBrowser.set(currentBrowserURL != null ? currentBrowserURL.toExternalForm() : null);
        try {
            URL u = WebUtils.stringToUrl((String)url);
            for (Project p : OpenProjects.getDefault().getOpenProjects()) {
                FileObject fo = ServerURLMapping.fromServer((Project)p, (URL)u);
                if (fo == null) continue;
                ExternalModificationsSupport.updateFileObject(fo, content);
                break;
            }
        }
        finally {
            Helper.urlBeingRefreshedFromBrowser.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateFileObject(FileObject modifiedFile, String content) {
        for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
            EditorCookie ec;
            FileObject fo = (FileObject)tc.getLookup().lookup(FileObject.class);
            if (fo == null || !fo.equals(modifiedFile) || (ec = (EditorCookie)tc.getLookup().lookup(EditorCookie.class)) == null) continue;
            if (ec.isModified()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Content of " + FileUtil.getFileDisplayName((FileObject)modifiedFile) + " is modified in the IDE and therefore cannot be replaced " + "with changes coming from the Chrome Developer Tools!")));
                return;
            }
            StyledDocument doc = ec.getDocument();
            if (doc == null) continue;
            try {
                doc.remove(0, doc.getLength());
                doc.insertString(0, content, null);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            try {
                ec.saveDocument();
                return;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        OutputStream os = null;
        FileLock lock = null;
        try {
            lock = modifiedFile.lock();
            os = modifiedFile.getOutputStream(lock);
            FileUtil.copy((InputStream)new ByteArrayInputStream(content.getBytes()), (OutputStream)os);
        }
        catch (FileAlreadyLockedException ex) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Content of " + FileUtil.getFileDisplayName((FileObject)modifiedFile) + " cannot be updated with " + "changes coming from the Chrome Developer Tools because file is locked!")));
            return;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }
}

