/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util.common;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.versioning.util.common.VCSCommitOptions;
import org.netbeans.modules.versioning.util.common.VCSCommitPanelModifier;
import org.netbeans.modules.versioning.util.common.VCSFileNode;
import org.openide.util.NbBundle;

public class VCSCommitTableModel<F extends VCSFileNode>
extends AbstractTableModel {
    public static final String COLUMN_NAME_COMMIT = "commit";
    public static final String COLUMN_NAME_NAME = "name";
    public static final String COLUMN_NAME_STATUS = "status";
    public static final String COLUMN_NAME_ACTION = "action";
    public static final String COLUMN_NAME_PATH = "path";
    public static final String COLUMN_NAME_BRANCH = "branch";
    public static String[] COMMIT_COLUMNS = new String[]{"commit", "name", "status", "action", "path"};
    private final VCSCommitPanelModifier modifier;
    private RootFile rootFile;
    private final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private F[] nodes;
    private String[] columns;

    public VCSCommitTableModel() {
        this(new VCSCommitPanelModifier());
    }

    public VCSCommitTableModel(VCSCommitPanelModifier modifier) {
        this.modifier = modifier;
        this.initColumnLabels();
        this.setColumns(COMMIT_COLUMNS);
    }

    protected void setNodes(F[] nodes) {
        this.nodes = nodes;
        this.fireTableDataChanged();
    }

    private void initColumnLabels() {
        ResourceBundle loc = NbBundle.getBundle(VCSCommitTableModel.class);
        this.columnLabels.put(COLUMN_NAME_COMMIT, new String[]{this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.FILE_TABLE_HEADER_COMMIT), this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.FILE_TABLE_HEADER_COMMIT_DESC)});
        this.columnLabels.put(COLUMN_NAME_NAME, new String[]{loc.getString("CTL_CommitTable_Column_File"), loc.getString("CTL_CommitTable_Column_File")});
        this.columnLabels.put(COLUMN_NAME_STATUS, new String[]{loc.getString("CTL_CommitTable_Column_Status"), loc.getString("CTL_CommitTable_Column_Status")});
        this.columnLabels.put(COLUMN_NAME_ACTION, new String[]{this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.FILE_TABLE_HEADER_ACTION), this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.FILE_TABLE_HEADER_ACTION_DESC)});
        this.columnLabels.put(COLUMN_NAME_PATH, new String[]{loc.getString("CTL_CommitTable_Column_Folder"), loc.getString("CTL_CommitTable_Column_Folder")});
    }

    protected final void setColumns(String[] cols) {
        if (Arrays.equals(cols, this.columns)) {
            return;
        }
        this.columns = cols;
        this.fireTableStructureChanged();
    }

    public List<F> getCommitFiles() {
        List<Object> ret = new LinkedList<F>();
        if (this.nodes == null) {
            ret = Collections.emptyList();
            return Collections.unmodifiableList(ret);
        }
        ret.addAll(Arrays.asList(this.nodes));
        return Collections.unmodifiableList(ret);
    }

    @Override
    public String getColumnName(int column) {
        return this.columnLabels.get(this.columns[column])[0];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public int getRowCount() {
        return this.nodes == null ? 0 : this.nodes.length;
    }

    public Class getColumnClass(int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals(COLUMN_NAME_COMMIT)) {
            return Boolean.class;
        }
        if (col.equals(COLUMN_NAME_ACTION)) {
            return VCSCommitOptions.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        return col.equals(COLUMN_NAME_COMMIT);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals(COLUMN_NAME_COMMIT)) {
            return ((VCSFileNode)this.nodes[rowIndex]).getCommitOptions() != this.modifier.getExcludedOption();
        }
        if (col.equals(COLUMN_NAME_NAME)) {
            return ((VCSFileNode)this.nodes[rowIndex]).getName();
        }
        if (col.equals(COLUMN_NAME_STATUS)) {
            return ((VCSFileNode)this.nodes[rowIndex]).getStatusText();
        }
        if (col.equals(COLUMN_NAME_ACTION)) {
            return ((VCSFileNode)this.nodes[rowIndex]).getCommitOptions();
        }
        if (col.equals(COLUMN_NAME_PATH)) {
            String shortPath = null;
            if (this.rootFile != null) {
                String relativePath = ((VCSFileNode)this.nodes[rowIndex]).getFile().getAbsolutePath().substring(this.rootFile.rootLocalPath.length());
                shortPath = this.rootFile.repositoryPath + relativePath.replace(File.separatorChar, '/');
            } else {
                shortPath = ((VCSFileNode)this.nodes[rowIndex]).getRelativePath();
                if (shortPath == null) {
                    shortPath = NbBundle.getMessage(VCSCommitTableModel.class, (String)"LBL_Location_NotInRepository");
                }
            }
            return shortPath;
        }
        throw new IllegalArgumentException("Column index out of range: " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals(COLUMN_NAME_ACTION)) {
            ((VCSFileNode)this.nodes[rowIndex]).setCommitOptions((VCSCommitOptions)aValue);
        } else if (col.equals(COLUMN_NAME_COMMIT)) {
            F node = this.nodes[rowIndex];
            ((VCSFileNode)this.nodes[rowIndex]).setCommitOptions((Boolean)aValue != false ? ((VCSFileNode)node).getDefaultCommitOption(false) : this.modifier.getExcludedOption());
        } else {
            throw new IllegalArgumentException("Column index out of range: " + columnIndex);
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    protected F[] getNodes() {
        return this.nodes;
    }

    public F getNode(int row) {
        return this.nodes[row];
    }

    public VCSCommitOptions getOption(int row) {
        return ((VCSFileNode)this.nodes[row]).getCommitOptions();
    }

    protected void setRootFile(String repositoryPath, String rootLocalPath) {
        this.rootFile = new RootFile();
        this.rootFile.repositoryPath = repositoryPath;
        this.rootFile.rootLocalPath = rootLocalPath;
    }

    protected void setIncluded(int[] rows, boolean include) {
        for (int rowIndex : rows) {
            F node = this.nodes[rowIndex];
            VCSCommitOptions options = ((VCSFileNode)node).getDefaultCommitOption(false);
            ((VCSFileNode)this.nodes[rowIndex]).setCommitOptions(include ? options : this.modifier.getExcludedOption());
        }
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    VCSCommitPanelModifier getCommitModifier() {
        return this.modifier;
    }

    private class RootFile {
        String repositoryPath;
        String rootLocalPath;

        private RootFile() {
        }
    }
}

