/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sendto.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.dlight.sendto.api.Handlers;
import org.netbeans.modules.dlight.sendto.spi.Handler;
import org.openide.util.NbBundle;

public final class Configuration
implements Cloneable,
Comparable<Configuration> {
    private static final AtomicInteger lastID = new AtomicInteger();
    public static final String DISPLAY_NAME = "display_name";
    public static final String HANDLER_ID = "script_handler_id";
    private final Integer id;
    private final Map<String, String> map = new HashMap<String, String>();
    private boolean modified = false;

    private Configuration(Integer id) {
        this.id = id;
        this.map.put(DISPLAY_NAME, NbBundle.getMessage(Configuration.class, (String)"Configuration.default.DisplayName"));
    }

    public Configuration() {
        this(lastID.incrementAndGet());
    }

    public Object clone() {
        Configuration clone = new Configuration(this.id);
        clone.map.putAll(this.map);
        return clone;
    }

    public Configuration copy() {
        Configuration copy = new Configuration();
        copy.map.putAll(this.map);
        copy.map.put(DISPLAY_NAME, this.map.get(DISPLAY_NAME) + "_copy");
        return copy;
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getName() {
        return this.map.get(DISPLAY_NAME);
    }

    public void setName(String name) {
        this.map.put(DISPLAY_NAME, name);
        this.modified = true;
    }

    public Handler getHandler() {
        return Handlers.getHandler(this.map.get(HANDLER_ID));
    }

    public String get(String key) {
        String result = this.map.get(key);
        return result == null ? "" : result;
    }

    public void set(String key, String param) {
        this.map.put(key, param);
        this.modified = true;
    }

    public Integer getID() {
        return this.id;
    }

    public void setHandler(Handler handler) {
        this.map.put(HANDLER_ID, handler.getID());
        this.modified = true;
    }

    Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.map);
    }

    public void applyChanges() {
        this.getHandler().applyChanges(this);
    }

    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.get(key));
    }

    public void setBoolean(String key, boolean param) {
        this.set(key, Boolean.toString(param));
    }

    @Override
    public int compareTo(Configuration that) {
        if (that == null) {
            return 1;
        }
        return this.getName().compareTo(that.getName());
    }
}

