/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.ConfigurationModifier;
import org.netbeans.modules.j2ee.weblogic9.config.WLDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.WarDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.dd.model.EjbJarModel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class EjbDeploymentConfiguration
extends WLDeploymentConfiguration
implements ModuleConfiguration,
DeploymentPlanConfiguration,
PropertyChangeListener {
    private final ConfigurationModifier<EjbJarModel> modifier = new ConfigurationModifier();
    private final File file;
    private final J2eeModule j2eeModule;
    private final DataObject dataObject;
    private final Version serverVersion;
    private EjbJarModel weblogicEjbJar;

    public EjbDeploymentConfiguration(J2eeModule j2eeModule) {
        this(j2eeModule, null);
    }

    public EjbDeploymentConfiguration(J2eeModule j2eeModule, Version serverVersion) {
        super(j2eeModule, serverVersion);
        this.j2eeModule = j2eeModule;
        this.serverVersion = serverVersion;
        this.file = j2eeModule.getDeploymentConfigurationFile("META-INF/weblogic-ejb-jar.xml");
        this.getWeblogicEjbJar();
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)this.file));
            dataObject.addPropertyChangeListener((PropertyChangeListener)this);
        }
        catch (DataObjectNotFoundException donfe) {
            Exceptions.printStackTrace((Throwable)donfe);
        }
        this.dataObject = dataObject;
    }

    public synchronized EjbJarModel getWeblogicEjbJar() {
        if (this.weblogicEjbJar == null) {
            try {
                if (this.file.exists()) {
                    try {
                        this.weblogicEjbJar = EjbJarModel.forFile(this.file);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    catch (RuntimeException ioe) {}
                } else {
                    this.weblogicEjbJar = this.genereateWeblogicEjbJar();
                    this.weblogicEjbJar.write(this.file);
                }
            }
            catch (ConfigurationException ce) {
                Exceptions.printStackTrace((Throwable)ce);
            }
        }
        return this.weblogicEjbJar;
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public J2eeModule getJ2eeModule() {
        return this.j2eeModule;
    }

    public void dispose() {
        if (this.dataObject != null) {
            this.dataObject.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "modified" && Boolean.FALSE.equals(evt.getNewValue())) {
            EjbDeploymentConfiguration ejbDeploymentConfiguration = this;
            synchronized (ejbDeploymentConfiguration) {
                this.weblogicEjbJar = null;
            }
        }
    }

    public void save(OutputStream os) throws ConfigurationException {
        EjbJarModel weblogicEjbJar = this.getWeblogicEjbJar();
        if (weblogicEjbJar == null) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_cannotSaveNotParseableConfFile", (Object)this.file.getPath());
            throw new ConfigurationException(msg);
        }
        try {
            weblogicEjbJar.write(os);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.file.getPath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    @Override
    public void bindDatasourceReferenceForEjb(final String ejbName, final String ejbType, final String referenceName, final String jndiName) throws ConfigurationException {
        if (ejbName == null || ejbName.length() == 0 || referenceName == null || referenceName.length() == 0 || jndiName == null || jndiName.length() == 0) {
            return;
        }
        this.modifier.modify(new WeblogicEjbJarModifier(){

            @Override
            public void modify(EjbJarModel webLogicEjbJar) {
                webLogicEjbJar.setReference(ejbName, ejbType, referenceName, jndiName);
            }
        }, this.dataObject, this.file);
    }

    @Override
    public String findDatasourceJndiNameForEjb(String ejbName, String referenceName) throws ConfigurationException {
        EjbJarModel webLogicEjbJar = this.getWeblogicEjbJar();
        if (webLogicEjbJar == null) {
            String msg = NbBundle.getMessage(EjbDeploymentConfiguration.class, (String)"MSG_CannotReadReferenceName", (Object)this.file.getPath());
            throw new ConfigurationException(msg);
        }
        return webLogicEjbJar.getReferenceJndiName(ejbName, referenceName);
    }

    @Override
    public String findMessageDestinationName(String mdbName) throws ConfigurationException {
        return this.weblogicEjbJar.getDestinationJndiName(mdbName);
    }

    private EjbJarModel genereateWeblogicEjbJar() {
        return EjbJarModel.generate(this.serverVersion);
    }

    private abstract class WeblogicEjbJarModifier
    implements ConfigurationModifier.DescriptorModifier<EjbJarModel> {
        private WeblogicEjbJarModifier() {
        }

        @Override
        public EjbJarModel load() throws IOException {
            return EjbDeploymentConfiguration.this.getWeblogicEjbJar();
        }

        @Override
        public EjbJarModel load(byte[] source) throws IOException {
            return EjbJarModel.forInputStream(new ByteArrayInputStream(source));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void save(EjbJarModel context) {
            EjbDeploymentConfiguration ejbDeploymentConfiguration = EjbDeploymentConfiguration.this;
            synchronized (ejbDeploymentConfiguration) {
                EjbDeploymentConfiguration.this.weblogicEjbJar = context;
            }
        }
    }
}

