/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeInstanceHealthRequest
extends AmazonWebServiceRequest {
    private String loadBalancerName;
    private List<Instance> instances;

    public DescribeInstanceHealthRequest() {
    }

    public DescribeInstanceHealthRequest(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public DescribeInstanceHealthRequest withLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
        return this;
    }

    public List<Instance> getInstances() {
        if (this.instances == null) {
            this.instances = new ArrayList<Instance>();
        }
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        ArrayList<Instance> instancesCopy = new ArrayList<Instance>();
        if (instances != null) {
            instancesCopy.addAll(instances);
        }
        this.instances = instancesCopy;
    }

    public DescribeInstanceHealthRequest withInstances(Instance ... instances) {
        for (Instance value : instances) {
            this.getInstances().add(value);
        }
        return this;
    }

    public DescribeInstanceHealthRequest withInstances(Collection<Instance> instances) {
        ArrayList<Instance> instancesCopy = new ArrayList<Instance>();
        if (instances != null) {
            instancesCopy.addAll(instances);
        }
        this.instances = instancesCopy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("LoadBalancerName: " + this.loadBalancerName + ", ");
        sb.append("Instances: " + this.instances + ", ");
        sb.append("}");
        return sb.toString();
    }
}

