/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.Collection;
import java.util.Iterator;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmFunctionDefinitionResolver;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;

public class FunctionDefinitionResolverImpl
extends CsmFunctionDefinitionResolver {
    public Collection<CsmOffsetableDeclaration> findDeclarationByName(CsmProject project, String name) {
        if (project instanceof ProjectBase) {
            Collection<CsmOffsetableDeclaration> decls = ((ProjectBase)project).findDeclarationsByPrefix("" + Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_DEFINITION) + ':' + name);
            decls.addAll(((ProjectBase)project).findDeclarationsByPrefix("" + Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION) + ':' + name));
            return decls;
        }
        return null;
    }

    public CsmReference getFunctionDefinition(CsmFunction referencedFunction) {
        CsmFile containingFile = referencedFunction.getContainingFile();
        Iterator externalDeclarations = CsmSelect.getExternalDeclarations((CsmFile)containingFile);
        if (externalDeclarations != null) {
            while (externalDeclarations.hasNext()) {
                CsmFunction f;
                CsmFunctionDefinition definition;
                CsmOffsetableDeclaration next = (CsmOffsetableDeclaration)externalDeclarations.next();
                if (next.getStartOffset() != referencedFunction.getStartOffset() || referencedFunction.equals(next) || !CsmKindUtilities.isFunctionDeclaration((CsmObject)next) || !CharSequenceUtilities.textEquals((CharSequence)referencedFunction.getSignature(), (CharSequence)((CsmFunction)next).getSignature()) || (definition = (f = (CsmFunction)next).getDefinition()) == null) continue;
                return new CsmReferenceImpl(definition);
            }
        }
        return null;
    }

    private static class CsmReferenceImpl
    implements CsmReference {
        private final CsmFunctionDefinition definition;

        public CsmReferenceImpl(CsmFunctionDefinition definition) {
            this.definition = definition;
        }

        public CsmReferenceKind getKind() {
            return CsmReferenceKind.DEFINITION;
        }

        public CsmObject getReferencedObject() {
            return this.definition;
        }

        public CsmObject getOwner() {
            return this.definition;
        }

        public CsmObject getClosestTopLevelObject() {
            return this.definition;
        }

        public CsmFile getContainingFile() {
            return this.definition.getContainingFile();
        }

        public int getStartOffset() {
            return this.definition.getStartOffset();
        }

        public int getEndOffset() {
            return this.definition.getEndOffset();
        }

        public CsmOffsetable.Position getStartPosition() {
            return this.definition.getStartPosition();
        }

        public CsmOffsetable.Position getEndPosition() {
            return this.definition.getEndPosition();
        }

        public CharSequence getText() {
            return this.definition.getText();
        }
    }
}

